/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializerBase;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryArray;
import org.apache.flink.table.dataformat.BinaryArrayWriter;
import org.apache.flink.table.dataformat.BinaryGeneric;
import org.apache.flink.table.dataformat.BinaryMap;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.BinaryWriter;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.GenericArray;
import org.apache.flink.table.dataformat.GenericMap;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.dataformat.TypeGetterSetters;
import org.apache.flink.table.runtime.functions.SqlDateTimeUtils;
import org.apache.flink.table.runtime.types.InternalSerializers;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.runtime.types.TypeInfoDataTypeConverter;
import org.apache.flink.table.runtime.typeutils.BigDecimalTypeInfo;
import org.apache.flink.table.runtime.typeutils.BinaryStringTypeInfo;
import org.apache.flink.table.runtime.typeutils.DecimalTypeInfo;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TypeInformationAnyType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;
import scala.Product;

public class DataFormatConverters {
    private static final Map<DataType, DataFormatConverter> TYPE_TO_CONVERTER;

    public static DataFormatConverter getConverterForDataType(DataType originDataType) {
        DataType dataType = originDataType.nullable();
        DataFormatConverter converter = TYPE_TO_CONVERTER.get(dataType);
        if (converter != null) {
            return converter;
        }
        Class clazz = dataType.getConversionClass();
        LogicalType logicalType = dataType.getLogicalType();
        switch (logicalType.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                if (clazz == String.class) {
                    return StringConverter.INSTANCE;
                }
                if (clazz == BinaryString.class) {
                    return BinaryStringConverter.INSTANCE;
                }
                throw new RuntimeException("Not support class for VARCHAR: " + clazz);
            }
            case BINARY: 
            case VARBINARY: {
                return PrimitiveByteArrayConverter.INSTANCE;
            }
            case DECIMAL: {
                Tuple2<Integer, Integer> ps = DataFormatConverters.getPrecision(logicalType);
                if (clazz == BigDecimal.class) {
                    return new BigDecimalConverter((Integer)ps.f0, (Integer)ps.f1);
                }
                return new DecimalConverter((Integer)ps.f0, (Integer)ps.f1);
            }
            case ARRAY: {
                if (clazz == BinaryArray.class) {
                    return BinaryArrayConverter.INSTANCE;
                }
                if (clazz == boolean[].class) {
                    return PrimitiveBooleanArrayConverter.INSTANCE;
                }
                if (clazz == short[].class) {
                    return PrimitiveShortArrayConverter.INSTANCE;
                }
                if (clazz == int[].class) {
                    return PrimitiveIntArrayConverter.INSTANCE;
                }
                if (clazz == long[].class) {
                    return PrimitiveLongArrayConverter.INSTANCE;
                }
                if (clazz == float[].class) {
                    return PrimitiveFloatArrayConverter.INSTANCE;
                }
                if (clazz == double[].class) {
                    return PrimitiveDoubleArrayConverter.INSTANCE;
                }
                if (dataType instanceof CollectionDataType) {
                    return new ObjectArrayConverter(((CollectionDataType)dataType).getElementDataType().bridgedTo(clazz.getComponentType()));
                }
                BasicArrayTypeInfo typeInfo = (BasicArrayTypeInfo)((LegacyTypeInformationType)dataType.getLogicalType()).getTypeInformation();
                return new ObjectArrayConverter(TypeConversions.fromLegacyInfoToDataType((TypeInformation)typeInfo.getComponentInfo()).bridgedTo(clazz.getComponentType()));
            }
            case MAP: {
                if (clazz == BinaryMap.class) {
                    return BinaryMapConverter.INSTANCE;
                }
                KeyValueDataType keyValueDataType = (KeyValueDataType)dataType;
                return new MapConverter(keyValueDataType.getKeyDataType(), keyValueDataType.getValueDataType());
            }
            case MULTISET: {
                if (clazz == BinaryMap.class) {
                    return BinaryMapConverter.INSTANCE;
                }
                CollectionDataType collectionDataType = (CollectionDataType)dataType;
                return new MapConverter(collectionDataType.getElementDataType(), DataTypes.INT().bridgedTo(Integer.class));
            }
            case ROW: 
            case STRUCTURED_TYPE: {
                CompositeType compositeType = (CompositeType)TypeInfoDataTypeConverter.fromDataTypeToTypeInfo(dataType);
                DataType[] fieldTypes = (DataType[])Stream.iterate(0, x -> x + 1).limit(compositeType.getArity()).map(arg_0 -> ((CompositeType)compositeType).getTypeAt(arg_0)).map(TypeConversions::fromLegacyInfoToDataType).toArray(DataType[]::new);
                if (clazz == BaseRow.class) {
                    return new BaseRowConverter(compositeType.getArity());
                }
                if (clazz == Row.class) {
                    return new RowConverter(fieldTypes);
                }
                if (Tuple.class.isAssignableFrom(clazz)) {
                    return new TupleConverter(clazz, fieldTypes);
                }
                if (Product.class.isAssignableFrom(clazz)) {
                    return new CaseClassConverter((TupleTypeInfoBase)compositeType, fieldTypes);
                }
                return new PojoConverter((PojoTypeInfo)compositeType, fieldTypes);
            }
            case ANY: {
                TypeInformation typeInfo;
                TypeInformation typeInformation = typeInfo = logicalType instanceof LegacyTypeInformationType ? ((LegacyTypeInformationType)logicalType).getTypeInformation() : ((TypeInformationAnyType)logicalType).getTypeInformation();
                if (typeInfo instanceof BinaryStringTypeInfo) {
                    return BinaryStringConverter.INSTANCE;
                }
                if (typeInfo instanceof DecimalTypeInfo) {
                    DecimalTypeInfo decimalType = (DecimalTypeInfo)typeInfo;
                    return new DecimalConverter(decimalType.precision(), decimalType.scale());
                }
                if (typeInfo instanceof BigDecimalTypeInfo) {
                    BigDecimalTypeInfo decimalType = (BigDecimalTypeInfo)typeInfo;
                    return new BigDecimalConverter(decimalType.precision(), decimalType.scale());
                }
                if (clazz == BinaryGeneric.class) {
                    return BinaryGenericConverter.INSTANCE;
                }
                return new GenericConverter(typeInfo.createSerializer(new ExecutionConfig()));
            }
        }
        throw new RuntimeException("Not support dataType: " + dataType);
    }

    private static Tuple2<Integer, Integer> getPrecision(LogicalType logicalType) {
        Tuple2 ps = new Tuple2();
        if (logicalType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)logicalType;
            ps.f0 = decimalType.getPrecision();
            ps.f1 = decimalType.getScale();
        } else {
            TypeInformation typeInfo = ((LegacyTypeInformationType)logicalType).getTypeInformation();
            if (typeInfo instanceof BigDecimalTypeInfo) {
                BigDecimalTypeInfo decimalType = (BigDecimalTypeInfo)typeInfo;
                ps.f0 = decimalType.precision();
                ps.f1 = decimalType.scale();
            } else if (typeInfo instanceof DecimalTypeInfo) {
                DecimalTypeInfo decimalType = (DecimalTypeInfo)typeInfo;
                ps.f0 = decimalType.precision();
                ps.f1 = decimalType.scale();
            } else {
                ps.f0 = Decimal.DECIMAL_SYSTEM_DEFAULT.getPrecision();
                ps.f1 = Decimal.DECIMAL_SYSTEM_DEFAULT.getScale();
            }
        }
        return ps;
    }

    private static <T> T[] genericArrayToJavaArray(GenericArray value, LogicalType eleType) {
        Object array = value.getArray();
        if (value.isPrimitiveArray()) {
            switch (eleType.getTypeRoot()) {
                case BOOLEAN: {
                    return ArrayUtils.toObject((boolean[])((boolean[])array));
                }
                case TINYINT: {
                    return ArrayUtils.toObject((byte[])((byte[])array));
                }
                case SMALLINT: {
                    return ArrayUtils.toObject((short[])((short[])array));
                }
                case INTEGER: {
                    return ArrayUtils.toObject((int[])((int[])array));
                }
                case BIGINT: {
                    return ArrayUtils.toObject((long[])((long[])array));
                }
                case FLOAT: {
                    return ArrayUtils.toObject((float[])((float[])array));
                }
                case DOUBLE: {
                    return ArrayUtils.toObject((double[])((double[])array));
                }
            }
            throw new RuntimeException("Not a primitive type: " + eleType);
        }
        return (Object[])array;
    }

    private static <T> T[] binaryArrayToJavaArray(BinaryArray value, LogicalType elementType, Class<T> componentClass, DataFormatConverter<Object, T> elementConverter) {
        int size = value.numElements();
        Object[] values = (Object[])Array.newInstance(componentClass, size);
        for (int i = 0; i < size; ++i) {
            values[i] = value.isNullAt(i) ? null : elementConverter.toExternalImpl(TypeGetterSetters.get(value, i, elementType));
        }
        return values;
    }

    static {
        HashMap<DataType, DataFormatConverter> t2C = new HashMap<DataType, DataFormatConverter>();
        t2C.put(DataTypes.BOOLEAN().bridgedTo(Boolean.class), BooleanConverter.INSTANCE);
        t2C.put(DataTypes.BOOLEAN().bridgedTo(Boolean.TYPE), BooleanConverter.INSTANCE);
        t2C.put(DataTypes.INT().bridgedTo(Integer.class), IntConverter.INSTANCE);
        t2C.put(DataTypes.INT().bridgedTo(Integer.TYPE), IntConverter.INSTANCE);
        t2C.put(DataTypes.BIGINT().bridgedTo(Long.class), LongConverter.INSTANCE);
        t2C.put(DataTypes.BIGINT().bridgedTo(Long.TYPE), LongConverter.INSTANCE);
        t2C.put(DataTypes.SMALLINT().bridgedTo(Short.class), ShortConverter.INSTANCE);
        t2C.put(DataTypes.SMALLINT().bridgedTo(Short.TYPE), ShortConverter.INSTANCE);
        t2C.put(DataTypes.FLOAT().bridgedTo(Float.class), FloatConverter.INSTANCE);
        t2C.put(DataTypes.FLOAT().bridgedTo(Float.TYPE), FloatConverter.INSTANCE);
        t2C.put(DataTypes.DOUBLE().bridgedTo(Double.class), DoubleConverter.INSTANCE);
        t2C.put(DataTypes.DOUBLE().bridgedTo(Double.TYPE), DoubleConverter.INSTANCE);
        t2C.put(DataTypes.TINYINT().bridgedTo(Byte.class), ByteConverter.INSTANCE);
        t2C.put(DataTypes.TINYINT().bridgedTo(Byte.TYPE), ByteConverter.INSTANCE);
        t2C.put(DataTypes.DATE().bridgedTo(Date.class), DateConverter.INSTANCE);
        t2C.put(DataTypes.DATE().bridgedTo(LocalDate.class), LocalDateConverter.INSTANCE);
        t2C.put(DataTypes.DATE().bridgedTo(Integer.class), IntConverter.INSTANCE);
        t2C.put(DataTypes.DATE().bridgedTo(Integer.TYPE), IntConverter.INSTANCE);
        t2C.put(DataTypes.TIME().bridgedTo(Time.class), TimeConverter.INSTANCE);
        t2C.put(DataTypes.TIME().bridgedTo(LocalTime.class), LocalTimeConverter.INSTANCE);
        t2C.put(DataTypes.TIME().bridgedTo(Integer.class), IntConverter.INSTANCE);
        t2C.put(DataTypes.TIME().bridgedTo(Integer.TYPE), IntConverter.INSTANCE);
        t2C.put(DataTypes.TIMESTAMP((int)3).bridgedTo(Timestamp.class), TimestampConverter.INSTANCE);
        t2C.put(DataTypes.TIMESTAMP((int)3).bridgedTo(LocalDateTime.class), LocalDateTimeConverter.INSTANCE);
        t2C.put(DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).bridgedTo(Long.class), LongConverter.INSTANCE);
        t2C.put(DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).bridgedTo(Instant.class), InstantConverter.INSTANCE);
        t2C.put(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()).bridgedTo(Integer.class), IntConverter.INSTANCE);
        t2C.put(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()).bridgedTo(Integer.TYPE), IntConverter.INSTANCE);
        t2C.put(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND((int)3)).bridgedTo(Long.class), LongConverter.INSTANCE);
        t2C.put(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND((int)3)).bridgedTo(Long.TYPE), LongConverter.INSTANCE);
        TYPE_TO_CONVERTER = Collections.unmodifiableMap(t2C);
    }

    public static final class CaseClassConverter
    extends AbstractBaseRowConverter<Product> {
        private static final long serialVersionUID = -966598627968372952L;
        private final TupleTypeInfoBase t;
        private final TupleSerializerBase serializer;

        public CaseClassConverter(TupleTypeInfoBase t, DataType[] fieldTypes) {
            super(fieldTypes);
            this.t = t;
            this.serializer = (TupleSerializerBase)t.createSerializer(new ExecutionConfig());
        }

        @Override
        BaseRow toInternalImpl(Product value) {
            GenericRow genericRow = new GenericRow(this.t.getArity());
            for (int i = 0; i < this.t.getArity(); ++i) {
                genericRow.setField(i, this.converters[i].toInternal(value.productElement(i)));
            }
            return genericRow;
        }

        @Override
        Product toExternalImpl(BaseRow value) {
            Object[] fields = new Object[this.t.getArity()];
            for (int i = 0; i < this.t.getArity(); ++i) {
                fields[i] = this.converters[i].toExternal(value, i);
            }
            return (Product)this.serializer.createInstance(fields);
        }
    }

    public static final class TupleConverter
    extends AbstractBaseRowConverter<Tuple> {
        private static final long serialVersionUID = 2794892691010934194L;
        private final Class<Tuple> clazz;

        public TupleConverter(Class<Tuple> clazz, DataType[] fieldTypes) {
            super(fieldTypes);
            this.clazz = clazz;
        }

        @Override
        BaseRow toInternalImpl(Tuple value) {
            GenericRow genericRow = new GenericRow(this.converters.length);
            for (int i = 0; i < this.converters.length; ++i) {
                genericRow.setField(i, this.converters[i].toInternal(value.getField(i)));
            }
            return genericRow;
        }

        @Override
        Tuple toExternalImpl(BaseRow value) {
            try {
                Tuple tuple = this.clazz.newInstance();
                for (int i = 0; i < this.converters.length; ++i) {
                    tuple.setField(this.converters[i].toExternal(value, i), i);
                }
                return tuple;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static final class RowConverter
    extends AbstractBaseRowConverter<Row> {
        private static final long serialVersionUID = -56553502075225785L;

        public RowConverter(DataType[] fieldTypes) {
            super(fieldTypes);
        }

        @Override
        BaseRow toInternalImpl(Row value) {
            GenericRow genericRow = new GenericRow(this.converters.length);
            for (int i = 0; i < this.converters.length; ++i) {
                genericRow.setField(i, this.converters[i].toInternal(value.getField(i)));
            }
            return genericRow;
        }

        @Override
        Row toExternalImpl(BaseRow value) {
            Row row = new Row(this.converters.length);
            for (int i = 0; i < this.converters.length; ++i) {
                row.setField(i, this.converters[i].toExternal(value, i));
            }
            return row;
        }
    }

    public static final class PojoConverter<T>
    extends AbstractBaseRowConverter<T> {
        private static final long serialVersionUID = 6821541780176167135L;
        private final PojoTypeInfo<T> t;
        private final PojoField[] fields;

        public PojoConverter(PojoTypeInfo<T> t, DataType[] fieldTypes) {
            super(fieldTypes);
            this.fields = new PojoField[t.getArity()];
            for (int i = 0; i < t.getArity(); ++i) {
                this.fields[i] = t.getPojoFieldAt(i);
                this.fields[i].getField().setAccessible(true);
            }
            this.t = t;
        }

        @Override
        BaseRow toInternalImpl(T value) {
            GenericRow genericRow = new GenericRow(this.t.getArity());
            for (int i = 0; i < this.t.getArity(); ++i) {
                try {
                    genericRow.setField(i, this.converters[i].toInternal(this.fields[i].getField().get(value)));
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            return genericRow;
        }

        @Override
        T toExternalImpl(BaseRow value) {
            try {
                Object pojo = this.t.getTypeClass().newInstance();
                for (int i = 0; i < this.t.getArity(); ++i) {
                    this.fields[i].getField().set(pojo, this.converters[i].toExternal(value, i));
                }
                return pojo;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static final class BaseRowConverter
    extends IdentityConverter<BaseRow> {
        private static final long serialVersionUID = -4470307402371540680L;
        private int arity;

        private BaseRowConverter(int arity) {
        }

        @Override
        BaseRow toExternalImpl(BaseRow row, int column) {
            return row.getRow(column, this.arity);
        }
    }

    public static abstract class AbstractBaseRowConverter<E>
    extends DataFormatConverter<BaseRow, E> {
        private static final long serialVersionUID = 4365740929854771618L;
        protected final DataFormatConverter[] converters;

        public AbstractBaseRowConverter(DataType[] fieldTypes) {
            this.converters = new DataFormatConverter[fieldTypes.length];
            for (int i = 0; i < this.converters.length; ++i) {
                this.converters[i] = DataFormatConverters.getConverterForDataType(fieldTypes[i]);
            }
        }

        @Override
        E toExternalImpl(BaseRow row, int column) {
            return (E)this.toExternalImpl(row.getRow(column, this.converters.length));
        }
    }

    public static final class MapConverter
    extends DataFormatConverter<BaseMap, Map> {
        private static final long serialVersionUID = -916429669828309919L;
        private final LogicalType keyType;
        private final LogicalType valueType;
        private final DataFormatConverter keyConverter;
        private final DataFormatConverter valueConverter;
        private final int keyElementSize;
        private final int valueElementSize;
        private final Class keyComponentClass;
        private final Class valueComponentClass;
        private final TypeSerializer keySer;
        private final TypeSerializer valueSer;
        private final boolean isKeyValueIndentity;
        private transient BinaryArray reuseKArray;
        private transient BinaryArrayWriter reuseKWriter;
        private transient BinaryArray reuseVArray;
        private transient BinaryArrayWriter reuseVWriter;

        public MapConverter(DataType keyTypeInfo, DataType valueTypeInfo) {
            this.keyType = LogicalTypeDataTypeConverter.fromDataTypeToLogicalType(keyTypeInfo);
            this.valueType = LogicalTypeDataTypeConverter.fromDataTypeToLogicalType(valueTypeInfo);
            this.keyConverter = DataFormatConverters.getConverterForDataType(keyTypeInfo);
            this.valueConverter = DataFormatConverters.getConverterForDataType(valueTypeInfo);
            this.keyElementSize = BinaryArray.calculateFixLengthPartSize(this.keyType);
            this.valueElementSize = BinaryArray.calculateFixLengthPartSize(this.valueType);
            this.keyComponentClass = keyTypeInfo.getConversionClass();
            this.valueComponentClass = valueTypeInfo.getConversionClass();
            this.isKeyValueIndentity = this.keyConverter instanceof IdentityConverter && this.valueConverter instanceof IdentityConverter;
            this.keySer = InternalSerializers.create(this.keyType, new ExecutionConfig());
            this.valueSer = InternalSerializers.create(this.valueType, new ExecutionConfig());
        }

        @Override
        BaseMap toInternalImpl(Map value) {
            return this.isKeyValueIndentity ? new GenericMap(value) : this.toBinaryMap(value);
        }

        private BinaryMap toBinaryMap(Map value) {
            if (this.reuseKArray == null) {
                this.reuseKArray = new BinaryArray();
                this.reuseVArray = new BinaryArray();
            }
            if (this.reuseKWriter == null || this.reuseKWriter.getNumElements() != value.size()) {
                this.reuseKWriter = new BinaryArrayWriter(this.reuseKArray, value.size(), this.keyElementSize);
                this.reuseVWriter = new BinaryArrayWriter(this.reuseVArray, value.size(), this.valueElementSize);
            } else {
                this.reuseKWriter.reset();
                this.reuseVWriter.reset();
            }
            int i = 0;
            for (Map.Entry entry : value.entrySet()) {
                if (entry.getKey() == null) {
                    this.reuseKWriter.setNullAt(i, this.keyType);
                } else {
                    BinaryWriter.write(this.reuseKWriter, i, this.keyConverter.toInternalImpl(entry.getKey()), this.keyType, this.keySer);
                }
                if (entry.getValue() == null) {
                    this.reuseVWriter.setNullAt(i, this.valueType);
                } else {
                    BinaryWriter.write(this.reuseVWriter, i, this.valueConverter.toInternalImpl(entry.getValue()), this.valueType, this.valueSer);
                }
                ++i;
            }
            this.reuseKWriter.complete();
            this.reuseVWriter.complete();
            return BinaryMap.valueOf(this.reuseKArray, this.reuseVArray);
        }

        @Override
        Map toExternalImpl(BaseMap value) {
            return this.isKeyValueIndentity && value instanceof GenericMap ? ((GenericMap)value).getMap() : this.binaryMapToMap((BinaryMap)value);
        }

        private Map binaryMapToMap(BinaryMap value) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            Object[] keys = DataFormatConverters.binaryArrayToJavaArray(value.keyArray(), this.keyType, this.keyComponentClass, this.keyConverter);
            Object[] values = DataFormatConverters.binaryArrayToJavaArray(value.valueArray(), this.valueType, this.valueComponentClass, this.valueConverter);
            for (int i = 0; i < value.numElements(); ++i) {
                map.put(keys[i], values[i]);
            }
            return map;
        }

        @Override
        Map toExternalImpl(BaseRow row, int column) {
            return this.toExternalImpl(row.getMap(column));
        }
    }

    public static final class ObjectArrayConverter<T>
    extends DataFormatConverter<BaseArray, T[]> {
        private static final long serialVersionUID = -7434682160639380078L;
        private final Class<T> componentClass;
        private final LogicalType elementType;
        private final DataFormatConverter<Object, T> elementConverter;
        private final int elementSize;
        private final TypeSerializer<T> eleSer;
        private final boolean isEleIndentity;
        private transient BinaryArray reuseArray;
        private transient BinaryArrayWriter reuseWriter;

        public ObjectArrayConverter(DataType elementType) {
            this.componentClass = elementType.getConversionClass();
            this.elementType = LogicalTypeDataTypeConverter.fromDataTypeToLogicalType(elementType);
            this.elementConverter = DataFormatConverters.getConverterForDataType(elementType);
            this.elementSize = BinaryArray.calculateFixLengthPartSize(this.elementType);
            this.eleSer = InternalSerializers.create(this.elementType, new ExecutionConfig());
            this.isEleIndentity = this.elementConverter instanceof IdentityConverter;
        }

        @Override
        BaseArray toInternalImpl(T[] value) {
            return this.isEleIndentity ? new GenericArray(value, value.length) : this.toBinaryArray(value);
        }

        private BaseArray toBinaryArray(T[] value) {
            if (this.reuseArray == null) {
                this.reuseArray = new BinaryArray();
            }
            if (this.reuseWriter == null || this.reuseWriter.getNumElements() != value.length) {
                this.reuseWriter = new BinaryArrayWriter(this.reuseArray, value.length, this.elementSize);
            } else {
                this.reuseWriter.reset();
            }
            for (int i = 0; i < value.length; ++i) {
                T field = value[i];
                if (field == null) {
                    this.reuseWriter.setNullAt(i, this.elementType);
                    continue;
                }
                BinaryWriter.write(this.reuseWriter, i, this.elementConverter.toInternalImpl(value[i]), this.elementType, this.eleSer);
            }
            this.reuseWriter.complete();
            return this.reuseArray;
        }

        @Override
        T[] toExternalImpl(BaseArray value) {
            return this.isEleIndentity && value instanceof GenericArray ? DataFormatConverters.genericArrayToJavaArray((GenericArray)value, this.elementType) : DataFormatConverters.binaryArrayToJavaArray((BinaryArray)value, this.elementType, this.componentClass, this.elementConverter);
        }

        @Override
        T[] toExternalImpl(BaseRow row, int column) {
            return this.toExternalImpl(row.getArray(column));
        }
    }

    public static final class PrimitiveDoubleArrayConverter
    extends DataFormatConverter<BaseArray, double[]> {
        private static final long serialVersionUID = 6333670535356315691L;
        public static final PrimitiveDoubleArrayConverter INSTANCE = new PrimitiveDoubleArrayConverter();

        private PrimitiveDoubleArrayConverter() {
        }

        @Override
        BaseArray toInternalImpl(double[] value) {
            return new GenericArray(value, value.length, true);
        }

        @Override
        double[] toExternalImpl(BaseArray value) {
            return value.toDoubleArray();
        }

        @Override
        double[] toExternalImpl(BaseRow row, int column) {
            return this.toExternalImpl(row.getArray(column));
        }
    }

    public static final class PrimitiveFloatArrayConverter
    extends DataFormatConverter<BaseArray, float[]> {
        private static final long serialVersionUID = -3237695040861141459L;
        public static final PrimitiveFloatArrayConverter INSTANCE = new PrimitiveFloatArrayConverter();

        private PrimitiveFloatArrayConverter() {
        }

        @Override
        BaseArray toInternalImpl(float[] value) {
            return new GenericArray(value, value.length, true);
        }

        @Override
        float[] toExternalImpl(BaseArray value) {
            return value.toFloatArray();
        }

        @Override
        float[] toExternalImpl(BaseRow row, int column) {
            return this.toExternalImpl(row.getArray(column));
        }
    }

    public static final class PrimitiveLongArrayConverter
    extends DataFormatConverter<BaseArray, long[]> {
        private static final long serialVersionUID = 4061982985342526078L;
        public static final PrimitiveLongArrayConverter INSTANCE = new PrimitiveLongArrayConverter();

        private PrimitiveLongArrayConverter() {
        }

        @Override
        BaseArray toInternalImpl(long[] value) {
            return new GenericArray(value, value.length, true);
        }

        @Override
        long[] toExternalImpl(BaseArray value) {
            return value.toLongArray();
        }

        @Override
        long[] toExternalImpl(BaseRow row, int column) {
            return this.toExternalImpl(row.getArray(column));
        }
    }

    public static final class PrimitiveShortArrayConverter
    extends DataFormatConverter<BaseArray, short[]> {
        private static final long serialVersionUID = -1343184089311186834L;
        public static final PrimitiveShortArrayConverter INSTANCE = new PrimitiveShortArrayConverter();

        private PrimitiveShortArrayConverter() {
        }

        @Override
        BaseArray toInternalImpl(short[] value) {
            return new GenericArray(value, value.length, true);
        }

        @Override
        short[] toExternalImpl(BaseArray value) {
            return value.toShortArray();
        }

        @Override
        short[] toExternalImpl(BaseRow row, int column) {
            return this.toExternalImpl(row.getArray(column));
        }
    }

    public static final class PrimitiveByteArrayConverter
    extends IdentityConverter<byte[]> {
        private static final long serialVersionUID = -2007960927801689921L;
        public static final PrimitiveByteArrayConverter INSTANCE = new PrimitiveByteArrayConverter();

        private PrimitiveByteArrayConverter() {
        }

        @Override
        byte[] toExternalImpl(BaseRow row, int column) {
            return row.getBinary(column);
        }
    }

    public static final class PrimitiveBooleanArrayConverter
    extends DataFormatConverter<BaseArray, boolean[]> {
        private static final long serialVersionUID = -4037693692440282141L;
        public static final PrimitiveBooleanArrayConverter INSTANCE = new PrimitiveBooleanArrayConverter();

        private PrimitiveBooleanArrayConverter() {
        }

        @Override
        BaseArray toInternalImpl(boolean[] value) {
            return new GenericArray(value, value.length, true);
        }

        @Override
        boolean[] toExternalImpl(BaseArray value) {
            return value.toBooleanArray();
        }

        @Override
        boolean[] toExternalImpl(BaseRow row, int column) {
            return this.toExternalImpl(row.getArray(column));
        }
    }

    public static final class PrimitiveIntArrayConverter
    extends DataFormatConverter<BaseArray, int[]> {
        private static final long serialVersionUID = 1780941126232395638L;
        public static final PrimitiveIntArrayConverter INSTANCE = new PrimitiveIntArrayConverter();

        private PrimitiveIntArrayConverter() {
        }

        @Override
        BaseArray toInternalImpl(int[] value) {
            return new GenericArray(value, value.length, true);
        }

        @Override
        int[] toExternalImpl(BaseArray value) {
            return value.toIntArray();
        }

        @Override
        int[] toExternalImpl(BaseRow row, int column) {
            return this.toExternalImpl(row.getArray(column));
        }
    }

    public static final class TimestampConverter
    extends DataFormatConverter<Long, Timestamp> {
        private static final long serialVersionUID = -779956524906131757L;
        public static final TimestampConverter INSTANCE = new TimestampConverter();

        private TimestampConverter() {
        }

        @Override
        Long toInternalImpl(Timestamp value) {
            return SqlDateTimeUtils.timestampToInternal(value);
        }

        @Override
        Timestamp toExternalImpl(Long value) {
            return SqlDateTimeUtils.internalToTimestamp(value);
        }

        @Override
        Timestamp toExternalImpl(BaseRow row, int column) {
            return this.toExternalImpl(row.getLong(column));
        }
    }

    public static final class TimeConverter
    extends DataFormatConverter<Integer, Time> {
        private static final long serialVersionUID = -8061475784916442483L;
        public static final TimeConverter INSTANCE = new TimeConverter();

        private TimeConverter() {
        }

        @Override
        Integer toInternalImpl(Time value) {
            return SqlDateTimeUtils.timeToInternal(value);
        }

        @Override
        Time toExternalImpl(Integer value) {
            return SqlDateTimeUtils.internalToTime(value);
        }

        @Override
        Time toExternalImpl(BaseRow row, int column) {
            return this.toExternalImpl(row.getInt(column));
        }
    }

    public static final class DateConverter
    extends DataFormatConverter<Integer, Date> {
        private static final long serialVersionUID = 1343457113582411650L;
        public static final DateConverter INSTANCE = new DateConverter();

        private DateConverter() {
        }

        @Override
        Integer toInternalImpl(Date value) {
            return SqlDateTimeUtils.dateToInternal(value);
        }

        @Override
        Date toExternalImpl(Integer value) {
            return SqlDateTimeUtils.internalToDate(value);
        }

        @Override
        Date toExternalImpl(BaseRow row, int column) {
            return this.toExternalImpl(row.getInt(column));
        }
    }

    public static final class InstantConverter
    extends DataFormatConverter<Long, Instant> {
        private static final long serialVersionUID = 1L;
        public static final InstantConverter INSTANCE = new InstantConverter();

        private InstantConverter() {
        }

        @Override
        Long toInternalImpl(Instant value) {
            return value.toEpochMilli();
        }

        @Override
        Instant toExternalImpl(Long value) {
            return Instant.ofEpochMilli(value);
        }

        @Override
        Instant toExternalImpl(BaseRow row, int column) {
            return this.toExternalImpl(row.getLong(column));
        }
    }

    public static final class LocalDateTimeConverter
    extends DataFormatConverter<Long, LocalDateTime> {
        private static final long serialVersionUID = 1L;
        public static final LocalDateTimeConverter INSTANCE = new LocalDateTimeConverter();

        private LocalDateTimeConverter() {
        }

        @Override
        Long toInternalImpl(LocalDateTime value) {
            return SqlDateTimeUtils.localDateTimeToUnixTimestamp(value);
        }

        @Override
        LocalDateTime toExternalImpl(Long value) {
            return SqlDateTimeUtils.unixTimestampToLocalDateTime(value);
        }

        @Override
        LocalDateTime toExternalImpl(BaseRow row, int column) {
            return this.toExternalImpl(row.getLong(column));
        }
    }

    public static final class LocalTimeConverter
    extends DataFormatConverter<Integer, LocalTime> {
        private static final long serialVersionUID = 1L;
        public static final LocalTimeConverter INSTANCE = new LocalTimeConverter();

        private LocalTimeConverter() {
        }

        @Override
        Integer toInternalImpl(LocalTime value) {
            return SqlDateTimeUtils.localTimeToUnixDate(value);
        }

        @Override
        LocalTime toExternalImpl(Integer value) {
            return SqlDateTimeUtils.unixTimeToLocalTime(value);
        }

        @Override
        LocalTime toExternalImpl(BaseRow row, int column) {
            return this.toExternalImpl(row.getInt(column));
        }
    }

    public static final class LocalDateConverter
    extends DataFormatConverter<Integer, LocalDate> {
        private static final long serialVersionUID = 1L;
        public static final LocalDateConverter INSTANCE = new LocalDateConverter();

        private LocalDateConverter() {
        }

        @Override
        Integer toInternalImpl(LocalDate value) {
            return SqlDateTimeUtils.localDateToUnixDate(value);
        }

        @Override
        LocalDate toExternalImpl(Integer value) {
            return SqlDateTimeUtils.unixDateToLocalDate(value);
        }

        @Override
        LocalDate toExternalImpl(BaseRow row, int column) {
            return this.toExternalImpl(row.getInt(column));
        }
    }

    public static final class GenericConverter<T>
    extends DataFormatConverter<BinaryGeneric<T>, T> {
        private static final long serialVersionUID = -3611718364918053384L;
        private final TypeSerializer<T> serializer;

        public GenericConverter(TypeSerializer<T> serializer) {
            this.serializer = serializer;
        }

        @Override
        BinaryGeneric<T> toInternalImpl(T value) {
            return new BinaryGeneric<T>(value, this.serializer);
        }

        @Override
        T toExternalImpl(BinaryGeneric<T> value) {
            return BinaryGeneric.getJavaObjectFromBinaryGeneric(value, this.serializer);
        }

        @Override
        T toExternalImpl(BaseRow row, int column) {
            return this.toExternalImpl(row.getGeneric(column));
        }
    }

    public static final class BigDecimalConverter
    extends DataFormatConverter<Decimal, BigDecimal> {
        private static final long serialVersionUID = -6586239704060565834L;
        private final int precision;
        private final int scale;

        public BigDecimalConverter(int precision, int scale) {
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        Decimal toInternalImpl(BigDecimal value) {
            return Decimal.fromBigDecimal(value, this.precision, this.scale);
        }

        @Override
        BigDecimal toExternalImpl(Decimal value) {
            return value.toBigDecimal();
        }

        @Override
        BigDecimal toExternalImpl(BaseRow row, int column) {
            return this.toExternalImpl(row.getDecimal(column, this.precision, this.scale));
        }
    }

    public static final class StringConverter
    extends DataFormatConverter<BinaryString, String> {
        private static final long serialVersionUID = 4713165079099282774L;
        public static final StringConverter INSTANCE = new StringConverter();

        private StringConverter() {
        }

        @Override
        BinaryString toInternalImpl(String value) {
            return BinaryString.fromString(value);
        }

        @Override
        String toExternalImpl(BinaryString value) {
            return value.toString();
        }

        @Override
        String toExternalImpl(BaseRow row, int column) {
            return row.getString(column).toString();
        }
    }

    public static final class BinaryGenericConverter
    extends IdentityConverter<BinaryGeneric> {
        private static final long serialVersionUID = 1436229503920584273L;
        public static final BinaryGenericConverter INSTANCE = new BinaryGenericConverter();

        private BinaryGenericConverter() {
        }

        @Override
        BinaryGeneric toExternalImpl(BaseRow row, int column) {
            return row.getGeneric(column);
        }
    }

    public static final class DecimalConverter
    extends IdentityConverter<Decimal> {
        private static final long serialVersionUID = 3825744951173809617L;
        private final int precision;
        private final int scale;

        public DecimalConverter(int precision, int scale) {
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        Decimal toExternalImpl(BaseRow row, int column) {
            return row.getDecimal(column, this.precision, this.scale);
        }
    }

    public static final class BinaryMapConverter
    extends IdentityConverter<BaseMap> {
        private static final long serialVersionUID = -9114231688474126815L;
        public static final BinaryMapConverter INSTANCE = new BinaryMapConverter();

        private BinaryMapConverter() {
        }

        @Override
        BaseMap toExternalImpl(BaseRow row, int column) {
            return row.getMap(column);
        }
    }

    public static final class BinaryArrayConverter
    extends IdentityConverter<BaseArray> {
        private static final long serialVersionUID = -7790350668043604641L;
        public static final BinaryArrayConverter INSTANCE = new BinaryArrayConverter();

        private BinaryArrayConverter() {
        }

        @Override
        BaseArray toExternalImpl(BaseRow row, int column) {
            return row.getArray(column);
        }
    }

    public static final class BinaryStringConverter
    extends IdentityConverter<BinaryString> {
        private static final long serialVersionUID = 5565684451615599206L;
        public static final BinaryStringConverter INSTANCE = new BinaryStringConverter();

        private BinaryStringConverter() {
        }

        @Override
        BinaryString toExternalImpl(BaseRow row, int column) {
            return row.getString(column);
        }
    }

    public static final class DoubleConverter
    extends IdentityConverter<Double> {
        private static final long serialVersionUID = 2801171640313215040L;
        public static final DoubleConverter INSTANCE = new DoubleConverter();

        private DoubleConverter() {
        }

        @Override
        Double toExternalImpl(BaseRow row, int column) {
            return row.getDouble(column);
        }
    }

    public static final class FloatConverter
    extends IdentityConverter<Float> {
        private static final long serialVersionUID = -1119035126939832966L;
        public static final FloatConverter INSTANCE = new FloatConverter();

        private FloatConverter() {
        }

        @Override
        Float toExternalImpl(BaseRow row, int column) {
            return Float.valueOf(row.getFloat(column));
        }
    }

    public static final class LongConverter
    extends IdentityConverter<Long> {
        private static final long serialVersionUID = 7373868336730797650L;
        public static final LongConverter INSTANCE = new LongConverter();

        private LongConverter() {
        }

        @Override
        Long toExternalImpl(BaseRow row, int column) {
            return row.getLong(column);
        }
    }

    public static final class IntConverter
    extends IdentityConverter<Integer> {
        private static final long serialVersionUID = -7749307898273403416L;
        public static final IntConverter INSTANCE = new IntConverter();

        private IntConverter() {
        }

        @Override
        Integer toExternalImpl(BaseRow row, int column) {
            return row.getInt(column);
        }
    }

    public static final class ShortConverter
    extends IdentityConverter<Short> {
        private static final long serialVersionUID = 8055034507232206636L;
        public static final ShortConverter INSTANCE = new ShortConverter();

        private ShortConverter() {
        }

        @Override
        Short toExternalImpl(BaseRow row, int column) {
            return row.getShort(column);
        }
    }

    public static final class ByteConverter
    extends IdentityConverter<Byte> {
        private static final long serialVersionUID = 1880134895918999433L;
        public static final ByteConverter INSTANCE = new ByteConverter();

        private ByteConverter() {
        }

        @Override
        Byte toExternalImpl(BaseRow row, int column) {
            return row.getByte(column);
        }
    }

    public static final class BooleanConverter
    extends IdentityConverter<Boolean> {
        private static final long serialVersionUID = 3618373319753553272L;
        public static final BooleanConverter INSTANCE = new BooleanConverter();

        private BooleanConverter() {
        }

        @Override
        Boolean toExternalImpl(BaseRow row, int column) {
            return row.getBoolean(column);
        }
    }

    public static abstract class IdentityConverter<T>
    extends DataFormatConverter<T, T> {
        private static final long serialVersionUID = 6146619729108124872L;

        @Override
        T toInternalImpl(T value) {
            return value;
        }

        @Override
        T toExternalImpl(T value) {
            return value;
        }
    }

    public static abstract class DataFormatConverter<Internal, External>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public final Internal toInternal(External value) {
            return value == null ? null : (Internal)this.toInternalImpl(value);
        }

        abstract Internal toInternalImpl(External var1);

        public final External toExternal(Internal value) {
            return value == null ? null : (External)this.toExternalImpl(value);
        }

        abstract External toExternalImpl(Internal var1);

        abstract External toExternalImpl(BaseRow var1, int var2);

        public final External toExternal(BaseRow row, int column) {
            return row.isNullAt(column) ? null : (External)this.toExternalImpl(row, column);
        }
    }
}

