/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.LazyBinaryFormat;
import org.apache.flink.table.runtime.util.SegmentsUtil;
import org.apache.flink.table.runtime.util.StringUtf8Utils;
import org.apache.flink.table.utils.EncodingUtils;

public class BinaryStringUtil {
    public static final BinaryString[] EMPTY_STRING_ARRAY = new BinaryString[0];
    private static final List<BinaryString> TRUE_STRINGS = Stream.of("t", "true", "y", "yes", "1").map(BinaryString::fromString).peek(LazyBinaryFormat::ensureMaterialized).collect(Collectors.toList());
    private static final List<BinaryString> FALSE_STRINGS = Stream.of("f", "false", "n", "no", "0").map(BinaryString::fromString).peek(LazyBinaryFormat::ensureMaterialized).collect(Collectors.toList());

    private static byte[] getTmpBytes(BinaryString str, int sizeInBytes) {
        byte[] bytes = SegmentsUtil.allocateReuseBytes(sizeInBytes);
        SegmentsUtil.copyToBytes(str.getSegments(), str.getOffset(), bytes, 0, sizeInBytes);
        return bytes;
    }

    public static BinaryString[] splitByWholeSeparatorPreserveAllTokens(BinaryString str, BinaryString separator) {
        str.ensureMaterialized();
        int sizeInBytes = str.getSizeInBytes();
        MemorySegment[] segments = str.getSegments();
        int offset = str.getOffset();
        if (sizeInBytes == 0) {
            return EMPTY_STRING_ARRAY;
        }
        if (separator == null || BinaryString.EMPTY_UTF8.equals(separator)) {
            return BinaryStringUtil.splitByWholeSeparatorPreserveAllTokens(str, BinaryString.fromString(" "));
        }
        separator.ensureMaterialized();
        int sepSize = separator.getSizeInBytes();
        MemorySegment[] sepSegs = separator.getSegments();
        int sepOffset = separator.getOffset();
        ArrayList<BinaryString> substrings = new ArrayList<BinaryString>();
        int beg = 0;
        int end = 0;
        while (end < sizeInBytes) {
            end = SegmentsUtil.find(segments, offset + beg, sizeInBytes - beg, sepSegs, sepOffset, sepSize) - offset;
            if (end > -1) {
                if (end > beg) {
                    substrings.add(BinaryString.fromAddress(segments, offset + beg, end - beg));
                    beg = end + sepSize;
                    continue;
                }
                substrings.add(BinaryString.EMPTY_UTF8);
                beg = end + sepSize;
                continue;
            }
            substrings.add(BinaryString.fromAddress(segments, offset + beg, sizeInBytes - beg));
            end = sizeInBytes;
        }
        return substrings.toArray(new BinaryString[0]);
    }

    public static Boolean toBooleanSQL(BinaryString str) {
        BinaryString lowerCase = str.toLowerCase();
        return TRUE_STRINGS.contains(lowerCase) ? Boolean.TRUE : (FALSE_STRINGS.contains(lowerCase) ? Boolean.FALSE : null);
    }

    public static BinaryString hash(BinaryString str, MessageDigest md) {
        return BinaryString.fromString(EncodingUtils.hex((byte[])md.digest(str.getBytes())));
    }

    public static BinaryString hash(BinaryString str, String algorithm) throws NoSuchAlgorithmException {
        return BinaryStringUtil.hash(str, MessageDigest.getInstance(algorithm));
    }

    public static Decimal toDecimal(BinaryString str, int precision, int scale) {
        str.ensureMaterialized();
        if (precision > 18 || str.getSizeInBytes() > 18) {
            return BinaryStringUtil.toBigPrecisionDecimal(str, precision, scale);
        }
        int sizeInBytes = str.getSizeInBytes();
        return BinaryStringUtil.toDecimalFromBytes(precision, scale, BinaryStringUtil.getTmpBytes(str, sizeInBytes), 0, sizeInBytes);
    }

    private static Decimal toDecimalFromBytes(int precision, int scale, byte[] bytes, int offset, int sizeInBytes) {
        boolean negative;
        int i;
        byte b = 0;
        for (i = 0; i < sizeInBytes && ((b = bytes[offset + i]) == 32 || b == 10 || b == 9); ++i) {
        }
        if (i == sizeInBytes) {
            return null;
        }
        boolean bl = negative = b == 45;
        if ((negative || b == 43) && ++i == sizeInBytes) {
            return null;
        }
        long significand = 0L;
        int exp = 0;
        int significandLen = 0;
        int pointPos = -1;
        while (i < sizeInBytes) {
            b = bytes[offset + i];
            ++i;
            if (b >= 48 && b <= 57) {
                significand = significand * 10L + (long)(b - 48);
                ++significandLen;
                continue;
            }
            if (b != 46) break;
            if (pointPos >= 0) {
                return null;
            }
            pointPos = significandLen;
        }
        if (pointPos < 0) {
            pointPos = significandLen;
        }
        if (negative) {
            significand = -significand;
        }
        if ((b == 101 || b == 69) && i < sizeInBytes) {
            boolean expNegative;
            b = bytes[offset + i];
            boolean bl2 = expNegative = b == 45;
            if ((expNegative || b == 43) && ++i == sizeInBytes) {
                return null;
            }
            int expDigits = 0;
            int expStopValue = 40;
            while (i < sizeInBytes) {
                b = bytes[offset + i];
                ++i;
                if (b < 48 || b > 57) break;
                if (expDigits >= 40) continue;
                expDigits = expDigits * 10 + (b - 48);
            }
            if (expNegative) {
                expDigits = -expDigits;
            }
            exp += expDigits;
        }
        exp -= significandLen - pointPos;
        while (i < sizeInBytes) {
            b = bytes[offset + i];
            ++i;
            if (b == 32 || b == 10 || b == 9) continue;
            return null;
        }
        int change = exp + scale;
        if (significandLen + change > precision) {
            return null;
        }
        if (change >= 0) {
            significand *= Decimal.POW10[change];
        } else {
            int k = negative ? -5 : 5;
            significand = (significand + (long)k * Decimal.POW10[-change - 1]) / Decimal.POW10[-change];
        }
        return Decimal.fromLong(significand, precision, scale);
    }

    private static Decimal toBigPrecisionDecimal(BinaryString str, int precision, int scale) {
        int i;
        int len;
        int sizeInBytes = str.getSizeInBytes();
        int offset = str.getOffset();
        MemorySegment[] segments = str.getSegments();
        char[] chars = SegmentsUtil.allocateReuseChars(sizeInBytes);
        if (segments.length == 1) {
            len = StringUtf8Utils.decodeUTF8Strict(segments[0], offset, sizeInBytes, chars);
        } else {
            byte[] bytes = SegmentsUtil.allocateReuseBytes(sizeInBytes);
            SegmentsUtil.copyToBytes(segments, offset, bytes, 0, sizeInBytes);
            len = StringUtf8Utils.decodeUTF8Strict(bytes, 0, sizeInBytes, chars);
        }
        if (len < 0) {
            return null;
        }
        int start = 0;
        int end = len;
        for (i = 0; i < len; ++i) {
            if (chars[i] == ' ' || chars[i] == '\n' || chars[i] == '\t') continue;
            start = i;
            break;
        }
        for (i = len - 1; i >= 0; --i) {
            if (chars[i] == ' ' || chars[i] == '\n' || chars[i] == '\t') continue;
            end = i + 1;
            break;
        }
        try {
            BigDecimal bd = new BigDecimal(chars, start, end - start);
            return Decimal.fromBigDecimal(bd, precision, scale);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static Long toLong(BinaryString str) {
        boolean negative;
        int sizeInBytes = str.getSizeInBytes();
        byte[] tmpBytes = BinaryStringUtil.getTmpBytes(str, sizeInBytes);
        if (sizeInBytes == 0) {
            return null;
        }
        int i = 0;
        byte b = tmpBytes[i];
        boolean bl = negative = b == 45;
        if (negative || b == 43) {
            ++i;
            if (sizeInBytes == 1) {
                return null;
            }
        }
        long result = 0L;
        int separator = 46;
        int radix = 10;
        long stopValue = -922337203685477580L;
        while (i < sizeInBytes) {
            b = tmpBytes[i];
            ++i;
            if (b == 46) break;
            if (b < 48 || b > 57) {
                return null;
            }
            int digit = b - 48;
            if (result < -922337203685477580L) {
                return null;
            }
            if ((result = result * 10L - (long)digit) <= 0L) continue;
            return null;
        }
        while (i < sizeInBytes) {
            byte currentByte = tmpBytes[i];
            if (currentByte < 48 || currentByte > 57) {
                return null;
            }
            ++i;
        }
        if (!negative && (result = -result) < 0L) {
            return null;
        }
        return result;
    }

    public static Integer toInt(BinaryString str) {
        boolean negative;
        int sizeInBytes = str.getSizeInBytes();
        byte[] tmpBytes = BinaryStringUtil.getTmpBytes(str, sizeInBytes);
        if (sizeInBytes == 0) {
            return null;
        }
        int i = 0;
        byte b = tmpBytes[i];
        boolean bl = negative = b == 45;
        if (negative || b == 43) {
            ++i;
            if (sizeInBytes == 1) {
                return null;
            }
        }
        int result = 0;
        int separator = 46;
        int radix = 10;
        long stopValue = -214748364L;
        while (i < sizeInBytes) {
            b = tmpBytes[i];
            ++i;
            if (b == 46) break;
            if (b < 48 || b > 57) {
                return null;
            }
            int digit = b - 48;
            if ((long)result < -214748364L) {
                return null;
            }
            if ((result = result * 10 - digit) <= 0) continue;
            return null;
        }
        while (i < sizeInBytes) {
            byte currentByte = tmpBytes[i];
            if (currentByte < 48 || currentByte > 57) {
                return null;
            }
            ++i;
        }
        if (!negative && (result = -result) < 0) {
            return null;
        }
        return result;
    }

    public static Short toShort(BinaryString str) {
        short result;
        Integer intValue = BinaryStringUtil.toInt(str);
        if (intValue != null && (result = intValue.shortValue()) == intValue) {
            return result;
        }
        return null;
    }

    public static Byte toByte(BinaryString str) {
        byte result;
        Integer intValue = BinaryStringUtil.toInt(str);
        if (intValue != null && (result = intValue.byteValue()) == intValue) {
            return result;
        }
        return null;
    }

    public static Double toDouble(BinaryString str) {
        try {
            return Double.valueOf(str.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Float toFloat(BinaryString str) {
        try {
            return Float.valueOf(str.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static BinaryString keyValue(BinaryString str, byte split1, byte split2, BinaryString keyName) {
        str.ensureMaterialized();
        if (keyName == null || keyName.getSizeInBytes() == 0) {
            return null;
        }
        if (str.inFirstSegment() && keyName.inFirstSegment()) {
            int currentKeyIdx;
            int lastSplit1Idx = -1;
            for (int byteIdx = 0; byteIdx < str.sizeInBytes; ++byteIdx) {
                if (str.segments[0].get(str.offset + byteIdx) != split1) continue;
                currentKeyIdx = lastSplit1Idx + 1;
                BinaryString value = BinaryStringUtil.findValueOfKey(str, split2, keyName, currentKeyIdx, byteIdx);
                if (value != null) {
                    return value;
                }
                lastSplit1Idx = byteIdx;
            }
            currentKeyIdx = lastSplit1Idx + 1;
            return BinaryStringUtil.findValueOfKey(str, split2, keyName, currentKeyIdx, str.sizeInBytes);
        }
        return BinaryStringUtil.keyValueSlow(str, split1, split2, keyName);
    }

    private static BinaryString findValueOfKey(BinaryString str, byte split, BinaryString keyName, int start, int end) {
        int keyNameLen = keyName.sizeInBytes;
        for (int idx = start; idx < end; ++idx) {
            if (str.segments[0].get(str.offset + idx) != split) continue;
            if (idx == start + keyNameLen && str.segments[0].equalTo(keyName.segments[0], str.offset + start, keyName.offset, keyNameLen)) {
                int valueIdx = idx + 1;
                int valueLen = end - valueIdx;
                byte[] bytes = new byte[valueLen];
                str.segments[0].get(str.offset + valueIdx, bytes, 0, valueLen);
                return BinaryString.fromBytes(bytes, 0, valueLen);
            }
            return null;
        }
        return null;
    }

    private static BinaryString keyValueSlow(BinaryString str, byte split1, byte split2, BinaryString keyName) {
        int currentKeyIdx;
        int lastSplit1Idx = -1;
        for (int byteIdx = 0; byteIdx < str.sizeInBytes; ++byteIdx) {
            if (str.byteAt(byteIdx) != split1) continue;
            currentKeyIdx = lastSplit1Idx + 1;
            BinaryString value = BinaryStringUtil.findValueOfKeySlow(str, split2, keyName, currentKeyIdx, byteIdx);
            if (value != null) {
                return value;
            }
            lastSplit1Idx = byteIdx;
        }
        currentKeyIdx = lastSplit1Idx + 1;
        return BinaryStringUtil.findValueOfKeySlow(str, split2, keyName, currentKeyIdx, str.sizeInBytes);
    }

    private static BinaryString findValueOfKeySlow(BinaryString str, byte split, BinaryString keyName, int start, int end) {
        int keyNameLen = keyName.sizeInBytes;
        for (int idx = start; idx < end; ++idx) {
            if (str.byteAt(idx) != split) continue;
            if (idx == start + keyNameLen && SegmentsUtil.equals(str.segments, str.offset + start, keyName.segments, keyName.offset, keyNameLen)) {
                int valueIdx = idx + 1;
                byte[] bytes = SegmentsUtil.copyToBytes(str.segments, str.offset + valueIdx, end - valueIdx);
                return BinaryString.fromBytes(bytes);
            }
            return null;
        }
        return null;
    }

    public static BinaryString substringSQL(BinaryString str, int pos) {
        return BinaryStringUtil.substringSQL(str, pos, Integer.MAX_VALUE);
    }

    public static BinaryString substringSQL(BinaryString str, int pos, int length) {
        int start;
        if (length < 0) {
            return null;
        }
        str.ensureMaterialized();
        if (str.equals(BinaryString.EMPTY_UTF8)) {
            return BinaryString.EMPTY_UTF8;
        }
        int numChars = str.numChars();
        if (pos > 0) {
            start = pos - 1;
            if (start >= numChars) {
                return BinaryString.EMPTY_UTF8;
            }
        } else if (pos < 0) {
            start = numChars + pos;
            if (start < 0) {
                return BinaryString.EMPTY_UTF8;
            }
        } else {
            start = 0;
        }
        int end = numChars - start < length ? numChars : start + length;
        return str.substring(start, end);
    }

    public static BinaryString concat(BinaryString ... inputs) {
        return BinaryStringUtil.concat(Arrays.asList(inputs));
    }

    public static BinaryString concat(Iterable<BinaryString> inputs) {
        int totalLength = 0;
        for (BinaryString input : inputs) {
            if (input == null) {
                return null;
            }
            input.ensureMaterialized();
            totalLength += input.getSizeInBytes();
        }
        byte[] result = new byte[totalLength];
        int offset = 0;
        for (BinaryString input : inputs) {
            if (input == null) continue;
            int len = input.sizeInBytes;
            SegmentsUtil.copyToBytes(input.segments, input.offset, result, offset, len);
            offset += len;
        }
        return BinaryString.fromBytes(result);
    }

    public static BinaryString concatWs(BinaryString separator, BinaryString ... inputs) {
        return BinaryStringUtil.concatWs(separator, Arrays.asList(inputs));
    }

    public static BinaryString concatWs(BinaryString separator, Iterable<BinaryString> inputs) {
        if (null == separator) {
            return null;
        }
        separator.ensureMaterialized();
        int numInputBytes = 0;
        int numInputs = 0;
        for (BinaryString input : inputs) {
            if (input == null) continue;
            input.ensureMaterialized();
            numInputBytes += input.sizeInBytes;
            ++numInputs;
        }
        if (numInputs == 0) {
            return BinaryString.EMPTY_UTF8;
        }
        byte[] result = new byte[numInputBytes + (numInputs - 1) * separator.sizeInBytes];
        int offset = 0;
        int j = 0;
        for (BinaryString input : inputs) {
            if (input == null) continue;
            int len = input.sizeInBytes;
            SegmentsUtil.copyToBytes(input.segments, input.offset, result, offset, len);
            offset += len;
            if (++j >= numInputs) continue;
            SegmentsUtil.copyToBytes(separator.segments, separator.offset, result, offset, separator.sizeInBytes);
            offset += separator.sizeInBytes;
        }
        return BinaryString.fromBytes(result);
    }

    public static BinaryString reverse(BinaryString str) {
        str.ensureMaterialized();
        if (str.inFirstSegment()) {
            int charBytes;
            byte[] result = new byte[str.sizeInBytes];
            for (int byteIdx = 0; byteIdx < str.sizeInBytes; byteIdx += charBytes) {
                charBytes = BinaryString.numBytesForFirstByte(str.getByteOneSegment(byteIdx));
                str.segments[0].get(str.offset + byteIdx, result, result.length - byteIdx - charBytes, charBytes);
            }
            return BinaryString.fromBytes(result);
        }
        return BinaryStringUtil.reverseMultiSegs(str);
    }

    private static BinaryString reverseMultiSegs(BinaryString str) {
        int charBytes;
        byte[] result = new byte[str.sizeInBytes];
        int segSize = str.segments[0].size();
        BinaryString.SegmentAndOffset index = str.firstSegmentAndOffset(segSize);
        for (int byteIdx = 0; byteIdx < str.sizeInBytes; byteIdx += charBytes) {
            charBytes = BinaryString.numBytesForFirstByte(index.value());
            SegmentsUtil.copyMultiSegmentsToBytes(str.segments, str.offset + byteIdx, result, result.length - byteIdx - charBytes, charBytes);
            index.skipBytes(charBytes, segSize);
        }
        return BinaryString.fromBytes(result);
    }

    public static BinaryString trim(BinaryString str, BinaryString trimStr) {
        if (trimStr == null) {
            return null;
        }
        return BinaryStringUtil.trimRight(BinaryStringUtil.trimLeft(str, trimStr), trimStr);
    }

    public static BinaryString trimLeft(BinaryString str) {
        str.ensureMaterialized();
        if (str.inFirstSegment()) {
            int s;
            for (s = 0; s < str.sizeInBytes && str.getByteOneSegment(s) == 32; ++s) {
            }
            if (s == str.sizeInBytes) {
                return BinaryString.EMPTY_UTF8;
            }
            return str.copyBinaryStringInOneSeg(s, str.sizeInBytes - s);
        }
        return BinaryStringUtil.trimLeftSlow(str);
    }

    private static BinaryString trimLeftSlow(BinaryString str) {
        int s;
        int segSize = str.segments[0].size();
        BinaryString.SegmentAndOffset front = str.firstSegmentAndOffset(segSize);
        for (s = 0; s < str.sizeInBytes && front.value() == 32; ++s) {
            front.nextByte(segSize);
        }
        if (s == str.sizeInBytes) {
            return BinaryString.EMPTY_UTF8;
        }
        return str.copyBinaryString(s, str.sizeInBytes - 1);
    }

    public static boolean isSpaceString(BinaryString str) {
        if (str.javaObject != null) {
            return ((String)str.javaObject).equals(" ");
        }
        return str.byteAt(0) == 32;
    }

    public static BinaryString trimLeft(BinaryString str, BinaryString trimStr) {
        str.ensureMaterialized();
        if (trimStr == null) {
            return null;
        }
        trimStr.ensureMaterialized();
        if (BinaryStringUtil.isSpaceString(trimStr)) {
            return BinaryStringUtil.trimLeft(str);
        }
        if (str.inFirstSegment()) {
            BinaryString currentChar;
            int searchIdx;
            int charBytes;
            for (searchIdx = 0; searchIdx < str.sizeInBytes && trimStr.contains(currentChar = str.copyBinaryStringInOneSeg(searchIdx, charBytes = BinaryString.numBytesForFirstByte(str.getByteOneSegment(searchIdx)))); searchIdx += charBytes) {
            }
            if (searchIdx >= str.sizeInBytes) {
                return BinaryString.EMPTY_UTF8;
            }
            return str.copyBinaryStringInOneSeg(searchIdx, str.sizeInBytes - searchIdx);
        }
        return BinaryStringUtil.trimLeftSlow(str, trimStr);
    }

    private static BinaryString trimLeftSlow(BinaryString str, BinaryString trimStr) {
        BinaryString currentChar;
        int searchIdx;
        int charBytes;
        int segSize = str.segments[0].size();
        BinaryString.SegmentAndOffset front = str.firstSegmentAndOffset(segSize);
        for (searchIdx = 0; searchIdx < str.sizeInBytes && trimStr.contains(currentChar = str.copyBinaryString(searchIdx, searchIdx + (charBytes = BinaryString.numBytesForFirstByte(front.value())) - 1)); searchIdx += charBytes) {
            front.skipBytes(charBytes, segSize);
        }
        if (searchIdx == str.sizeInBytes) {
            return BinaryString.EMPTY_UTF8;
        }
        return str.copyBinaryString(searchIdx, str.sizeInBytes - 1);
    }

    public static BinaryString trimRight(BinaryString str) {
        str.ensureMaterialized();
        if (str.inFirstSegment()) {
            int e;
            for (e = str.sizeInBytes - 1; e >= 0 && str.getByteOneSegment(e) == 32; --e) {
            }
            if (e < 0) {
                return BinaryString.EMPTY_UTF8;
            }
            return str.copyBinaryStringInOneSeg(0, e + 1);
        }
        return BinaryStringUtil.trimRightSlow(str);
    }

    private static BinaryString trimRightSlow(BinaryString str) {
        int e;
        int segSize = str.segments[0].size();
        BinaryString.SegmentAndOffset behind = str.lastSegmentAndOffset(segSize);
        for (e = str.sizeInBytes - 1; e >= 0 && behind.value() == 32; --e) {
            behind.previousByte(segSize);
        }
        if (e < 0) {
            return BinaryString.EMPTY_UTF8;
        }
        return str.copyBinaryString(0, e);
    }

    public static BinaryString trimRight(BinaryString str, BinaryString trimStr) {
        str.ensureMaterialized();
        if (trimStr == null) {
            return null;
        }
        trimStr.ensureMaterialized();
        if (BinaryStringUtil.isSpaceString(trimStr)) {
            return BinaryStringUtil.trimRight(str);
        }
        if (str.inFirstSegment()) {
            BinaryString currentChar;
            int charIdx = 0;
            int byteIdx = 0;
            int[] charLens = new int[str.sizeInBytes];
            int[] charStartPos = new int[str.sizeInBytes];
            while (byteIdx < str.sizeInBytes) {
                charStartPos[charIdx] = byteIdx;
                charLens[charIdx] = BinaryString.numBytesForFirstByte(str.getByteOneSegment(byteIdx));
                byteIdx += charLens[charIdx];
                ++charIdx;
            }
            int searchIdx = str.sizeInBytes - 1;
            --charIdx;
            while (charIdx >= 0 && trimStr.contains(currentChar = str.copyBinaryStringInOneSeg(charStartPos[charIdx], charLens[charIdx]))) {
                searchIdx -= charLens[charIdx];
                --charIdx;
            }
            if (searchIdx < 0) {
                return BinaryString.EMPTY_UTF8;
            }
            return str.copyBinaryStringInOneSeg(0, searchIdx + 1);
        }
        return BinaryStringUtil.trimRightSlow(str, trimStr);
    }

    private static BinaryString trimRightSlow(BinaryString str, BinaryString trimStr) {
        BinaryString currentChar;
        int charIdx = 0;
        int byteIdx = 0;
        int segSize = str.segments[0].size();
        BinaryString.SegmentAndOffset index = str.firstSegmentAndOffset(segSize);
        int[] charLens = new int[str.sizeInBytes];
        int[] charStartPos = new int[str.sizeInBytes];
        while (byteIdx < str.sizeInBytes) {
            int charBytes;
            charStartPos[charIdx] = byteIdx;
            charLens[charIdx] = charBytes = BinaryString.numBytesForFirstByte(index.value());
            byteIdx += charBytes;
            ++charIdx;
            index.skipBytes(charBytes, segSize);
        }
        int searchIdx = str.sizeInBytes - 1;
        --charIdx;
        while (charIdx >= 0 && trimStr.contains(currentChar = str.copyBinaryString(charStartPos[charIdx], charStartPos[charIdx] + charLens[charIdx] - 1))) {
            searchIdx -= charLens[charIdx];
            --charIdx;
        }
        if (searchIdx < 0) {
            return BinaryString.EMPTY_UTF8;
        }
        return str.copyBinaryString(0, searchIdx);
    }

    public static BinaryString trim(BinaryString str, boolean leading, boolean trailing, BinaryString seek) {
        str.ensureMaterialized();
        if (seek == null) {
            return null;
        }
        if (leading && trailing) {
            return BinaryStringUtil.trim(str, seek);
        }
        if (leading) {
            return BinaryStringUtil.trimLeft(str, seek);
        }
        if (trailing) {
            return BinaryStringUtil.trimRight(str, seek);
        }
        return str;
    }

    public static String safeToString(BinaryString str) {
        if (str == null) {
            return null;
        }
        return str.toString();
    }
}

