/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import java.nio.ByteOrder;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryArray;
import org.apache.flink.table.dataformat.BinaryFormat;
import org.apache.flink.table.dataformat.BinaryGeneric;
import org.apache.flink.table.dataformat.BinaryMap;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.NestedRow;
import org.apache.flink.table.dataformat.TypeGetterSetters;
import org.apache.flink.table.runtime.util.SegmentsUtil;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.util.Preconditions;

public final class BinaryRow
extends BinaryFormat
implements BaseRow {
    public static final boolean LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    private static final long FIRST_BYTE_ZERO = LITTLE_ENDIAN ? -256L : 0xFFFFFFFFFFFFFFL;
    public static final int HEADER_SIZE_IN_BITS = 8;
    private final int arity;
    private final int nullBitsSizeInBytes;

    public static int calculateBitSetWidthInBytes(int arity) {
        return (arity + 63 + 8) / 64 * 8;
    }

    public static int calculateFixPartSizeInBytes(int arity) {
        return BinaryRow.calculateBitSetWidthInBytes(arity) + 8 * arity;
    }

    public static boolean isInFixedLengthPart(LogicalType type) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case INTERVAL_YEAR_MONTH: 
            case BIGINT: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case INTERVAL_DAY_TIME: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
            case DECIMAL: {
                return ((DecimalType)type).getPrecision() <= 18;
            }
        }
        return false;
    }

    public static boolean isMutable(LogicalType type) {
        return BinaryRow.isInFixedLengthPart(type) || type.getTypeRoot() == LogicalTypeRoot.DECIMAL;
    }

    public BinaryRow(int arity) {
        Preconditions.checkArgument((arity >= 0 ? 1 : 0) != 0);
        this.arity = arity;
        this.nullBitsSizeInBytes = BinaryRow.calculateBitSetWidthInBytes(arity);
    }

    private int getFieldOffset(int pos) {
        return this.offset + this.nullBitsSizeInBytes + pos * 8;
    }

    private void assertIndexIsValid(int index) {
        assert (index >= 0) : "index (" + index + ") should >= 0";
        assert (index < this.arity) : "index (" + index + ") should < " + this.arity;
    }

    public int getFixedLengthPartSize() {
        return this.nullBitsSizeInBytes + 8 * this.arity;
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    @Override
    public byte getHeader() {
        return this.segments[0].get(this.offset);
    }

    @Override
    public void setHeader(byte header) {
        this.segments[0].put(this.offset, header);
    }

    public void setTotalSize(int sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    @Override
    public boolean isNullAt(int pos) {
        this.assertIndexIsValid(pos);
        return SegmentsUtil.bitGet(this.segments[0], this.offset, pos + 8);
    }

    private void setNotNullAt(int i) {
        this.assertIndexIsValid(i);
        SegmentsUtil.bitUnSet(this.segments[0], this.offset, i + 8);
    }

    @Override
    public void setNullAt(int i) {
        this.assertIndexIsValid(i);
        SegmentsUtil.bitSet(this.segments[0], this.offset, i + 8);
        this.segments[0].putLong(this.getFieldOffset(i), 0L);
    }

    @Override
    public void setInt(int pos, int value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segments[0].putInt(this.getFieldOffset(pos), value);
    }

    @Override
    public void setLong(int pos, long value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segments[0].putLong(this.getFieldOffset(pos), value);
    }

    @Override
    public void setDouble(int pos, double value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segments[0].putDouble(this.getFieldOffset(pos), value);
    }

    @Override
    public void setDecimal(int pos, Decimal value, int precision) {
        this.assertIndexIsValid(pos);
        if (Decimal.isCompact(precision)) {
            this.setLong(pos, value.toUnscaledLong());
        } else {
            int fieldOffset = this.getFieldOffset(pos);
            int cursor = (int)(this.segments[0].getLong(fieldOffset) >>> 32);
            assert (cursor > 0) : "invalid cursor " + cursor;
            SegmentsUtil.setLong(this.segments, this.offset + cursor, 0L);
            SegmentsUtil.setLong(this.segments, this.offset + cursor + 8, 0L);
            if (value == null) {
                this.setNullAt(pos);
                this.segments[0].putLong(fieldOffset, (long)cursor << 32);
            } else {
                byte[] bytes = value.toUnscaledBytes();
                assert (bytes.length <= 16);
                SegmentsUtil.copyFromBytes(this.segments, this.offset + cursor, bytes, 0, bytes.length);
                this.setLong(pos, (long)cursor << 32 | (long)bytes.length);
            }
        }
    }

    @Override
    public void setBoolean(int pos, boolean value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segments[0].putBoolean(this.getFieldOffset(pos), value);
    }

    @Override
    public void setShort(int pos, short value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segments[0].putShort(this.getFieldOffset(pos), value);
    }

    @Override
    public void setByte(int pos, byte value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segments[0].put(this.getFieldOffset(pos), value);
    }

    @Override
    public void setFloat(int pos, float value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segments[0].putFloat(this.getFieldOffset(pos), value);
    }

    @Override
    public boolean getBoolean(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].getBoolean(this.getFieldOffset(pos));
    }

    @Override
    public byte getByte(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].get(this.getFieldOffset(pos));
    }

    @Override
    public short getShort(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].getShort(this.getFieldOffset(pos));
    }

    @Override
    public int getInt(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].getInt(this.getFieldOffset(pos));
    }

    @Override
    public long getLong(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].getLong(this.getFieldOffset(pos));
    }

    @Override
    public float getFloat(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].getFloat(this.getFieldOffset(pos));
    }

    @Override
    public double getDouble(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].getDouble(this.getFieldOffset(pos));
    }

    @Override
    public BinaryString getString(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndLen = this.segments[0].getLong(fieldOffset);
        return BinaryString.readBinaryStringFieldFromSegments(this.segments, this.offset, fieldOffset, offsetAndLen);
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        this.assertIndexIsValid(pos);
        if (Decimal.isCompact(precision)) {
            return Decimal.fromUnscaledLong(precision, scale, this.segments[0].getLong(this.getFieldOffset(pos)));
        }
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndSize = this.segments[0].getLong(fieldOffset);
        return Decimal.readDecimalFieldFromSegments(this.segments, this.offset, offsetAndSize, precision, scale);
    }

    @Override
    public <T> BinaryGeneric<T> getGeneric(int pos) {
        this.assertIndexIsValid(pos);
        return BinaryGeneric.readBinaryGenericFieldFromSegments(this.segments, this.offset, this.getLong(pos));
    }

    @Override
    public byte[] getBinary(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndLen = this.segments[0].getLong(fieldOffset);
        return BinaryRow.readBinaryFieldFromSegments(this.segments, this.offset, fieldOffset, offsetAndLen);
    }

    @Override
    public BaseArray getArray(int pos) {
        this.assertIndexIsValid(pos);
        return BinaryArray.readBinaryArrayFieldFromSegments(this.segments, this.offset, this.getLong(pos));
    }

    @Override
    public BaseMap getMap(int pos) {
        this.assertIndexIsValid(pos);
        return BinaryMap.readBinaryMapFieldFromSegments(this.segments, this.offset, this.getLong(pos));
    }

    @Override
    public BaseRow getRow(int pos, int numFields) {
        this.assertIndexIsValid(pos);
        return NestedRow.readNestedRowFieldFromSegments(this.segments, numFields, this.offset, this.getLong(pos));
    }

    public boolean anyNull() {
        if ((this.segments[0].getLong(0) & FIRST_BYTE_ZERO) != 0L) {
            return true;
        }
        for (int i = 8; i < this.nullBitsSizeInBytes; i += 8) {
            if (this.segments[0].getLong(i) == 0L) continue;
            return true;
        }
        return false;
    }

    public boolean anyNull(int[] fields) {
        for (int field : fields) {
            if (!this.isNullAt(field)) continue;
            return true;
        }
        return false;
    }

    public BinaryRow copy() {
        return this.copy(new BinaryRow(this.arity));
    }

    public BinaryRow copy(BinaryRow reuse) {
        return this.copyInternal(reuse);
    }

    private BinaryRow copyInternal(BinaryRow reuse) {
        byte[] bytes = SegmentsUtil.copyToBytes(this.segments, this.offset, this.sizeInBytes);
        reuse.pointTo(MemorySegmentFactory.wrap((byte[])bytes), 0, this.sizeInBytes);
        return reuse;
    }

    public void clear() {
        this.segments = null;
        this.offset = 0;
        this.sizeInBytes = 0;
    }

    @Override
    public int hashCode() {
        return SegmentsUtil.hashByWords(this.segments, this.offset, this.sizeInBytes);
    }

    public String toOriginString(LogicalType ... types) {
        return BinaryRow.toOriginString(this, types);
    }

    public static String toOriginString(BaseRow row, LogicalType[] types) {
        Preconditions.checkArgument((types.length == row.getArity() ? 1 : 0) != 0);
        StringBuilder build = new StringBuilder("[");
        build.append(row.getHeader());
        for (int i = 0; i < row.getArity(); ++i) {
            build.append(',');
            if (row.isNullAt(i)) {
                build.append("null");
                continue;
            }
            build.append(TypeGetterSetters.get(row, i, types[i]));
        }
        build.append(']');
        return build.toString();
    }

    public boolean equalsWithoutHeader(BaseRow o) {
        return this.equalsFrom(o, 1);
    }

    private boolean equalsFrom(Object o, int startIndex) {
        if (o != null && o instanceof BinaryRow) {
            BinaryRow other = (BinaryRow)o;
            return this.sizeInBytes == other.sizeInBytes && SegmentsUtil.equals(this.segments, this.offset + startIndex, other.segments, other.offset + startIndex, this.sizeInBytes - startIndex);
        }
        return false;
    }
}

