/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.dataformat.LazyBinaryFormat;
import org.apache.flink.table.runtime.util.SegmentsUtil;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.InstantiationUtil;

public final class BinaryGeneric<T>
extends LazyBinaryFormat<T> {
    private final TypeSerializer<T> javaObjectSer;

    public BinaryGeneric(T javaObject, TypeSerializer<T> javaObjectSer) {
        super(javaObject);
        this.javaObjectSer = javaObjectSer;
    }

    public BinaryGeneric(MemorySegment[] segments, int offset, int sizeInBytes, TypeSerializer<T> javaObjectSer) {
        super(segments, offset, sizeInBytes);
        this.javaObjectSer = javaObjectSer;
    }

    public BinaryGeneric(MemorySegment[] segments, int offset, int sizeInBytes, T javaObject, TypeSerializer<T> javaObjectSer) {
        super(segments, offset, sizeInBytes, javaObject);
        this.javaObjectSer = javaObjectSer;
    }

    public TypeSerializer<T> getJavaObjectSerializer() {
        return this.javaObjectSer;
    }

    @Override
    public void materialize() {
        try {
            byte[] bytes = InstantiationUtil.serializeToByteArray(this.javaObjectSer, (Object)this.javaObject);
            this.pointTo(new MemorySegment[]{MemorySegmentFactory.wrap((byte[])bytes)}, 0, bytes.length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public BinaryGeneric<T> copy() {
        this.ensureMaterialized();
        byte[] bytes = SegmentsUtil.copyToBytes(this.segments, this.offset, this.sizeInBytes);
        Object newJavaObject = this.javaObject == null ? null : this.javaObjectSer.copy(this.javaObject);
        return new BinaryGeneric<Object>(new MemorySegment[]{MemorySegmentFactory.wrap((byte[])bytes)}, 0, this.sizeInBytes, newJavaObject, this.javaObjectSer);
    }

    static <T> BinaryGeneric<T> readBinaryGenericFieldFromSegments(MemorySegment[] segments, int baseOffset, long offsetAndSize) {
        int size = (int)offsetAndSize;
        int offset = (int)(offsetAndSize >> 32);
        return new BinaryGeneric<T>(segments, offset + baseOffset, size, null);
    }

    public static <T> T getJavaObjectFromBinaryGeneric(BinaryGeneric<T> value, TypeSerializer<T> ser) {
        if (value.getJavaObject() == null) {
            try {
                value.setJavaObject(InstantiationUtil.deserializeFromByteArray(ser, (byte[])SegmentsUtil.copyToBytes(value.getSegments(), value.getOffset(), value.getSizeInBytes())));
            }
            catch (IOException e) {
                throw new FlinkRuntimeException((Throwable)e);
            }
        }
        return value.getJavaObject();
    }
}

