/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import java.lang.reflect.Array;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemoryUtils;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryFormat;
import org.apache.flink.table.dataformat.BinaryGeneric;
import org.apache.flink.table.dataformat.BinaryMap;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.NestedRow;
import org.apache.flink.table.dataformat.TypeGetterSetters;
import org.apache.flink.table.runtime.util.SegmentsUtil;
import org.apache.flink.table.types.logical.LogicalType;

public final class BinaryArray
extends BinaryFormat
implements BaseArray {
    private static final int BYTE_ARRAY_BASE_OFFSET = MemoryUtils.UNSAFE.arrayBaseOffset(byte[].class);
    private static final int BOOLEAN_ARRAY_OFFSET = MemoryUtils.UNSAFE.arrayBaseOffset(boolean[].class);
    private static final int SHORT_ARRAY_OFFSET = MemoryUtils.UNSAFE.arrayBaseOffset(short[].class);
    private static final int INT_ARRAY_OFFSET = MemoryUtils.UNSAFE.arrayBaseOffset(int[].class);
    private static final int LONG_ARRAY_OFFSET = MemoryUtils.UNSAFE.arrayBaseOffset(long[].class);
    private static final int FLOAT_ARRAY_OFFSET = MemoryUtils.UNSAFE.arrayBaseOffset(float[].class);
    private static final int DOUBLE_ARRAY_OFFSET = MemoryUtils.UNSAFE.arrayBaseOffset(double[].class);
    private int numElements;
    private int elementOffset;

    public static int calculateHeaderInBytes(int numFields) {
        return 4 + (numFields + 31) / 32 * 4;
    }

    public static int calculateFixLengthPartSize(LogicalType type) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: 
            case TINYINT: {
                return 1;
            }
            case SMALLINT: {
                return 2;
            }
            case INTEGER: 
            case FLOAT: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case INTERVAL_YEAR_MONTH: {
                return 4;
            }
        }
        return 8;
    }

    private void assertIndexIsValid(int ordinal) {
        assert (ordinal >= 0) : "ordinal (" + ordinal + ") should >= 0";
        assert (ordinal < this.numElements) : "ordinal (" + ordinal + ") should < " + this.numElements;
    }

    private int getElementOffset(int ordinal, int elementSize) {
        return this.elementOffset + ordinal * elementSize;
    }

    @Override
    public int numElements() {
        return this.numElements;
    }

    @Override
    public void pointTo(MemorySegment[] segments, int offset, int sizeInBytes) {
        int numElements = SegmentsUtil.getInt(segments, offset);
        assert (numElements >= 0) : "numElements (" + numElements + ") should >= 0";
        this.numElements = numElements;
        this.segments = segments;
        this.offset = offset;
        this.sizeInBytes = sizeInBytes;
        this.elementOffset = offset + BinaryArray.calculateHeaderInBytes(this.numElements);
    }

    @Override
    public boolean isNullAt(int pos) {
        this.assertIndexIsValid(pos);
        return SegmentsUtil.bitGet(this.segments, this.offset + 4, pos);
    }

    @Override
    public void setNullAt(int pos) {
        this.assertIndexIsValid(pos);
        SegmentsUtil.bitSet(this.segments, this.offset + 4, pos);
    }

    @Override
    public void setNotNullAt(int pos) {
        this.assertIndexIsValid(pos);
        SegmentsUtil.bitUnSet(this.segments, this.offset + 4, pos);
    }

    @Override
    public long getLong(int pos) {
        this.assertIndexIsValid(pos);
        return SegmentsUtil.getLong(this.segments, this.getElementOffset(pos, 8));
    }

    @Override
    public void setLong(int pos, long value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        SegmentsUtil.setLong(this.segments, this.getElementOffset(pos, 8), value);
    }

    @Override
    public void setNullLong(int pos) {
        this.assertIndexIsValid(pos);
        SegmentsUtil.bitSet(this.segments, this.offset + 4, pos);
        SegmentsUtil.setLong(this.segments, this.getElementOffset(pos, 8), 0L);
    }

    @Override
    public int getInt(int pos) {
        this.assertIndexIsValid(pos);
        return SegmentsUtil.getInt(this.segments, this.getElementOffset(pos, 4));
    }

    @Override
    public void setInt(int pos, int value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        SegmentsUtil.setInt(this.segments, this.getElementOffset(pos, 4), value);
    }

    @Override
    public void setNullInt(int pos) {
        this.assertIndexIsValid(pos);
        SegmentsUtil.bitSet(this.segments, this.offset + 4, pos);
        SegmentsUtil.setInt(this.segments, this.getElementOffset(pos, 4), 0);
    }

    @Override
    public BinaryString getString(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getElementOffset(pos, 8);
        long offsetAndSize = SegmentsUtil.getLong(this.segments, fieldOffset);
        return BinaryString.readBinaryStringFieldFromSegments(this.segments, this.offset, fieldOffset, offsetAndSize);
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        this.assertIndexIsValid(pos);
        if (Decimal.isCompact(precision)) {
            return Decimal.fromUnscaledLong(precision, scale, SegmentsUtil.getLong(this.segments, this.getElementOffset(pos, 8)));
        }
        int fieldOffset = this.getElementOffset(pos, 8);
        long offsetAndSize = SegmentsUtil.getLong(this.segments, fieldOffset);
        return Decimal.readDecimalFieldFromSegments(this.segments, this.offset, offsetAndSize, precision, scale);
    }

    @Override
    public <T> BinaryGeneric<T> getGeneric(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getElementOffset(pos, 8);
        long offsetAndSize = SegmentsUtil.getLong(this.segments, fieldOffset);
        return BinaryGeneric.readBinaryGenericFieldFromSegments(this.segments, this.offset, offsetAndSize);
    }

    @Override
    public byte[] getBinary(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getElementOffset(pos, 8);
        long offsetAndSize = SegmentsUtil.getLong(this.segments, fieldOffset);
        return BinaryArray.readBinaryFieldFromSegments(this.segments, this.offset, fieldOffset, offsetAndSize);
    }

    @Override
    public BaseArray getArray(int pos) {
        this.assertIndexIsValid(pos);
        return BinaryArray.readBinaryArrayFieldFromSegments(this.segments, this.offset, this.getLong(pos));
    }

    @Override
    public BaseMap getMap(int pos) {
        this.assertIndexIsValid(pos);
        return BinaryMap.readBinaryMapFieldFromSegments(this.segments, this.offset, this.getLong(pos));
    }

    @Override
    public BaseRow getRow(int pos, int numFields) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getElementOffset(pos, 8);
        long offsetAndSize = SegmentsUtil.getLong(this.segments, fieldOffset);
        return NestedRow.readNestedRowFieldFromSegments(this.segments, numFields, this.offset, offsetAndSize);
    }

    @Override
    public boolean getBoolean(int pos) {
        this.assertIndexIsValid(pos);
        return SegmentsUtil.getBoolean(this.segments, this.getElementOffset(pos, 1));
    }

    @Override
    public void setBoolean(int pos, boolean value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        SegmentsUtil.setBoolean(this.segments, this.getElementOffset(pos, 1), value);
    }

    @Override
    public void setNullBoolean(int pos) {
        this.assertIndexIsValid(pos);
        SegmentsUtil.bitSet(this.segments, this.offset + 4, pos);
        SegmentsUtil.setBoolean(this.segments, this.getElementOffset(pos, 1), false);
    }

    @Override
    public byte getByte(int pos) {
        this.assertIndexIsValid(pos);
        return SegmentsUtil.getByte(this.segments, this.getElementOffset(pos, 1));
    }

    @Override
    public void setByte(int pos, byte value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        SegmentsUtil.setByte(this.segments, this.getElementOffset(pos, 1), value);
    }

    @Override
    public void setNullByte(int pos) {
        this.assertIndexIsValid(pos);
        SegmentsUtil.bitSet(this.segments, this.offset + 4, pos);
        SegmentsUtil.setByte(this.segments, this.getElementOffset(pos, 1), (byte)0);
    }

    @Override
    public short getShort(int pos) {
        this.assertIndexIsValid(pos);
        return SegmentsUtil.getShort(this.segments, this.getElementOffset(pos, 2));
    }

    @Override
    public void setShort(int pos, short value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        SegmentsUtil.setShort(this.segments, this.getElementOffset(pos, 2), value);
    }

    @Override
    public void setNullShort(int pos) {
        this.assertIndexIsValid(pos);
        SegmentsUtil.bitSet(this.segments, this.offset + 4, pos);
        SegmentsUtil.setShort(this.segments, this.getElementOffset(pos, 2), (short)0);
    }

    @Override
    public float getFloat(int pos) {
        this.assertIndexIsValid(pos);
        return SegmentsUtil.getFloat(this.segments, this.getElementOffset(pos, 4));
    }

    @Override
    public void setFloat(int pos, float value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        SegmentsUtil.setFloat(this.segments, this.getElementOffset(pos, 4), value);
    }

    @Override
    public void setNullFloat(int pos) {
        this.assertIndexIsValid(pos);
        SegmentsUtil.bitSet(this.segments, this.offset + 4, pos);
        SegmentsUtil.setFloat(this.segments, this.getElementOffset(pos, 4), 0.0f);
    }

    @Override
    public double getDouble(int pos) {
        this.assertIndexIsValid(pos);
        return SegmentsUtil.getDouble(this.segments, this.getElementOffset(pos, 8));
    }

    @Override
    public void setDouble(int pos, double value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        SegmentsUtil.setDouble(this.segments, this.getElementOffset(pos, 8), value);
    }

    @Override
    public void setNullDouble(int pos) {
        this.assertIndexIsValid(pos);
        SegmentsUtil.bitSet(this.segments, this.offset + 4, pos);
        SegmentsUtil.setDouble(this.segments, this.getElementOffset(pos, 8), 0.0);
    }

    @Override
    public void setDecimal(int pos, Decimal value, int precision) {
        this.assertIndexIsValid(pos);
        if (Decimal.isCompact(precision)) {
            this.setLong(pos, value.toUnscaledLong());
        } else {
            int fieldOffset = this.getElementOffset(pos, 8);
            int cursor = (int)(SegmentsUtil.getLong(this.segments, fieldOffset) >>> 32);
            assert (cursor > 0) : "invalid cursor " + cursor;
            SegmentsUtil.setLong(this.segments, this.offset + cursor, 0L);
            SegmentsUtil.setLong(this.segments, this.offset + cursor + 8, 0L);
            if (value == null) {
                this.setNullAt(pos);
                SegmentsUtil.setLong(this.segments, fieldOffset, (long)cursor << 32);
            } else {
                byte[] bytes = value.toUnscaledBytes();
                assert (bytes.length <= 16);
                SegmentsUtil.copyFromBytes(this.segments, this.offset + cursor, bytes, 0, bytes.length);
                this.setLong(pos, (long)cursor << 32 | (long)bytes.length);
            }
        }
    }

    public boolean anyNull() {
        for (int i = this.offset + 4; i < this.elementOffset; i += 4) {
            if (SegmentsUtil.getInt(this.segments, i) == 0) continue;
            return true;
        }
        return false;
    }

    private void checkNoNull() {
        if (this.anyNull()) {
            throw new RuntimeException("Array can not have null value!");
        }
    }

    @Override
    public boolean[] toBooleanArray() {
        this.checkNoNull();
        boolean[] values = new boolean[this.numElements];
        SegmentsUtil.copyToUnsafe(this.segments, this.elementOffset, values, BOOLEAN_ARRAY_OFFSET, this.numElements);
        return values;
    }

    @Override
    public byte[] toByteArray() {
        this.checkNoNull();
        byte[] values = new byte[this.numElements];
        SegmentsUtil.copyToUnsafe(this.segments, this.elementOffset, values, BYTE_ARRAY_BASE_OFFSET, this.numElements);
        return values;
    }

    @Override
    public short[] toShortArray() {
        this.checkNoNull();
        short[] values = new short[this.numElements];
        SegmentsUtil.copyToUnsafe(this.segments, this.elementOffset, values, SHORT_ARRAY_OFFSET, this.numElements * 2);
        return values;
    }

    @Override
    public int[] toIntArray() {
        this.checkNoNull();
        int[] values = new int[this.numElements];
        SegmentsUtil.copyToUnsafe(this.segments, this.elementOffset, values, INT_ARRAY_OFFSET, this.numElements * 4);
        return values;
    }

    @Override
    public long[] toLongArray() {
        this.checkNoNull();
        long[] values = new long[this.numElements];
        SegmentsUtil.copyToUnsafe(this.segments, this.elementOffset, values, LONG_ARRAY_OFFSET, this.numElements * 8);
        return values;
    }

    @Override
    public float[] toFloatArray() {
        this.checkNoNull();
        float[] values = new float[this.numElements];
        SegmentsUtil.copyToUnsafe(this.segments, this.elementOffset, values, FLOAT_ARRAY_OFFSET, this.numElements * 4);
        return values;
    }

    @Override
    public double[] toDoubleArray() {
        this.checkNoNull();
        double[] values = new double[this.numElements];
        SegmentsUtil.copyToUnsafe(this.segments, this.elementOffset, values, DOUBLE_ARRAY_OFFSET, this.numElements * 8);
        return values;
    }

    public <T> T[] toClassArray(LogicalType elementType, Class<T> elementClass) {
        int size = this.numElements();
        Object[] values = (Object[])Array.newInstance(elementClass, size);
        for (int i = 0; i < size; ++i) {
            if (this.isNullAt(i)) continue;
            values[i] = TypeGetterSetters.get(this, i, elementType);
        }
        return values;
    }

    public BinaryArray copy() {
        return this.copy(new BinaryArray());
    }

    public BinaryArray copy(BinaryArray reuse) {
        byte[] bytes = SegmentsUtil.copyToBytes(this.segments, this.offset, this.sizeInBytes);
        reuse.pointTo(MemorySegmentFactory.wrap((byte[])bytes), 0, this.sizeInBytes);
        return reuse;
    }

    @Override
    public int hashCode() {
        return SegmentsUtil.hashByWords(this.segments, this.offset, this.sizeInBytes);
    }

    private static BinaryArray fromPrimitiveArray(Object arr, int offset, int length, int elementSize) {
        long valueRegionInBytes;
        long headerInBytes = BinaryArray.calculateHeaderInBytes(length);
        long totalSizeInLongs = (headerInBytes + (valueRegionInBytes = (long)(elementSize * length)) + 7L) / 8L;
        if (totalSizeInLongs > 0xFFFFFFFL) {
            throw new UnsupportedOperationException("Cannot convert this array to unsafe format as it's too big.");
        }
        long totalSize = totalSizeInLongs * 8L;
        byte[] data = new byte[(int)totalSize];
        MemoryUtils.UNSAFE.putInt(data, BYTE_ARRAY_BASE_OFFSET, length);
        MemoryUtils.UNSAFE.copyMemory(arr, offset, data, (long)BYTE_ARRAY_BASE_OFFSET + headerInBytes, valueRegionInBytes);
        BinaryArray result = new BinaryArray();
        result.pointTo(MemorySegmentFactory.wrap((byte[])data), 0, (int)totalSize);
        return result;
    }

    public static BinaryArray fromPrimitiveArray(boolean[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, BOOLEAN_ARRAY_OFFSET, arr.length, 1);
    }

    public static BinaryArray fromPrimitiveArray(byte[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, BYTE_ARRAY_BASE_OFFSET, arr.length, 1);
    }

    public static BinaryArray fromPrimitiveArray(short[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, SHORT_ARRAY_OFFSET, arr.length, 2);
    }

    public static BinaryArray fromPrimitiveArray(int[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, INT_ARRAY_OFFSET, arr.length, 4);
    }

    public static BinaryArray fromPrimitiveArray(long[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, LONG_ARRAY_OFFSET, arr.length, 8);
    }

    public static BinaryArray fromPrimitiveArray(float[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, FLOAT_ARRAY_OFFSET, arr.length, 4);
    }

    public static BinaryArray fromPrimitiveArray(double[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, DOUBLE_ARRAY_OFFSET, arr.length, 8);
    }

    static BinaryArray readBinaryArrayFieldFromSegments(MemorySegment[] segments, int baseOffset, long offsetAndSize) {
        int size = (int)offsetAndSize;
        int offset = (int)(offsetAndSize >> 32);
        BinaryArray array = new BinaryArray();
        array.pointTo(segments, offset + baseOffset, size);
        return array;
    }
}

