/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem.stream;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;

public class TaskTracker {
    private final int numberOfTasks;
    private final TreeMap<Long, Set<Integer>> notifiedTasks = new TreeMap();

    public TaskTracker(int numberOfTasks) {
        this.numberOfTasks = numberOfTasks;
    }

    public boolean add(long checkpointId, int task) {
        Set tasks = this.notifiedTasks.computeIfAbsent(checkpointId, k -> new HashSet());
        tasks.add(task);
        if (tasks.size() == this.numberOfTasks) {
            this.notifiedTasks.headMap(checkpointId, true).clear();
            return true;
        }
        return false;
    }
}

