/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem.stream;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.functions.sink.filesystem.StreamingFileSink;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.filesystem.stream.AbstractStreamingWriter;
import org.apache.flink.table.filesystem.stream.PartitionCommitInfo;

public class StreamingFileWriter<IN>
extends AbstractStreamingWriter<IN, PartitionCommitInfo> {
    private static final long serialVersionUID = 2L;
    private transient Set<String> currentNewPartitions;
    private transient TreeMap<Long, Set<String>> newPartitions;
    private transient Set<String> committablePartitions;

    public StreamingFileWriter(long bucketCheckInterval, StreamingFileSink.BucketsBuilder<IN, String, ? extends StreamingFileSink.BucketsBuilder<IN, String, ?>> bucketsBuilder) {
        super(bucketCheckInterval, bucketsBuilder);
    }

    @Override
    public void initializeState(StateInitializationContext context) throws Exception {
        this.currentNewPartitions = new HashSet<String>();
        this.newPartitions = new TreeMap();
        this.committablePartitions = new HashSet<String>();
        super.initializeState(context);
    }

    @Override
    protected void partitionCreated(String partition) {
        this.currentNewPartitions.add(partition);
    }

    @Override
    protected void partitionInactive(String partition) {
        this.committablePartitions.add(partition);
    }

    @Override
    protected void onPartFileOpened(String s, Path newPath) {
    }

    @Override
    public void snapshotState(StateSnapshotContext context) throws Exception {
        super.snapshotState(context);
        this.newPartitions.put(context.getCheckpointId(), new HashSet<String>(this.currentNewPartitions));
        this.currentNewPartitions.clear();
    }

    @Override
    protected void commitUpToCheckpoint(long checkpointId) throws Exception {
        super.commitUpToCheckpoint(checkpointId);
        NavigableMap<Long, Set<String>> headPartitions = this.newPartitions.headMap(checkpointId, true);
        HashSet<String> partitions = new HashSet<String>(this.committablePartitions);
        this.committablePartitions.clear();
        headPartitions.values().forEach(partitions::addAll);
        headPartitions.clear();
        this.output.collect((Object)new StreamRecord((Object)new PartitionCommitInfo(checkpointId, this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getNumberOfParallelSubtasks(), new ArrayList<String>(partitions))));
    }
}

