/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputFileConfig;
import org.apache.flink.table.filesystem.FileSystemFactory;
import org.apache.flink.table.utils.PartitionPathUtils;
import org.apache.flink.util.Preconditions;

@Internal
public class PartitionTempFileManager {
    private static final String CHECKPOINT_DIR_PREFIX = "cp-";
    private static final String TASK_DIR_PREFIX = "task-";
    private final int taskNumber;
    private final long checkpointId;
    private final Path taskTmpDir;
    private final OutputFileConfig outputFileConfig;
    private transient int nameCounter = 0;

    PartitionTempFileManager(FileSystemFactory factory, Path tmpPath, int taskNumber, long checkpointId) throws IOException {
        this(factory, tmpPath, taskNumber, checkpointId, new OutputFileConfig("", ""));
    }

    PartitionTempFileManager(FileSystemFactory factory, Path tmpPath, int taskNumber, long checkpointId, OutputFileConfig outputFileConfig) throws IOException {
        Preconditions.checkArgument((checkpointId != -1L ? 1 : 0) != 0, (Object)"checkpoint id start with 0.");
        this.taskNumber = taskNumber;
        this.checkpointId = checkpointId;
        this.outputFileConfig = outputFileConfig;
        this.taskTmpDir = new Path(new Path(tmpPath, PartitionTempFileManager.checkpointName(checkpointId)), TASK_DIR_PREFIX + taskNumber);
        factory.create(this.taskTmpDir.toUri()).delete(this.taskTmpDir, true);
    }

    public Path createPartitionDir(String ... partitions) {
        Path parentPath = this.taskTmpDir;
        for (String dir : partitions) {
            parentPath = new Path(parentPath, dir);
        }
        return new Path(parentPath, this.newFileName());
    }

    private String newFileName() {
        return String.format("%s-%s-%s-file-%d%s", this.outputFileConfig.getPartPrefix(), PartitionTempFileManager.checkpointName(this.checkpointId), PartitionTempFileManager.taskName(this.taskNumber), this.nameCounter++, this.outputFileConfig.getPartSuffix());
    }

    private static boolean isTaskDir(String fileName) {
        return fileName.startsWith(TASK_DIR_PREFIX);
    }

    private static boolean isCheckpointDir(String fileName) {
        return fileName.startsWith(CHECKPOINT_DIR_PREFIX);
    }

    private static long getCheckpointId(String fileName) {
        return Long.parseLong(fileName.substring(3));
    }

    private static String checkpointName(long checkpointId) {
        return CHECKPOINT_DIR_PREFIX + checkpointId;
    }

    private static String taskName(int task) {
        return TASK_DIR_PREFIX + task;
    }

    public static void deleteCheckpoint(FileSystem fs, Path basePath, long checkpointId) throws IOException {
        fs.delete(new Path(basePath, PartitionTempFileManager.checkpointName(checkpointId)), true);
    }

    public static long[] headCheckpoints(FileSystem fs, Path basePath, long toCpId) throws IOException {
        ArrayList<Long> cps = new ArrayList<Long>();
        for (FileStatus taskStatus : fs.listStatus(basePath)) {
            long currentCp;
            String name = taskStatus.getPath().getName();
            if (!PartitionTempFileManager.isCheckpointDir(name) || (currentCp = PartitionTempFileManager.getCheckpointId(name)) > toCpId) continue;
            cps.add(currentCp);
        }
        return cps.stream().mapToLong(v -> v).toArray();
    }

    public static List<Path> listTaskTemporaryPaths(FileSystem fs, Path basePath, long checkpointId) throws Exception {
        ArrayList<Path> taskTmpPaths = new ArrayList<Path>();
        for (FileStatus taskStatus : fs.listStatus(new Path(basePath, PartitionTempFileManager.checkpointName(checkpointId)))) {
            if (!PartitionTempFileManager.isTaskDir(taskStatus.getPath().getName())) continue;
            taskTmpPaths.add(taskStatus.getPath());
        }
        return taskTmpPaths;
    }

    static Map<LinkedHashMap<String, String>, List<Path>> collectPartSpecToPaths(FileSystem fs, List<Path> taskPaths, int partColSize) {
        HashMap<LinkedHashMap<String, String>, List<Path>> specToPaths = new HashMap<LinkedHashMap<String, String>, List<Path>>();
        for (Path taskPath : taskPaths) {
            PartitionPathUtils.searchPartSpecAndPaths((FileSystem)fs, (Path)taskPath, (int)partColSize).forEach(tuple2 -> specToPaths.compute((LinkedHashMap<String, String>)tuple2.f0, (spec, paths) -> {
                paths = paths == null ? new ArrayList() : paths;
                paths.add(tuple2.f1);
                return paths;
            }));
        }
        return specToPaths;
    }
}

