/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexUtil;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCalc;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCorrelate;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalRel;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableFunctionScan;
import org.apache.flink.table.planner.plan.rules.logical.SplitPythonConditionFromCorrelateRule;
import org.apache.flink.table.planner.plan.rules.physical.stream.StreamPhysicalCorrelateRule;
import org.apache.flink.table.planner.plan.utils.PythonUtil;

public class CalcPythonCorrelateTransposeRule
extends RelOptRule {
    public static final CalcPythonCorrelateTransposeRule INSTANCE = new CalcPythonCorrelateTransposeRule();

    private CalcPythonCorrelateTransposeRule() {
        super(CalcPythonCorrelateTransposeRule.operand(FlinkLogicalCorrelate.class, CalcPythonCorrelateTransposeRule.operand(FlinkLogicalRel.class, CalcPythonCorrelateTransposeRule.any()), CalcPythonCorrelateTransposeRule.operand(FlinkLogicalCalc.class, CalcPythonCorrelateTransposeRule.any())), "CalcPythonCorrelateTransposeRule");
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalCorrelate correlate = (FlinkLogicalCorrelate)call.rel(0);
        FlinkLogicalCalc right = (FlinkLogicalCalc)call.rel(2);
        JoinRelType joinType = correlate.getJoinType();
        FlinkLogicalCalc mergedCalc = StreamPhysicalCorrelateRule.getMergedCalc(right);
        FlinkLogicalTableFunctionScan scan = StreamPhysicalCorrelateRule.getTableScan(mergedCalc);
        return joinType == JoinRelType.INNER && PythonUtil.isPythonCall(scan.getCall(), null) && mergedCalc.getProgram().getCondition() != null;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FlinkLogicalCorrelate correlate = (FlinkLogicalCorrelate)call.rel(0);
        FlinkLogicalCalc right = (FlinkLogicalCalc)call.rel(2);
        RexBuilder rexBuilder = call.builder().getRexBuilder();
        FlinkLogicalCalc mergedCalc = StreamPhysicalCorrelateRule.getMergedCalc(right);
        FlinkLogicalTableFunctionScan tableScan = StreamPhysicalCorrelateRule.getTableScan(mergedCalc);
        RexProgram mergedCalcProgram = mergedCalc.getProgram();
        SplitPythonConditionFromCorrelateRule.InputRefRewriter inputRefRewriter = new SplitPythonConditionFromCorrelateRule.InputRefRewriter(correlate.getRowType().getFieldCount() - mergedCalc.getRowType().getFieldCount());
        List correlateFilters = RelOptUtil.conjunctions(mergedCalcProgram.expandLocalRef(mergedCalcProgram.getCondition())).stream().map(x -> x.accept(inputRefRewriter)).collect(Collectors.toList());
        FlinkLogicalCorrelate newCorrelate = new FlinkLogicalCorrelate(correlate.getCluster(), correlate.getTraitSet(), correlate.getLeft(), tableScan, correlate.getCorrelationId(), correlate.getRequiredColumns(), correlate.getJoinType());
        RexNode topCalcCondition = RexUtil.composeConjunction(rexBuilder, correlateFilters);
        RexProgram rexProgram = new RexProgramBuilder(newCorrelate.getRowType(), rexBuilder).getProgram();
        FlinkLogicalCalc newTopCalc = new FlinkLogicalCalc(newCorrelate.getCluster(), newCorrelate.getTraitSet(), newCorrelate, RexProgram.create(newCorrelate.getRowType(), rexProgram.getExprList(), topCalcCondition, newCorrelate.getRowType(), rexBuilder));
        call.transformTo(newTopCalc);
    }
}

