/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.batch;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.cost.FlinkCost$;
import org.apache.flink.table.planner.plan.cost.FlinkCostFactory;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNestedLoopJoin;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalJoinBase;
import org.apache.flink.table.planner.plan.utils.JoinTypeUtil;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\n\u0015\u0001\u001dB\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003:\u0011!\u0001\u0005A!A!\u0002\u0013\t\u0005\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u00119\u0003!Q1A\u0005\u0002=C\u0001B\u0016\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\t/\u0002\u0011)\u0019!C\u0001\u001f\"A\u0001\f\u0001B\u0001B\u0003%\u0001\u000bC\u0003Z\u0001\u0011\u0005!\fC\u0003e\u0001\u0011\u0005S\rC\u0003t\u0001\u0011\u0005C\u000fC\u0003{\u0001\u0011\u00053\u0010C\u0004\u0002\u0018\u0001!I!!\u0007\t\u000f\u0005\r\u0002\u0001\"\u0011\u0002&!9\u0011\u0011\u0007\u0001\u0005B\u0005M\u0002bBA-\u0001\u0011\u0005\u00111\f\u0002\u001c\u0005\u0006$8\r\u001b)isNL7-\u00197OKN$X\r\u001a'p_BTu.\u001b8\u000b\u0005U1\u0012!\u00022bi\u000eD'BA\f\u0019\u0003!\u0001\b._:jG\u0006d'BA\r\u001b\u0003\u0015qw\u000eZ3t\u0015\tYB$\u0001\u0003qY\u0006t'BA\u000f\u001f\u0003\u001d\u0001H.\u00198oKJT!a\b\u0011\u0002\u000bQ\f'\r\\3\u000b\u0005\u0005\u0012\u0013!\u00024mS:\\'BA\u0012%\u0003\u0019\t\u0007/Y2iK*\tQ%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001QA\u0011\u0011FK\u0007\u0002)%\u00111\u0006\u0006\u0002\u0016\u0005\u0006$8\r\u001b)isNL7-\u00197K_&t')Y:f\u0003\u001d\u0019G.^:uKJ\u0004\"A\f\u001a\u000e\u0003=R!a\u0007\u0019\u000b\u0005E\u0012\u0013aB2bY\u000eLG/Z\u0005\u0003g=\u0012QBU3m\u001fB$8\t\\;ti\u0016\u0014\u0018\u0001\u0003;sC&$8+\u001a;\u0011\u000592\u0014BA\u001c0\u0005-\u0011V\r\u001c+sC&$8+\u001a;\u0002\u000f1,g\r\u001e*fYB\u0011!(P\u0007\u0002w)\u0011A\bM\u0001\u0004e\u0016d\u0017B\u0001 <\u0005\u001d\u0011V\r\u001c(pI\u0016\f\u0001B]5hQR\u0014V\r\\\u0001\nG>tG-\u001b;j_:\u0004\"AQ#\u000e\u0003\rS!\u0001\u0012\u0019\u0002\u0007I,\u00070\u0003\u0002G\u0007\n9!+\u001a=O_\u0012,\u0017\u0001\u00036pS:$\u0016\u0010]3\u0011\u0005%cU\"\u0001&\u000b\u0005-[\u0014\u0001B2pe\u0016L!!\u0014&\u0003\u0017){\u0017N\u001c*fYRK\b/Z\u0001\fY\u00164G/S:Ck&dG-F\u0001Q!\t\tF+D\u0001S\u0015\u0005\u0019\u0016!B:dC2\f\u0017BA+S\u0005\u001d\u0011un\u001c7fC:\fA\u0002\\3gi&\u001b()^5mI\u0002\nQb]5oO2,'k\\<K_&t\u0017AD:j]\u001edWMU8x\u0015>Lg\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0013mcVLX0aC\n\u001c\u0007CA\u0015\u0001\u0011\u0015a3\u00021\u0001.\u0011\u0015!4\u00021\u00016\u0011\u0015A4\u00021\u0001:\u0011\u0015y4\u00021\u0001:\u0011\u0015\u00015\u00021\u0001B\u0011\u001595\u00021\u0001I\u0011\u0015q5\u00021\u0001Q\u0011\u001596\u00021\u0001Q\u0003\u0011\u0019w\u000e]=\u0015\u000f\u0019L'\u000e\u001c8qcB\u0011\u0011jZ\u0005\u0003Q*\u0013AAS8j]\")A\u0007\u0004a\u0001k!)1\u000e\u0004a\u0001\u0003\u0006i1m\u001c8eSRLwN\\#yaJDQ!\u001c\u0007A\u0002e\nA\u0001\\3gi\")q\u000e\u0004a\u0001s\u0005)!/[4ii\")q\t\u0004a\u0001\u0011\")!\u000f\u0004a\u0001!\u0006a1/Z7j\u0015>Lg\u000eR8oK\u0006aQ\r\u001f9mC&tG+\u001a:ngR\u0011Q\u000f\u001f\t\u0003uYL!a^\u001e\u0003\u0013I+Gn\u0016:ji\u0016\u0014\b\"B=\u000e\u0001\u0004)\u0018A\u00019x\u0003=\u0019w.\u001c9vi\u0016\u001cV\r\u001c4D_N$H\u0003\u0002?\u0000\u0003\u000f\u0001\"AL?\n\u0005y|#A\u0003*fY>\u0003HoQ8ti\"1QD\u0004a\u0001\u0003\u0003\u00012ALA\u0002\u0013\r\t)a\f\u0002\u000e%\u0016dw\n\u001d;QY\u0006tg.\u001a:\t\u000f\u0005%a\u00021\u0001\u0002\f\u0005\u0011Q.\u001d\t\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011C\u001e\u0002\u00115,G/\u00193bi\u0006LA!!\u0006\u0002\u0010\t\u0001\"+\u001a7NKR\fG-\u0019;b#V,'/_\u0001\u0012g\",hM\u001a7f\u0005VLG\u000eZ\"pk:$H\u0003BA\u000e\u0003C\u00012!UA\u000f\u0013\r\tyB\u0015\u0002\u0004\u0013:$\bbBA\u0005\u001f\u0001\u0007\u00111B\u0001\u000eg\u0006$\u0018n\u001d4z)J\f\u0017\u000e^:\u0015\t\u0005\u001d\u0012Q\u0006\t\u0005#\u0006%\u0012(C\u0002\u0002,I\u0013aa\u00149uS>t\u0007BBA\u0018!\u0001\u0007Q'\u0001\tsKF,\u0018N]3e)J\f\u0017\u000e^*fi\u0006\u0019BO]1og2\fG/\u001a+p\u000bb,7MT8eKR\u0011\u0011Q\u0007\u0019\u0005\u0003o\t9\u0005\u0005\u0004\u0002:\u0005}\u00121I\u0007\u0003\u0003wQ1!!\u0010\u0019\u0003\u0011)\u00070Z2\n\t\u0005\u0005\u00131\b\u0002\t\u000bb,7MT8eKB!\u0011QIA$\u0019\u0001!1\"!\u0013\u0012\u0003\u0003\u0005\tQ!\u0001\u0002L\t\u0019q\fJ\u0019\u0012\t\u00055\u00131\u000b\t\u0004#\u0006=\u0013bAA)%\n9aj\u001c;iS:<\u0007cA)\u0002V%\u0019\u0011q\u000b*\u0003\u0007\u0005s\u00170\u0001\nhKRLe\u000e];u!J|\u0007/\u001a:uS\u0016\u001cXCAA/!\u001d\t\u0016qLA2\u0003GJ1!!\u0019S\u0005\u0019!V\u000f\u001d7feA!\u0011\u0011HA3\u0013\u0011\t9'a\u000f\u0003\u001b%s\u0007/\u001e;Qe>\u0004XM\u001d;z\u0001")
public class BatchPhysicalNestedLoopJoin
extends BatchPhysicalJoinBase {
    private final RelOptCluster cluster;
    private final RexNode condition;
    private final JoinRelType joinType;
    private final boolean leftIsBuild;
    private final boolean singleRowJoin;

    public boolean leftIsBuild() {
        return this.leftIsBuild;
    }

    public boolean singleRowJoin() {
        return this.singleRowJoin;
    }

    @Override
    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new BatchPhysicalNestedLoopJoin(this.cluster, traitSet, left, right, conditionExpr, joinType, this.leftIsBuild(), this.singleRowJoin());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("build", this.leftIsBuild() ? "left" : "right").itemIf("singleRowJoin", BoxesRunTime.boxToBoolean((boolean)this.singleRowJoin()), this.singleRowJoin());
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        Double leftRowCnt = mq.getRowCount(this.getLeft());
        Double rightRowCnt = mq.getRowCount(this.getRight());
        if (leftRowCnt == null || rightRowCnt == null) {
            return null;
        }
        RelNode buildRel = this.leftIsBuild() ? this.getLeft() : this.getRight();
        Double buildRows = mq.getRowCount(buildRel);
        Double buildRowSize = mq.getAverageRowSize(buildRel);
        double memoryCost = Predef$.MODULE$.Double2double(buildRows) * (Predef$.MODULE$.Double2double(buildRowSize) + (double)4) * (double)this.shuffleBuildCount(mq);
        double cpuCost = Predef$.MODULE$.Double2double(leftRowCnt) * Predef$.MODULE$.Double2double(rightRowCnt);
        FlinkCostFactory costFactory = (FlinkCostFactory)planner.getCostFactory();
        RelOptCost cost = costFactory.makeCost(Predef$.MODULE$.Double2double(mq.getRowCount(this)), cpuCost, 0.0, 0.0, memoryCost);
        if (this.singleRowJoin()) {
            return cost.multiplyBy(0.99);
        }
        return cost;
    }

    private int shuffleBuildCount(RelMetadataQuery mq) {
        RelNode probeRel = this.leftIsBuild() ? this.getRight() : this.getLeft();
        Double rowCount = mq.getRowCount(probeRel);
        if (rowCount == null) {
            return 1;
        }
        Double probeRowSize = mq.getAverageRowSize(probeRel);
        return Math.max(1, (int)(Predef$.MODULE$.Double2double(rowCount) * Predef$.MODULE$.Double2double(probeRowSize) / (double)FlinkCost$.MODULE$.SQL_DEFAULT_PARALLELISM_WORKER_PROCESS_SIZE()));
    }

    @Override
    public Option<RelNode> satisfyTraits(RelTraitSet requiredTraitSet) {
        return this.satisfyTraitsOnBroadcastJoin(requiredTraitSet, this.leftIsBuild());
    }

    @Override
    public ExecNode<?> translateToExecNode() {
        Tuple2<InputProperty, InputProperty> tuple2 = this.getInputProperties();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        InputProperty leftInputProperty = (InputProperty)tuple2._1();
        InputProperty rightInputProperty = (InputProperty)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)leftInputProperty, (Object)rightInputProperty);
        InputProperty leftInputProperty2 = (InputProperty)tuple22._1();
        InputProperty rightInputProperty2 = (InputProperty)tuple22._2();
        return new BatchExecNestedLoopJoin((ReadableConfig)ShortcutUtils.unwrapTableConfig(this), JoinTypeUtil.getFlinkJoinType(this.joinType), this.condition, this.leftIsBuild(), this.singleRowJoin(), leftInputProperty2, rightInputProperty2, FlinkTypeFactory$.MODULE$.toLogicalRowType(this.getRowType()), this.getRelDetailedDescription());
    }

    public Tuple2<InputProperty, InputProperty> getInputProperties() {
        Tuple2 tuple2;
        JoinRelType joinRelType = this.joinType;
        JoinRelType joinRelType2 = JoinRelType.FULL;
        Tuple2 tuple22 = !(joinRelType != null ? !((Object)((Object)joinRelType)).equals((Object)joinRelType2) : joinRelType2 != null) ? new Tuple2((Object)InputProperty.SINGLETON_DISTRIBUTION, (Object)InputProperty.SINGLETON_DISTRIBUTION) : (tuple2 = new Tuple2((Object)InputProperty.BROADCAST_DISTRIBUTION, (Object)InputProperty.ANY_DISTRIBUTION));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        InputProperty.RequiredDistribution buildRequiredDistribution = (InputProperty.RequiredDistribution)tuple2._1();
        InputProperty.RequiredDistribution probeRequiredDistribution = (InputProperty.RequiredDistribution)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)buildRequiredDistribution, (Object)probeRequiredDistribution);
        InputProperty.RequiredDistribution buildRequiredDistribution2 = (InputProperty.RequiredDistribution)tuple23._1();
        InputProperty.RequiredDistribution probeRequiredDistribution2 = (InputProperty.RequiredDistribution)tuple23._2();
        InputProperty buildInputProperty = InputProperty.builder().requiredDistribution(buildRequiredDistribution2).damBehavior(InputProperty.DamBehavior.BLOCKING).priority(0).build();
        InputProperty probeInputProperty = InputProperty.builder().requiredDistribution(probeRequiredDistribution2).damBehavior(InputProperty.DamBehavior.PIPELINED).priority(1).build();
        if (this.leftIsBuild()) {
            return new Tuple2((Object)buildInputProperty, (Object)probeInputProperty);
        }
        return new Tuple2((Object)probeInputProperty, (Object)buildInputProperty);
    }

    public BatchPhysicalNestedLoopJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode leftRel, RelNode rightRel, RexNode condition, JoinRelType joinType, boolean leftIsBuild, boolean singleRowJoin) {
        this.cluster = cluster;
        this.condition = condition;
        this.joinType = joinType;
        this.leftIsBuild = leftIsBuild;
        this.singleRowJoin = singleRowJoin;
        super(cluster, traitSet, leftRel, rightRel, condition, joinType);
    }
}

