/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;

public abstract class SqlAlterMaterializedTable
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("ALTER MATERIALIZED TABLE", SqlKind.ALTER_TABLE);
    protected final SqlIdentifier tableIdentifier;

    public SqlAlterMaterializedTable(SqlParserPos pos, SqlIdentifier tableName) {
        super(pos);
        this.tableIdentifier = Objects.requireNonNull(tableName, "tableName should not be null");
    }

    public SqlIdentifier getTableName() {
        return this.tableIdentifier;
    }

    public String[] fullTableName() {
        return this.tableIdentifier.names.toArray(new String[0]);
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("ALTER MATERIALIZED TABLE");
        this.tableIdentifier.unparse(writer, leftPrec, rightPrec);
    }
}

