/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Pair;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class AssignableOperandTypeChecker
implements SqlOperandTypeChecker {
    private final List<RelDataType> paramTypes;
    private final @Nullable ImmutableList<String> paramNames;

    public AssignableOperandTypeChecker(List<RelDataType> paramTypes, @Nullable List<String> paramNames) {
        this.paramTypes = ImmutableList.copyOf(paramTypes);
        this.paramNames = paramNames == null ? null : ImmutableList.copyOf(paramNames);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(this.paramTypes.size());
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        List<SqlNode> operands = callBinding.getCall().getOperandList();
        for (Pair<RelDataType, SqlNode> pair : Pair.zip(this.paramTypes, operands)) {
            RelDataType argType = SqlTypeUtil.deriveType(callBinding, (SqlNode)pair.right);
            if (SqlTypeUtil.canAssignFrom((RelDataType)pair.left, argType)) continue;
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }
        return true;
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        StringBuilder sb = new StringBuilder();
        sb.append(opName);
        sb.append("(");
        for (Ord<RelDataType> paramType : Ord.zip(this.paramTypes)) {
            if (paramType.i > 0) {
                sb.append(", ");
            }
            if (this.paramNames != null) {
                sb.append((String)this.paramNames.get(paramType.i)).append(" => ");
            }
            sb.append("<");
            sb.append(((RelDataType)paramType.e).getFamily());
            sb.append(">");
        }
        sb.append(")");
        return sb.toString();
    }
}

