/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.flink.sql.parser.ddl.SqlDistribution;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.ddl.SqlTableOption;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.types.DataType;

public class OperationConverterUtils {
    private OperationConverterUtils() {
    }

    public static List<TableChange> buildModifyColumnChange(Column oldColumn, Column newColumn, @Nullable TableChange.ColumnPosition columnPosition) {
        if (oldColumn.isPhysical() && newColumn.isPhysical()) {
            ArrayList<TableChange> changes = new ArrayList<TableChange>();
            String newComment = newColumn.getComment().orElse(oldColumn.getComment().orElse(null));
            if (!newColumn.getComment().equals(oldColumn.getComment())) {
                changes.add((TableChange)TableChange.modifyColumnComment((Column)oldColumn, (String)newComment));
            }
            if (!oldColumn.getDataType().getLogicalType().equals((Object)newColumn.getDataType().getLogicalType())) {
                changes.add((TableChange)TableChange.modifyPhysicalColumnType((Column)oldColumn.withComment(newComment), (DataType)newColumn.getDataType()));
            }
            if (!Objects.equals(newColumn.getName(), oldColumn.getName())) {
                changes.add((TableChange)TableChange.modifyColumnName((Column)oldColumn.withComment(newComment).copy(newColumn.getDataType()), (String)newColumn.getName()));
            }
            if (columnPosition != null) {
                changes.add((TableChange)TableChange.modifyColumnPosition((Column)newColumn, (TableChange.ColumnPosition)columnPosition));
            }
            return changes;
        }
        return Collections.singletonList(TableChange.modify((Column)oldColumn, (Column)newColumn, (TableChange.ColumnPosition)columnPosition));
    }

    @Nullable
    public static String getComment(SqlTableColumn column) {
        return column.getComment().map(SqlCharStringLiteral.class::cast).map(c -> c.getValueAs(String.class)).orElse(null);
    }

    @Nullable
    public static String getTableComment(Optional<SqlCharStringLiteral> tableComment) {
        return tableComment.map(comment -> comment.getValueAs(String.class)).orElse(null);
    }

    public static Map<String, String> extractProperties(SqlNodeList propList) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (propList != null) {
            propList.getList().forEach(p -> properties.put(((SqlTableOption)p).getKeyString(), ((SqlTableOption)p).getValueString()));
        }
        return properties;
    }

    public static TableDistribution getDistributionFromSqlDistribution(SqlDistribution distribution) {
        TableDistribution.Kind kind = TableDistribution.Kind.valueOf((String)distribution.getDistributionKind().orElse(TableDistribution.Kind.UNKNOWN.toString()));
        Integer bucketCount = null;
        SqlNumericLiteral count = distribution.getBucketCount();
        if (count != null && count.isInteger()) {
            bucketCount = ((BigDecimal)count.getValue()).intValue();
        }
        List bucketColumns = Collections.emptyList();
        SqlNodeList columns = distribution.getBucketColumns();
        if (columns != null) {
            bucketColumns = columns.getList().stream().map(p -> ((SqlIdentifier)p).getSimple()).collect(Collectors.toList());
        }
        return TableDistribution.of((TableDistribution.Kind)kind, (Integer)bucketCount, bucketColumns);
    }
}

