/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlRankFunction;
import org.apache.calcite.sql.fun.SqlAvgAggFunction;
import org.apache.calcite.sql.fun.SqlCountAggFunction;
import org.apache.calcite.sql.fun.SqlMinMaxAggFunction;
import org.apache.calcite.sql.fun.SqlSingleValueAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlSumAggFunction;
import org.apache.calcite.sql.fun.SqlSumEmptyIsZeroAggFunction;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionUtils;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.DeclarativeAggregateFunction;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.ImperativeAggregateFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.functions.aggfunctions.AvgAggFunction;
import org.apache.flink.table.planner.functions.aggfunctions.CountAggFunction;
import org.apache.flink.table.planner.functions.aggfunctions.Sum0AggFunction;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlAggFunction;
import org.apache.flink.table.planner.functions.inference.OperatorBindingCallContext;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.functions.sql.SqlFirstLastValueAggFunction;
import org.apache.flink.table.planner.functions.sql.SqlListAggFunction;
import org.apache.flink.table.planner.functions.utils.AggSqlFunction;
import org.apache.flink.table.planner.functions.utils.UserDefinedFunctionUtils$;
import org.apache.flink.table.planner.plan.logical.HoppingWindowSpec;
import org.apache.flink.table.planner.plan.logical.WindowSpec;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.planner.plan.trait.ModifyKindSetTrait;
import org.apache.flink.table.planner.plan.trait.ModifyKindSetTrait$;
import org.apache.flink.table.planner.plan.trait.ModifyKindSetTraitDef$;
import org.apache.flink.table.planner.plan.trait.RelModifiedMonotonicity;
import org.apache.flink.table.planner.plan.utils.AggFunctionFactory;
import org.apache.flink.table.planner.plan.utils.AggregateInfo;
import org.apache.flink.table.planner.plan.utils.AggregateInfoList;
import org.apache.flink.table.planner.plan.utils.DistinctInfo;
import org.apache.flink.table.planner.typeutils.DataViewUtils;
import org.apache.flink.table.planner.typeutils.LegacyDataViewUtils$;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil$;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.runtime.dataview.DataViewSpec;
import org.apache.flink.table.runtime.functions.aggregate.BuiltInAggregateFunction;
import org.apache.flink.table.runtime.groupwindow.NamedWindowProperty;
import org.apache.flink.table.runtime.groupwindow.ProctimeAttribute;
import org.apache.flink.table.runtime.groupwindow.RowtimeAttribute;
import org.apache.flink.table.runtime.groupwindow.WindowEnd;
import org.apache.flink.table.runtime.groupwindow.WindowProperty;
import org.apache.flink.table.runtime.groupwindow.WindowStart;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeInferenceUtil;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.DataTypeUtils;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class AggregateUtil$
extends Enumeration {
    public static AggregateUtil$ MODULE$;

    static {
        new AggregateUtil$();
    }

    public boolean containsAccurateDistinctCall(List<AggregateCall> aggCalls) {
        return JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(aggCalls).exists((Function1 & Serializable & scala.Serializable)call -> BoxesRunTime.boxToBoolean((boolean)AggregateUtil$.$anonfun$containsAccurateDistinctCall$1(call)));
    }

    public boolean containsApproximateDistinctCall(List<AggregateCall> aggCalls) {
        return JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(aggCalls).exists((Function1 & Serializable & scala.Serializable)call -> BoxesRunTime.boxToBoolean((boolean)AggregateUtil$.$anonfun$containsApproximateDistinctCall$1(call)));
    }

    public Seq<Object> getGroupIdExprIndexes(Seq<AggregateCall> aggCalls) {
        return (Seq)((TraversableLike)((TraversableLike)aggCalls.zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AggregateUtil$.$anonfun$getGroupIdExprIndexes$1(x0$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)AggregateUtil$.$anonfun$getGroupIdExprIndexes$2(x0$2)), Seq$.MODULE$.canBuildFrom());
    }

    public Tuple2<int[], Seq<AggregateCall>> checkAndSplitAggCalls(Aggregate agg) {
        int[] auxGrouping;
        Tuple2 tuple2;
        IntRef nonAuxGroupCallsStartIdx = IntRef.create((int)-1);
        List<AggregateCall> aggCalls = agg.getAggCallList();
        ((IterableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(aggCalls).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            AggregateUtil$.$anonfun$checkAndSplitAggCalls$1(nonAuxGroupCallsStartIdx, x0$3);
            return BoxedUnit.UNIT;
        });
        if (nonAuxGroupCallsStartIdx.elem < 0) {
            nonAuxGroupCallsStartIdx.elem = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(aggCalls).length();
        }
        if ((tuple2 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(aggCalls).splitAt(nonAuxGroupCallsStartIdx.elem)) == null) {
            throw new MatchError((Object)tuple2);
        }
        Buffer auxGroupCalls = (Buffer)tuple2._1();
        Buffer otherAggCalls = (Buffer)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)auxGroupCalls, (Object)otherAggCalls);
        Tuple2 tuple23 = tuple22;
        Buffer auxGroupCalls2 = (Buffer)tuple23._1();
        Buffer otherAggCalls2 = (Buffer)tuple23._2();
        if (agg.getGroupCount() == 0) {
            Predef$.MODULE$.require(auxGroupCalls2.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "AUXILIARY_GROUP aggCalls should be empty when groupSet is empty");
        }
        Predef$.MODULE$.require((auxGrouping = (int[])((TraversableOnce)auxGroupCalls2.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(x$2.getArgList()).head())), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int())).length + otherAggCalls2.length() == JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(aggCalls).length());
        return new Tuple2((Object)auxGrouping, (Object)otherAggCalls2);
    }

    public int[] checkAndGetFullGroupSet(Aggregate agg) {
        int[] auxGroupSet;
        Tuple2<int[], Seq<AggregateCall>> tuple2 = this.checkAndSplitAggCalls(agg);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int[] nArray = auxGroupSet = (int[])tuple2._1();
        int[] auxGroupSet2 = nArray;
        return (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(agg.getGroupSet().toArray())).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(auxGroupSet2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
    }

    public Map<Integer, Integer> getOutputIndexToAggCallIndexMap(FlinkTypeFactory typeFactory, Seq<AggregateCall> aggregateCalls, RelDataType inputType, boolean isBounded, int[] orderKeyIndexes) {
        AggregateInfo[] aggInfos = this.transformToAggregateInfoList(typeFactory, FlinkTypeFactory$.MODULE$.toLogicalRowType(inputType), aggregateCalls, (boolean[])Array$.MODULE$.fill(aggregateCalls.size(), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, ClassTag$.MODULE$.Boolean()), orderKeyIndexes, false, (Option<Object>)Option$.MODULE$.empty(), false, false, isBounded).aggInfos();
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        IntRef outputIndex = IntRef.create((int)0);
        aggregateCalls.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)aggCallIndex -> {
            AggregateInfo aggInfo = aggInfos[aggCallIndex];
            DataType[] aggBuffers = aggInfo.externalAccTypes();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggBuffers)).indices().foreach((Function1 & Serializable & scala.Serializable)bufferIndex -> map.put(Predef$.MODULE$.int2Integer(outputIndex.elem + BoxesRunTime.unboxToInt((Object)bufferIndex)), Predef$.MODULE$.int2Integer(aggCallIndex)));
            outputIndex$1.elem += aggBuffers.length;
        });
        return map;
    }

    public int[] getOutputIndexToAggCallIndexMap$default$5() {
        return null;
    }

    public AggregateInfoList createPartialAggInfoList(FlinkTypeFactory typeFactory, RowType partialLocalAggInputRowType, Seq<AggregateCall> partialOriginalAggCalls, boolean[] partialAggCallNeedRetractions, boolean partialAggNeedRetraction, boolean isGlobal) {
        return this.transformToStreamAggregateInfoList(typeFactory, partialLocalAggInputRowType, partialOriginalAggCalls, partialAggCallNeedRetractions, partialAggNeedRetraction, isGlobal, this.transformToStreamAggregateInfoList$default$7());
    }

    public AggregateInfoList createIncrementalAggInfoList(FlinkTypeFactory typeFactory, RowType partialLocalAggInputRowType, Seq<AggregateCall> partialOriginalAggCalls, boolean[] partialAggCallNeedRetractions, boolean partialAggNeedRetraction) {
        AggregateInfoList partialLocalAggInfoList = this.createPartialAggInfoList(typeFactory, partialLocalAggInputRowType, partialOriginalAggCalls, partialAggCallNeedRetractions, partialAggNeedRetraction, false);
        AggregateInfoList partialGlobalAggInfoList = this.createPartialAggInfoList(typeFactory, partialLocalAggInputRowType, partialOriginalAggCalls, partialAggCallNeedRetractions, partialAggNeedRetraction, true);
        DistinctInfo[] incrementalDistinctInfos = (DistinctInfo[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partialGlobalAggInfoList.distinctInfos())).map((Function1 & Serializable & scala.Serializable)info -> new DistinctInfo(info.argIndexes(), info.keyType(), info.accType(), true, info.dataViewSpec(), info.consumeRetraction(), info.filterArgs(), info.aggIndexes()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DistinctInfo.class)));
        return new AggregateInfoList(partialLocalAggInfoList.aggInfos(), partialGlobalAggInfoList.indexOfCountStar(), partialGlobalAggInfoList.countStarInserted(), incrementalDistinctInfos);
    }

    public AggregateInfoList deriveAggregateInfoList(StreamPhysicalRel agg, int groupCount, Seq<AggregateCall> aggCalls) {
        RelNode input = agg.getInput(0);
        boolean[] aggCallNeedRetractions = this.deriveAggCallNeedRetractions(agg, groupCount, aggCalls);
        boolean needInputCount = this.needRetraction(agg);
        return this.transformToStreamAggregateInfoList(ShortcutUtils.unwrapTypeFactory(agg), FlinkTypeFactory$.MODULE$.toLogicalRowType(input.getRowType()), aggCalls, aggCallNeedRetractions, needInputCount, true, this.transformToStreamAggregateInfoList$default$7());
    }

    public AggregateInfoList deriveStreamWindowAggregateInfoList(FlinkTypeFactory typeFactory, RowType inputRowType, Seq<AggregateCall> aggCalls, boolean needRetraction, WindowSpec windowSpec, boolean isStateBackendDataViews) {
        boolean needInputCount = windowSpec instanceof HoppingWindowSpec || needRetraction;
        int aggSize = needInputCount ? aggCalls.length() + 1 : aggCalls.length();
        boolean[] aggCallNeedRetractions = (boolean[])Array$.MODULE$.fill(aggSize, (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> needRetraction, ClassTag$.MODULE$.Boolean());
        return this.transformToAggregateInfoList(typeFactory, inputRowType, aggCalls, aggCallNeedRetractions, null, needInputCount, (Option<Object>)Option$.MODULE$.empty(), isStateBackendDataViews, true, false);
    }

    public Tuple2<Sum0AggFunction, CountAggFunction> deriveSumAndCountFromAvg(AvgAggFunction avgAggFunction) {
        Tuple2 tuple2;
        AvgAggFunction avgAggFunction2 = avgAggFunction;
        if (avgAggFunction2 instanceof AvgAggFunction.ByteAvgAggFunction) {
            tuple2 = new Tuple2((Object)new Sum0AggFunction.ByteSum0AggFunction(), (Object)new CountAggFunction());
        } else if (avgAggFunction2 instanceof AvgAggFunction.ShortAvgAggFunction) {
            tuple2 = new Tuple2((Object)new Sum0AggFunction.ShortSum0AggFunction(), (Object)new CountAggFunction());
        } else if (avgAggFunction2 instanceof AvgAggFunction.IntAvgAggFunction) {
            tuple2 = new Tuple2((Object)new Sum0AggFunction.IntSum0AggFunction(), (Object)new CountAggFunction());
        } else if (avgAggFunction2 instanceof AvgAggFunction.LongAvgAggFunction) {
            tuple2 = new Tuple2((Object)new Sum0AggFunction.LongSum0AggFunction(), (Object)new CountAggFunction());
        } else if (avgAggFunction2 instanceof AvgAggFunction.FloatAvgAggFunction) {
            tuple2 = new Tuple2((Object)new Sum0AggFunction.FloatSum0AggFunction(), (Object)new CountAggFunction());
        } else if (avgAggFunction2 instanceof AvgAggFunction.DoubleAvgAggFunction) {
            tuple2 = new Tuple2((Object)new Sum0AggFunction.DoubleSum0AggFunction(), (Object)new CountAggFunction());
        } else {
            throw new TableException(new StringBuilder(87).append("Avg aggregate function does not support: ''").append((Object)avgAggFunction).append("''").append("Please re-check the function or data type.").toString());
        }
        return tuple2;
    }

    public Tuple3<int[][], DataType[][], UserDefinedFunction[]> transformToBatchAggregateFunctions(FlinkTypeFactory typeFactory, RowType inputRowType, Seq<AggregateCall> aggregateCalls, int[] orderKeyIndexes) {
        AggregateInfo[] aggInfos = this.transformToAggregateInfoList(typeFactory, inputRowType, aggregateCalls, (boolean[])Array$.MODULE$.fill(aggregateCalls.size(), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, ClassTag$.MODULE$.Boolean()), orderKeyIndexes, false, (Option<Object>)Option$.MODULE$.empty(), false, false, true).aggInfos();
        int[][] aggFields = (int[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggInfos)).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.argIndexes(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
        DataType[][] bufferTypes = (DataType[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggInfos)).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.externalAccTypes(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(DataType.class))));
        UserDefinedFunction[] functions = (UserDefinedFunction[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggInfos)).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.function(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(UserDefinedFunction.class)));
        return new Tuple3((Object)aggFields, (Object)bufferTypes, (Object)functions);
    }

    public int[] transformToBatchAggregateFunctions$default$4() {
        return null;
    }

    public AggregateInfoList transformToBatchAggregateInfoList(FlinkTypeFactory typeFactory, RowType inputRowType, Seq<AggregateCall> aggCalls, boolean[] aggCallNeedRetractions, int[] orderKeyIndexes) {
        boolean[] finalAggCallNeedRetractions = aggCallNeedRetractions == null ? (boolean[])Array$.MODULE$.fill(aggCalls.size(), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, ClassTag$.MODULE$.Boolean()) : aggCallNeedRetractions;
        return this.transformToAggregateInfoList(typeFactory, inputRowType, aggCalls, finalAggCallNeedRetractions, orderKeyIndexes, false, (Option<Object>)Option$.MODULE$.empty(), false, false, true);
    }

    public boolean[] transformToBatchAggregateInfoList$default$4() {
        return null;
    }

    public int[] transformToBatchAggregateInfoList$default$5() {
        return null;
    }

    public AggregateInfoList transformToStreamAggregateInfoList(FlinkTypeFactory typeFactory, RowType inputRowType, Seq<AggregateCall> aggregateCalls, boolean[] aggCallNeedRetractions, boolean needInputCount, boolean isStateBackendDataViews, boolean needDistinctInfo) {
        return this.transformToStreamAggregateInfoList(typeFactory, inputRowType, aggregateCalls, aggCallNeedRetractions, needInputCount, (Option<Object>)Option$.MODULE$.empty(), isStateBackendDataViews, needDistinctInfo);
    }

    public AggregateInfoList transformToStreamAggregateInfoList(FlinkTypeFactory typeFactory, RowType inputRowType, Seq<AggregateCall> aggregateCalls, boolean[] aggCallNeedRetractions, boolean needInputCount, Option<Object> indexOfExistingCountStar, boolean isStateBackendDataViews, boolean needDistinctInfo) {
        return this.transformToAggregateInfoList(typeFactory, inputRowType, aggregateCalls, (boolean[])new ArrayOps.ofBoolean(Predef$.MODULE$.booleanArrayOps(aggCallNeedRetractions)).$plus$plus((GenTraversableOnce)new ArrayOps.ofBoolean(Predef$.MODULE$.booleanArrayOps(new boolean[]{needInputCount})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean())), null, needInputCount, indexOfExistingCountStar, isStateBackendDataViews, needDistinctInfo, false);
    }

    public boolean transformToStreamAggregateInfoList$default$7() {
        return true;
    }

    private AggregateInfoList transformToAggregateInfoList(FlinkTypeFactory typeFactory, RowType inputRowType, Seq<AggregateCall> aggregateCalls, boolean[] aggCallNeedRetractions, int[] orderKeyIndexes, boolean needInputCount, Option<Object> indexOfExistingCountStar, boolean isStateBackedDataViews, boolean needDistinctInfo, boolean isBounded) {
        Tuple3<Option<Object>, Object, Seq<AggregateCall>> tuple3 = this.insertCountStarAggCall(typeFactory, needInputCount, indexOfExistingCountStar, aggregateCalls);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Option indexOfCountStar = (Option)tuple3._1();
        boolean countStarInserted = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
        Seq aggCalls = (Seq)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)indexOfCountStar, (Object)BoxesRunTime.boxToBoolean((boolean)countStarInserted), (Object)aggCalls);
        Tuple3 tuple33 = tuple32;
        Option indexOfCountStar2 = (Option)tuple33._1();
        boolean countStarInserted2 = BoxesRunTime.unboxToBoolean((Object)tuple33._2());
        Seq aggCalls2 = (Seq)tuple33._3();
        Tuple2<DistinctInfo[], Seq<AggregateCall>> tuple2 = this.extractDistinctInformation(needDistinctInfo, (Seq<AggregateCall>)aggCalls2, inputRowType, isStateBackedDataViews, needInputCount);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        DistinctInfo[] distinctInfos = (DistinctInfo[])tuple2._1();
        Seq newAggCalls = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)distinctInfos, (Object)newAggCalls);
        Tuple2 tuple23 = tuple22;
        DistinctInfo[] distinctInfos2 = (DistinctInfo[])tuple23._1();
        Seq newAggCalls2 = (Seq)tuple23._2();
        AggFunctionFactory factory = new AggFunctionFactory(inputRowType, orderKeyIndexes, aggCallNeedRetractions, isBounded);
        Seq aggInfos = (Seq)((TraversableLike)newAggCalls2.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            AggregateCall call = (AggregateCall)tuple2._1();
            int index = tuple2._2$mcI$sp();
            SqlAggFunction sqlAggFunction = call.getAggregation();
            int[] nArray = sqlAggFunction instanceof SqlRankFunction ? (orderKeyIndexes != null ? orderKeyIndexes : (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int())) : (int[])((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(call.getArgList()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
            int[] argIndexes = nArray;
            AggregateInfo aggregateInfo = MODULE$.transformToAggregateInfo(inputRowType, call, index, argIndexes, factory.createAggFunction(call, index), isStateBackedDataViews, aggCallNeedRetractions[index]);
            return aggregateInfo;
        }, Seq$.MODULE$.canBuildFrom());
        return new AggregateInfoList((AggregateInfo[])aggInfos.toArray(ClassTag$.MODULE$.apply(AggregateInfo.class)), (Option<Object>)indexOfCountStar2, countStarInserted2, distinctInfos2);
    }

    private AggregateInfo transformToAggregateInfo(RowType inputRowType, AggregateCall call, int index, int[] argIndexes, UserDefinedFunction udf, boolean hasStateBackedDataViews, boolean needsRetraction) {
        AggregateInfo aggregateInfo;
        SqlAggFunction sqlAggFunction = call.getAggregation();
        if (sqlAggFunction instanceof BridgingSqlAggFunction) {
            BridgingSqlAggFunction bridgingSqlAggFunction = (BridgingSqlAggFunction)sqlAggFunction;
            aggregateInfo = bridgingSqlAggFunction.getDefinition() instanceof BuiltInFunctionDefinition || bridgingSqlAggFunction.getDefinition() instanceof DeclarativeAggregateFunction ? this.createAggregateInfoFromInternalFunction(call, udf, index, argIndexes, needsRetraction, hasStateBackedDataViews) : this.createAggregateInfoFromBridgingFunction(inputRowType, call, index, argIndexes, hasStateBackedDataViews, needsRetraction);
        } else if (sqlAggFunction instanceof AggSqlFunction) {
            aggregateInfo = this.createAggregateInfoFromLegacyFunction(inputRowType, call, index, argIndexes, (UserDefinedFunction)((ImperativeAggregateFunction)udf), hasStateBackedDataViews, needsRetraction);
        } else if (sqlAggFunction != null) {
            aggregateInfo = this.createAggregateInfoFromInternalFunction(call, udf, index, argIndexes, needsRetraction, hasStateBackedDataViews);
        } else {
            throw new MatchError((Object)sqlAggFunction);
        }
        return aggregateInfo;
    }

    private AggregateInfo createAggregateInfoFromBridgingFunction(RowType inputRowType, AggregateCall call, int index, int[] argIndexes, boolean hasStateBackedDataViews, boolean needsRetraction) {
        BridgingSqlAggFunction function = (BridgingSqlAggFunction)call.getAggregation();
        FunctionDefinition definition = function.getDefinition();
        DataTypeFactory dataTypeFactory = function.getDataTypeFactory();
        OperatorBindingCallContext callContext = new OperatorBindingCallContext(dataTypeFactory, definition, new Aggregate.AggCallBinding(function.getTypeFactory(), function, SqlTypeUtil.projectTypes(function.getTypeFactory().buildRelNodeRowType(inputRowType), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(argIndexes)).map((Function1 & Serializable & scala.Serializable)x -> AggregateUtil$.$anonfun$createAggregateInfoFromBridgingFunction$1(BoxesRunTime.unboxToInt((Object)x)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.class))))).toList())), 0, false), call.getType());
        UserDefinedFunction udf = UserDefinedFunctionHelper.createSpecializedFunction((String)function.getName(), (FunctionDefinition)definition, (CallContext)callContext, (ClassLoader)PlannerBase.class.getClassLoader(), null, null);
        TypeInference inference = udf.getTypeInference(dataTypeFactory);
        CallContext adaptedCallContext = TypeInferenceUtil.adaptArguments((TypeInference)inference, (CallContext)callContext, null);
        Seq enrichedArgumentDataTypes = JavaScalaConversionUtil$.MODULE$.toScala(adaptedCallContext.getArgumentDataTypes());
        DataType enrichedAccumulatorDataType = TypeInferenceUtil.inferOutputType((CallContext)adaptedCallContext, (TypeStrategy)inference.getAccumulatorTypeStrategy().orElse(inference.getOutputTypeStrategy()));
        DataType enrichedOutputDataType = TypeInferenceUtil.inferOutputType((CallContext)adaptedCallContext, (TypeStrategy)inference.getOutputTypeStrategy());
        return this.createImperativeAggregateInfo(call, (ImperativeAggregateFunction)udf, index, argIndexes, (DataType[])enrichedArgumentDataTypes.toArray(ClassTag$.MODULE$.apply(DataType.class)), enrichedAccumulatorDataType, enrichedOutputDataType, needsRetraction, hasStateBackedDataViews);
    }

    private AggregateInfo createAggregateInfoFromInternalFunction(AggregateCall call, UserDefinedFunction udf, int index, int[] argIndexes, boolean needsRetraction, boolean hasStateBackedDataViews) {
        AggregateInfo aggregateInfo;
        UserDefinedFunction userDefinedFunction = udf;
        if (userDefinedFunction instanceof BuiltInAggregateFunction) {
            BuiltInAggregateFunction builtInAggregateFunction = (BuiltInAggregateFunction)userDefinedFunction;
            aggregateInfo = this.createImperativeAggregateInfo(call, (ImperativeAggregateFunction<?, ?>)builtInAggregateFunction, index, argIndexes, (DataType[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(builtInAggregateFunction.getArgumentDataTypes()).asScala()).toArray(ClassTag$.MODULE$.apply(DataType.class)), builtInAggregateFunction.getAccumulatorDataType(), builtInAggregateFunction.getOutputDataType(), needsRetraction, hasStateBackedDataViews);
        } else if (userDefinedFunction instanceof DeclarativeAggregateFunction) {
            DeclarativeAggregateFunction declarativeAggregateFunction = (DeclarativeAggregateFunction)userDefinedFunction;
            aggregateInfo = new AggregateInfo(call, udf, index, argIndexes, null, declarativeAggregateFunction.getAggBufferTypes(), (DataViewSpec[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(DataViewSpec.class)), declarativeAggregateFunction.getResultType(), needsRetraction);
        } else {
            throw new MatchError((Object)userDefinedFunction);
        }
        return aggregateInfo;
    }

    private AggregateInfo createImperativeAggregateInfo(AggregateCall call, ImperativeAggregateFunction<?, ?> udf, int index, int[] argIndexes, DataType[] inputDataTypes, DataType accumulatorDataType, DataType outputDataType, boolean needsRetraction, boolean hasStateBackedDataViews) {
        DataViewSpec[] dataViewSpecs = hasStateBackedDataViews ? (DataViewSpec[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(DataViewUtils.extractDataViews(index, accumulatorDataType)).asScala()).toArray(ClassTag$.MODULE$.apply(DataViewSpec.class)) : (DataViewSpec[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(DataViewSpec.class));
        DataType adjustedAccumulatorDataType = DataViewUtils.adjustDataViews(accumulatorDataType, hasStateBackedDataViews);
        return new AggregateInfo(call, (UserDefinedFunction)udf, index, argIndexes, inputDataTypes, (DataType[])((Object[])new DataType[]{adjustedAccumulatorDataType}), dataViewSpecs, outputDataType, needsRetraction);
    }

    private AggregateInfo createAggregateInfoFromLegacyFunction(RowType inputRowType, AggregateCall call, int index, int[] argIndexes, UserDefinedFunction udf, boolean hasStateBackedDataViews, boolean needsRetraction) {
        Tuple2 tuple2;
        DataType[] externalArgTypes;
        DataType implicitResultType;
        ImperativeAggregateFunction imperativeAggregateFunction;
        UserDefinedFunction userDefinedFunction = udf;
        if (userDefinedFunction instanceof ImperativeAggregateFunction) {
            Tuple2 tuple22;
            imperativeAggregateFunction = (ImperativeAggregateFunction)userDefinedFunction;
            SqlAggFunction sqlAggFunction = call.getAggregation();
            if (sqlAggFunction instanceof AggSqlFunction) {
                AggSqlFunction aggSqlFunction = (AggSqlFunction)sqlAggFunction;
                tuple22 = new Tuple2((Object)aggSqlFunction.externalAccType(), (Object)aggSqlFunction.externalResultType());
            } else {
                tuple22 = new Tuple2(null, null);
            }
            Tuple2 tuple23 = tuple22;
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            DataType implicitAccType = (DataType)tuple23._1();
            DataType implicitResultType2 = (DataType)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)implicitAccType, (Object)implicitResultType2);
            Tuple2 tuple25 = tuple24;
            DataType implicitAccType2 = (DataType)tuple25._1();
            implicitResultType = (DataType)tuple25._2();
            DataType externalAccType = UserDefinedFunctionUtils$.MODULE$.getAccumulatorTypeOfAggregateFunction(imperativeAggregateFunction, implicitAccType2);
            Buffer argTypes = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(call.getArgList()).map((Function1 & Serializable & scala.Serializable)idx -> (LogicalType)inputRowType.getChildren().get(Predef$.MODULE$.Integer2int(idx)), Buffer$.MODULE$.canBuildFrom());
            externalArgTypes = UserDefinedFunctionUtils$.MODULE$.getAggUserDefinedInputTypes(imperativeAggregateFunction, externalAccType, (LogicalType[])argTypes.toArray(ClassTag$.MODULE$.apply(LogicalType.class)));
            Tuple2<DataType, DataViewSpec[]> tuple26 = LegacyDataViewUtils$.MODULE$.useNullSerializerForStateViewFieldsFromAccType(index, imperativeAggregateFunction, externalAccType, hasStateBackedDataViews);
            if (tuple26 == null) {
                throw new MatchError(tuple26);
            }
            DataType newExternalAccType = (DataType)tuple26._1();
            DataViewSpec[] specs = (DataViewSpec[])tuple26._2();
            tuple2 = new Tuple2((Object)newExternalAccType, (Object)specs);
        } else {
            throw new TableException(new StringBuilder(22).append("Unsupported function: ").append(udf).toString());
        }
        Tuple2 tuple27 = tuple2;
        DataType newExternalAccType = (DataType)tuple27._1();
        DataViewSpec[] specs = (DataViewSpec[])tuple27._2();
        Tuple4 tuple4 = new Tuple4((Object)externalArgTypes, (Object)new DataType[]{newExternalAccType}, (Object)specs, (Object)UserDefinedFunctionUtils$.MODULE$.getResultTypeOfAggregateFunction(imperativeAggregateFunction, implicitResultType));
        Tuple4 tuple42 = tuple4;
        if (tuple42 == null) {
            throw new MatchError((Object)tuple42);
        }
        DataType[] externalArgTypes2 = (DataType[])tuple42._1();
        DataType[] externalAccTypes = (DataType[])tuple42._2();
        DataViewSpec[] viewSpecs = (DataViewSpec[])tuple42._3();
        DataType externalResultType = (DataType)tuple42._4();
        Tuple4 tuple43 = new Tuple4((Object)externalArgTypes2, (Object)externalAccTypes, (Object)viewSpecs, (Object)externalResultType);
        Tuple4 tuple44 = tuple43;
        DataType[] externalArgTypes3 = (DataType[])tuple44._1();
        DataType[] externalAccTypes2 = (DataType[])tuple44._2();
        DataViewSpec[] viewSpecs2 = (DataViewSpec[])tuple44._3();
        DataType externalResultType2 = (DataType)tuple44._4();
        return new AggregateInfo(call, udf, index, argIndexes, externalArgTypes3, externalAccTypes2, viewSpecs2, externalResultType2, needsRetraction);
    }

    private Tuple3<Option<Object>, Object, Seq<AggregateCall>> insertCountStarAggCall(FlinkTypeFactory typeFactory, boolean needInputCount, Option<Object> indexOfExistingCountStar, Seq<AggregateCall> aggregateCalls) {
        if (BoxesRunTime.unboxToInt((Object)indexOfExistingCountStar.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1)) >= 0) {
            Predef$.MODULE$.require(needInputCount);
            return new Tuple3(indexOfExistingCountStar, (Object)BoxesRunTime.boxToBoolean((boolean)false), aggregateCalls);
        }
        ObjectRef indexOfCountStar = ObjectRef.create((Object)None$.MODULE$);
        boolean countStarInserted = false;
        if (!needInputCount) {
            return new Tuple3((Object)((Option)indexOfCountStar.elem), (Object)BoxesRunTime.boxToBoolean((boolean)countStarInserted), aggregateCalls);
        }
        Seq newAggCalls = aggregateCalls;
        ((IterableLike)aggregateCalls.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
            AggregateUtil$.$anonfun$insertCountStarAggCall$2(indexOfCountStar, x0$5);
            return BoxedUnit.UNIT;
        });
        if (((Option)indexOfCountStar.elem).isEmpty()) {
            AggregateCall count1 = AggregateCall.create(SqlStdOperatorTable.COUNT, false, false, false, new ArrayList<Integer>(), -1, null, RelCollations.EMPTY, typeFactory.createSqlType(SqlTypeName.BIGINT), "_$count1$_");
            indexOfCountStar.elem = new Some((Object)BoxesRunTime.boxToInteger((int)aggregateCalls.length()));
            countStarInserted = true;
            newAggCalls = (Seq)aggregateCalls.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregateCall[]{count1})), Seq$.MODULE$.canBuildFrom());
        }
        return new Tuple3((Object)((Option)indexOfCountStar.elem), (Object)BoxesRunTime.boxToBoolean((boolean)countStarInserted), newAggCalls);
    }

    private Tuple2<DistinctInfo[], Seq<AggregateCall>> extractDistinctInformation(boolean needDistinctInfo, Seq<AggregateCall> aggCalls, RowType inputType, boolean hasStateBackedDataViews, boolean consumeRetraction) {
        if (!needDistinctInfo) {
            return new Tuple2(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(DistinctInfo.class)), aggCalls);
        }
        LinkedHashMap distinctMap = LinkedHashMap$.MODULE$.empty();
        Seq newAggCalls = (Seq)((TraversableLike)aggCalls.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            AggregateCall aggregateCall;
            Tuple2 tuple2 = x0$6;
            if (tuple2 != null) {
                AggregateCall call = (AggregateCall)tuple2._1();
                int index = tuple2._2$mcI$sp();
                int[] argIndexes = (int[])((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(call.getArgList()).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
                if (call.isDistinct() && !call.isApproximate() && argIndexes.length > 0) {
                    LogicalType[] argTypes = (LogicalType[])((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(call.getArgList()).map((Function1 & Serializable & scala.Serializable)x$13 -> (LogicalType)inputType.getChildren().get(Predef$.MODULE$.Integer2int(x$13)), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(LogicalType.class));
                    LogicalType keyType = MODULE$.createDistinctKeyType(argTypes);
                    DataType keyDataType = DataTypeUtils.toInternalDataType((LogicalType)keyType);
                    DistinctInfo distinctInfo = (DistinctInfo)distinctMap.getOrElseUpdate((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(argIndexes)).mkString(","), (Function0 & Serializable & scala.Serializable)() -> new DistinctInfo(argIndexes, keyDataType, null, false, null, consumeRetraction, (ArrayBuffer<Object>)((ArrayBuffer)ArrayBuffer$.MODULE$.empty()), (ArrayBuffer<Object>)((ArrayBuffer)ArrayBuffer$.MODULE$.empty())));
                    distinctInfo.filterArgs().$plus$eq((Object)BoxesRunTime.boxToInteger((int)call.filterArg));
                    distinctInfo.aggIndexes().$plus$eq((Object)BoxesRunTime.boxToInteger((int)index));
                    aggregateCall = AggregateCall.create(call.getAggregation(), false, false, call.ignoreNulls(), call.getArgList(), -1, null, RelCollations.EMPTY, call.getType(), call.getName());
                } else {
                    aggregateCall = call;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            AggregateCall aggregateCall2 = aggregateCall;
            return aggregateCall2;
        }, Seq$.MODULE$.canBuildFrom());
        int filterArgsLimit = consumeRetraction ? 1 : 64;
        Iterable distinctInfos = (Iterable)((TraversableLike)distinctMap.values().zipWithIndex(Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Tuple2 tuple2 = x0$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DistinctInfo d = (DistinctInfo)tuple2._1();
            int index = tuple2._2$mcI$sp();
            DataType distinctViewDataType = DataViewUtils.createDistinctViewDataType(d.keyType(), d.filterArgs().length(), filterArgsLimit);
            None$ distinctViewSpec = hasStateBackedDataViews ? new Some((Object)DataViewUtils.createDistinctViewSpec(index, distinctViewDataType)) : None$.MODULE$;
            DataType adjustedAccumulatorDataType = DataViewUtils.adjustDataViews(distinctViewDataType, hasStateBackedDataViews);
            DistinctInfo distinctInfo = new DistinctInfo(d.argIndexes(), d.keyType(), adjustedAccumulatorDataType, false, (Option<DataViewUtils.DistinctViewSpec>)distinctViewSpec, consumeRetraction, d.filterArgs(), d.aggIndexes());
            return distinctInfo;
        }, Iterable$.MODULE$.canBuildFrom());
        return new Tuple2(distinctInfos.toArray(ClassTag$.MODULE$.apply(DistinctInfo.class)), (Object)newAggCalls);
    }

    public LogicalType createDistinctKeyType(LogicalType[] argTypes) {
        RowType rowType;
        if (argTypes.length == 1) {
            LogicalTypeRoot logicalTypeRoot = argTypes[0].getTypeRoot();
            boolean bl = LogicalTypeRoot.CHAR.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.DATE.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot) ? true : LogicalTypeRoot.ARRAY.equals(logicalTypeRoot))))))))))))))));
            if (!bl) {
                throw new TableException(new StringBuilder(83).append("Distinct aggregate function does not support type: ").append(logicalTypeRoot).append(".\n").append("Please re-check the data type.").toString());
            }
            LogicalType logicalType = argTypes[0];
            rowType = logicalType;
        } else {
            rowType = RowType.of((LogicalType[])argTypes);
        }
        return rowType;
    }

    public boolean doAllSupportPartialMerge(AggregateInfo[] aggInfos) {
        boolean supportMerge = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggInfos)).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.function(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(UserDefinedFunction.class))))).forall((Function1 & Serializable & scala.Serializable)x0$8 -> BoxesRunTime.boxToBoolean((boolean)AggregateUtil$.$anonfun$doAllSupportPartialMerge$2(x0$8)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggInfos)).isEmpty() || supportMerge;
    }

    public boolean doAllAggSupportAdaptiveLocalHashAgg(Seq<AggregateCall> aggCalls) {
        boolean bl;
        Object object = new Object();
        try {
            bl = aggCalls.forall((Function1 & Serializable & scala.Serializable)aggCall -> BoxesRunTime.boxToBoolean((boolean)AggregateUtil$.$anonfun$doAllAggSupportAdaptiveLocalHashAgg$1(object, aggCall)));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public boolean doAllAggSupportSplit(List<AggregateCall> aggCalls) {
        return JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(aggCalls).forall((Function1 & Serializable & scala.Serializable)aggCall -> BoxesRunTime.boxToBoolean((boolean)AggregateUtil$.$anonfun$doAllAggSupportSplit$1(aggCall)));
    }

    public RelDataType inferStreamLocalAggRowType(AggregateInfoList aggInfoList, RelDataType inputType, int[] groupSet, FlinkTypeFactory typeFactory) {
        DataType[] accTypes = aggInfoList.getAccTypes();
        LogicalType[] groupingTypes = (LogicalType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(groupSet)).map((Function1 & Serializable & scala.Serializable)x$15 -> AggregateUtil$.$anonfun$inferStreamLocalAggRowType$1(inputType, BoxesRunTime.unboxToInt((Object)x$15)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RelDataType.class))))).map((Function1 & Serializable & scala.Serializable)relDataType -> FlinkTypeFactory$.MODULE$.toLogicalType((RelDataType)relDataType), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)));
        String[] groupingNames = (String[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(groupSet)).map((Function1 & Serializable & scala.Serializable)x$16 -> AggregateUtil$.$anonfun$inferStreamLocalAggRowType$3(inputType, BoxesRunTime.unboxToInt((Object)x$16)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] accFieldNames = this.inferStreamAggAccumulatorNames(aggInfoList);
        return typeFactory.buildRelNodeRowType((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])groupingNames)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])accFieldNames)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))), (Seq<LogicalType>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])groupingTypes)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])accTypes)).map((Function1 & Serializable & scala.Serializable)x$1 -> LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)))));
    }

    public String[] inferStreamAggAccumulatorNames(AggregateInfoList aggInfoList) {
        IntRef index = IntRef.create((int)-1);
        IndexedSeq aggBufferNames = (IndexedSeq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggInfoList.aggInfos())).indices().flatMap((Function1 & Serializable & scala.Serializable)i -> new ArrayOps.ofRef(AggregateUtil$.$anonfun$inferStreamAggAccumulatorNames$1(aggInfoList, index, BoxesRunTime.unboxToInt((Object)i))), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq distinctBufferNames = (IndexedSeq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggInfoList.distinctInfos())).indices().map((Function1 & Serializable & scala.Serializable)i -> AggregateUtil$.$anonfun$inferStreamAggAccumulatorNames$3(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        return (String[])((TraversableOnce)aggBufferNames.$plus$plus((GenTraversableOnce)distinctBufferNames, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean needRetraction(StreamPhysicalRel agg) {
        ModifyKindSetTrait modifyKindSetTrait = agg.getInput(0).getTraitSet().getTrait(ModifyKindSetTraitDef$.MODULE$.INSTANCE());
        if (modifyKindSetTrait == null) return false;
        ModifyKindSetTrait modifyKindSetTrait2 = modifyKindSetTrait;
        ModifyKindSetTrait modifyKindSetTrait3 = ModifyKindSetTrait$.MODULE$.EMPTY();
        if (modifyKindSetTrait2 == null) {
            if (modifyKindSetTrait3 == null) return false;
        } else if (((Object)modifyKindSetTrait2).equals(modifyKindSetTrait3)) {
            return false;
        }
        if (modifyKindSetTrait.modifyKindSet().isInsertOnly()) return false;
        return true;
    }

    public boolean[] deriveAggCallNeedRetractions(StreamPhysicalRel agg, int groupCount, Seq<AggregateCall> aggCalls) {
        FlinkRelMetadataQuery fmq = FlinkRelMetadataQuery.reuseOrCreate(agg.getCluster().getMetadataQuery());
        RelModifiedMonotonicity monotonicity = fmq.getRelModifiedMonotonicity(agg);
        boolean needRetractionFlag = this.needRetraction(agg);
        return this.deriveAggCallNeedRetractions(groupCount, aggCalls, needRetractionFlag, monotonicity);
    }

    public boolean[] deriveAggCallNeedRetractions(int groupCount, Seq<AggregateCall> aggCalls, boolean needRetraction, RelModifiedMonotonicity monotonicity) {
        boolean[] needRetractionArray;
        block0: {
            needRetractionArray = (boolean[])Array$.MODULE$.fill(aggCalls.size(), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> needRetraction, ClassTag$.MODULE$.Boolean());
            if (monotonicity == null || !needRetraction) break block0;
            ((IterableLike)aggCalls.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$9 -> {
                AggregateUtil$.$anonfun$deriveAggCallNeedRetractions$2(groupCount, monotonicity, needRetractionArray, x0$9);
                return BoxedUnit.UNIT;
            });
        }
        return needRetractionArray;
    }

    public RelDataType inferLocalAggRowType(AggregateInfoList aggInfoList, RelDataType inputRowType, int[] groupSet, FlinkTypeFactory typeFactory) {
        DataType[] accTypes = aggInfoList.getAccTypes();
        LogicalType[] groupingTypes = (LogicalType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(groupSet)).map((Function1 & Serializable & scala.Serializable)x$17 -> AggregateUtil$.$anonfun$inferLocalAggRowType$1(inputRowType, BoxesRunTime.unboxToInt((Object)x$17)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RelDataType.class))))).map((Function1 & Serializable & scala.Serializable)relDataType -> FlinkTypeFactory$.MODULE$.toLogicalType((RelDataType)relDataType), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)));
        String[] groupingNames = (String[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(groupSet)).map((Function1 & Serializable & scala.Serializable)x$18 -> AggregateUtil$.$anonfun$inferLocalAggRowType$3(inputRowType, BoxesRunTime.unboxToInt((Object)x$18)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] accFieldNames = this.inferAggAccumulatorNames(aggInfoList);
        return typeFactory.buildRelNodeRowType((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])groupingNames)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])accFieldNames)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))), (Seq<LogicalType>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])groupingTypes)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])accTypes)).map((Function1 & Serializable & scala.Serializable)x$1 -> LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)))));
    }

    public String[] inferAggAccumulatorNames(AggregateInfoList aggInfoList) {
        IntRef index = IntRef.create((int)-1);
        IndexedSeq aggBufferNames = (IndexedSeq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggInfoList.aggInfos())).indices().flatMap((Function1 & Serializable & scala.Serializable)i -> new ArrayOps.ofRef(AggregateUtil$.$anonfun$inferAggAccumulatorNames$1(aggInfoList, index, BoxesRunTime.unboxToInt((Object)i))), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq distinctBufferNames = (IndexedSeq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggInfoList.distinctInfos())).indices().map((Function1 & Serializable & scala.Serializable)i -> AggregateUtil$.$anonfun$inferAggAccumulatorNames$3(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        return (String[])((TraversableOnce)aggBufferNames.$plus$plus((GenTraversableOnce)distinctBufferNames, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public Tuple3<Option<Object>, Option<Object>, Option<Object>> computeWindowPropertyPos(Seq<NamedWindowProperty> properties) {
        Tuple4 propPos = (Tuple4)properties.foldRight((Object)new Tuple4((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)0)), (Function2 & Serializable & scala.Serializable)(x0$10, x1$1) -> {
            Tuple4 tuple4;
            Tuple2 tuple2 = new Tuple2(x0$10, x1$1);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            NamedWindowProperty p = (NamedWindowProperty)tuple2._1();
            Tuple4 tuple42 = (Tuple4)tuple2._2();
            if (tuple42 == null) throw new MatchError((Object)tuple2);
            Option s2 = (Option)tuple42._1();
            Option e = (Option)tuple42._2();
            Option rt = (Option)tuple42._3();
            int i = BoxesRunTime.unboxToInt((Object)tuple42._4());
            NamedWindowProperty namedWindowProperty = p;
            if (namedWindowProperty == null) throw new MatchError((Object)namedWindowProperty);
            NamedWindowProperty namedWindowProperty2 = namedWindowProperty;
            boolean bl = false;
            WindowStart windowStart = null;
            boolean bl2 = false;
            WindowEnd windowEnd = null;
            boolean bl3 = false;
            RowtimeAttribute rowtimeAttribute = null;
            WindowProperty windowProperty = namedWindowProperty2.getProperty();
            if (windowProperty instanceof WindowStart) {
                bl = true;
                windowStart = (WindowStart)windowProperty;
                if (s2.isDefined()) {
                    throw new TableException("Duplicate window start property encountered. This is a bug.");
                }
            }
            if (bl) {
                tuple4 = new Tuple4((Object)new Some((Object)BoxesRunTime.boxToInteger((int)i)), (Object)e, (Object)rt, (Object)BoxesRunTime.boxToInteger((int)(i - 1)));
            } else {
                if (windowProperty instanceof WindowEnd) {
                    bl2 = true;
                    windowEnd = (WindowEnd)windowProperty;
                    if (e.isDefined()) {
                        throw new TableException("Duplicate window end property encountered. This is a bug.");
                    }
                }
                if (bl2) {
                    tuple4 = new Tuple4((Object)s2, (Object)new Some((Object)BoxesRunTime.boxToInteger((int)i)), (Object)rt, (Object)BoxesRunTime.boxToInteger((int)(i - 1)));
                } else {
                    if (windowProperty instanceof RowtimeAttribute) {
                        bl3 = true;
                        rowtimeAttribute = (RowtimeAttribute)windowProperty;
                        if (rt.isDefined()) {
                            throw new TableException("Duplicate window rowtime property encountered. This is a bug.");
                        }
                    }
                    if (bl3) {
                        tuple4 = new Tuple4((Object)s2, (Object)e, (Object)new Some((Object)BoxesRunTime.boxToInteger((int)i)), (Object)BoxesRunTime.boxToInteger((int)(i - 1)));
                    } else {
                        if (!(windowProperty instanceof ProctimeAttribute)) throw new MatchError((Object)windowProperty);
                        tuple4 = new Tuple4((Object)s2, (Object)e, (Object)rt, (Object)BoxesRunTime.boxToInteger((int)(i - 1)));
                    }
                }
            }
            Tuple4 tuple43 = tuple4;
            return tuple43;
        });
        return new Tuple3(propPos._1(), propPos._2(), propPos._3());
    }

    public boolean isRowtimeAttribute(FieldReferenceExpression field) {
        return LogicalTypeChecks.isRowtimeAttribute((LogicalType)field.getOutputDataType().getLogicalType());
    }

    public boolean isProctimeAttribute(FieldReferenceExpression field) {
        return LogicalTypeChecks.isProctimeAttribute((LogicalType)field.getOutputDataType().getLogicalType());
    }

    public boolean hasTimeIntervalType(ValueLiteralExpression intervalType) {
        return intervalType.getOutputDataType().getLogicalType().is(LogicalTypeRoot.INTERVAL_DAY_TIME);
    }

    public boolean hasRowIntervalType(ValueLiteralExpression intervalType) {
        return intervalType.getOutputDataType().getLogicalType().is(LogicalTypeRoot.BIGINT);
    }

    public Long toLong(ValueLiteralExpression literalExpr) {
        return (Long)ExpressionUtils.extractValue((Expression)literalExpr, Long.class).get();
    }

    public Duration toDuration(ValueLiteralExpression literalExpr) {
        return (Duration)ExpressionUtils.extractValue((Expression)literalExpr, Duration.class).get();
    }

    public boolean isTableAggregate(List<AggregateCall> aggCalls) {
        return ((IterableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(aggCalls).flatMap((Function1 & Serializable & scala.Serializable)call -> {
            Iterable iterable;
            SqlAggFunction sqlAggFunction = call.getAggregation();
            if (sqlAggFunction instanceof AggSqlFunction) {
                AggSqlFunction aggSqlFunction = (AggSqlFunction)sqlAggFunction;
                iterable = Option$.MODULE$.option2Iterable((Option)new Some(aggSqlFunction.aggregateFunction()));
            } else if (sqlAggFunction instanceof BridgingSqlAggFunction) {
                BridgingSqlAggFunction bridgingSqlAggFunction = (BridgingSqlAggFunction)sqlAggFunction;
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)bridgingSqlAggFunction.getDefinition()));
            } else {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Buffer$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)AggregateUtil$.$anonfun$isTableAggregate$2(x$19)));
    }

    public static final /* synthetic */ boolean $anonfun$containsAccurateDistinctCall$1(AggregateCall call) {
        return call.isDistinct() && !call.isApproximate();
    }

    public static final /* synthetic */ boolean $anonfun$containsApproximateDistinctCall$1(AggregateCall call) {
        return call.isDistinct() && call.isApproximate();
    }

    public static final /* synthetic */ boolean $anonfun$getGroupIdExprIndexes$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AggregateCall call = (AggregateCall)tuple2._1();
        SqlKind sqlKind = call.getAggregation().getKind();
        boolean bl = ((Object)((Object)SqlKind.GROUP_ID)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.GROUPING)).equals((Object)sqlKind) ? true : ((Object)((Object)SqlKind.GROUPING_ID)).equals((Object)sqlKind));
        boolean bl2 = bl;
        boolean bl3 = bl2;
        return bl3;
    }

    public static final /* synthetic */ int $anonfun$getGroupIdExprIndexes$2(Tuple2 x0$2) {
        int idx;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = idx = tuple2._2$mcI$sp();
        return n;
    }

    public static final /* synthetic */ String $anonfun$checkAndSplitAggCalls$2() {
        return "AUXILIARY_GROUP should be in the front of aggCall list";
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$checkAndSplitAggCalls$1(IntRef nonAuxGroupCallsStartIdx$1, Tuple2 x0$3) {
        block5: {
            block4: {
                var3_2 = x0$3;
                if (var3_2 == null) break block4;
                call = (AggregateCall)var3_2._1();
                idx = var3_2._2$mcI$sp();
                v0 = call.getAggregation();
                var6_5 = FlinkSqlOperatorTable.AUXILIARY_GROUP;
                if (!(v0 != null ? v0.equals(var6_5) == false : var6_5 != null)) {
                    Predef$.MODULE$.require(call.getArgList().size() == 1);
                }
                if (nonAuxGroupCallsStartIdx$1.elem >= 0) {
                    v1 = call.getAggregation();
                    var7_6 = FlinkSqlOperatorTable.AUXILIARY_GROUP;
                    Predef$.MODULE$.require(v1 == null ? var7_6 != null : v1.equals(var7_6) == false, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$checkAndSplitAggCalls$2(), ()Ljava/lang/String;)());
                }
                if (nonAuxGroupCallsStartIdx$1.elem >= 0) ** GOTO lbl-1000
                v2 = call.getAggregation();
                var8_7 = FlinkSqlOperatorTable.AUXILIARY_GROUP;
                if (v2 == null ? var8_7 != null : v2.equals(var8_7) == false) {
                    nonAuxGroupCallsStartIdx$1.elem = idx;
                    v3 = BoxedUnit.UNIT;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = BoxedUnit.UNIT;
                }
                break block5;
            }
            throw new MatchError((Object)var3_2);
        }
        var2_8 = v3;
    }

    public static final /* synthetic */ Integer $anonfun$createAggregateInfoFromBridgingFunction$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ void $anonfun$insertCountStarAggCall$2(ObjectRef indexOfCountStar$1, Tuple2 x0$5) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$5;
        if (tuple2 != null) {
            AggregateCall call = (AggregateCall)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (call.getAggregation() instanceof SqlCountAggFunction && call.filterArg < 0 && call.getArgList().isEmpty() && !call.isApproximate() && !call.isDistinct()) {
                indexOfCountStar$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)index));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$doAllSupportPartialMerge$2(UserDefinedFunction x0$8) {
        UserDefinedFunction userDefinedFunction = x0$8;
        boolean bl = userDefinedFunction instanceof DeclarativeAggregateFunction ? true : UserDefinedFunctionUtils$.MODULE$.ifMethodExistInFunction("merge", userDefinedFunction);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$doAllAggSupportAdaptiveLocalHashAgg$1(Object nonLocalReturnKey1$1, AggregateCall aggCall) {
        if (aggCall.filterArg >= 0) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
        }
        SqlAggFunction sqlAggFunction = aggCall.getAggregation();
        boolean bl = sqlAggFunction instanceof SqlCountAggFunction ? true : (sqlAggFunction instanceof SqlAvgAggFunction ? true : (sqlAggFunction instanceof SqlMinMaxAggFunction ? true : sqlAggFunction instanceof SqlSumAggFunction));
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$doAllAggSupportSplit$1(AggregateCall aggCall) {
        boolean bl;
        SqlAggFunction sqlAggFunction = aggCall.getAggregation();
        boolean bl2 = sqlAggFunction instanceof SqlCountAggFunction ? true : (sqlAggFunction instanceof SqlAvgAggFunction ? true : (sqlAggFunction instanceof SqlMinMaxAggFunction ? true : (sqlAggFunction instanceof SqlSumAggFunction ? true : (sqlAggFunction instanceof SqlSumEmptyIsZeroAggFunction ? true : sqlAggFunction instanceof SqlSingleValueAggFunction))));
        boolean bl3 = bl2 ? true : ((bl = sqlAggFunction instanceof SqlFirstLastValueAggFunction ? true : sqlAggFunction instanceof SqlListAggFunction) ? aggCall.getArgList().size() == 1 : false);
        return bl3;
    }

    public static final /* synthetic */ RelDataType $anonfun$inferStreamLocalAggRowType$1(RelDataType inputType$2, int x$15) {
        return inputType$2.getFieldList().get(x$15).getType();
    }

    public static final /* synthetic */ String $anonfun$inferStreamLocalAggRowType$3(RelDataType inputType$2, int x$16) {
        return inputType$2.getFieldNames().get(x$16);
    }

    public static final /* synthetic */ Object[] $anonfun$inferStreamAggAccumulatorNames$1(AggregateInfoList aggInfoList$1, IntRef index$1, int i) {
        Object[] objectArray;
        UserDefinedFunction userDefinedFunction = aggInfoList$1.aggInfos()[i].function();
        if (userDefinedFunction instanceof AggregateFunction) {
            String name = aggInfoList$1.aggInfos()[i].agg().getAggregation().getName().toLowerCase();
            ++index$1.elem;
            objectArray = Predef$.MODULE$.refArrayOps((Object[])new String[]{new StringBuilder(1).append(name).append("$").append(index$1.elem).toString()});
        } else if (userDefinedFunction instanceof DeclarativeAggregateFunction) {
            DeclarativeAggregateFunction declarativeAggregateFunction = (DeclarativeAggregateFunction)userDefinedFunction;
            objectArray = Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])declarativeAggregateFunction.aggBufferAttributes())).map((Function1 & Serializable & scala.Serializable)a -> {
                ++index$1.elem;
                return new StringBuilder(1).append(a.getName()).append("$").append(index$1.elem).toString();
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        } else {
            throw new MatchError((Object)userDefinedFunction);
        }
        return objectArray;
    }

    public static final /* synthetic */ String $anonfun$inferStreamAggAccumulatorNames$3(int i) {
        return new StringBuilder(9).append("distinct$").append(i).toString();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$deriveAggCallNeedRetractions$2(int groupCount$1, RelModifiedMonotonicity monotonicity$1, boolean[] needRetractionArray$1, Tuple2 x0$9) {
        block4: {
            block2: {
                block3: {
                    var6_4 = x0$9;
                    if (var6_4 == null) break block2;
                    aggCall = (AggregateCall)var6_4._1();
                    idx = var6_4._2$mcI$sp();
                    var9_7 = false;
                    var10_8 = null;
                    var11_9 = aggCall.getAggregation();
                    if (!(var11_9 instanceof SqlMinMaxAggFunction)) break block3;
                    var9_7 = true;
                    var10_8 = (SqlMinMaxAggFunction)var11_9;
                    v0 = var10_8.getKind();
                    var12_10 = SqlKind.MIN;
                    if (v0 != null ? v0.equals((Object)var12_10) == false : var12_10 != null) break block3;
                    v1 = monotonicity$1.fieldMonotonicities()[groupCount$1 + idx];
                    var13_11 = SqlMonotonicity.DECREASING;
                    if (v1 != null ? v1.equals((Object)var13_11) == false : var13_11 != null) break block3;
                    needRetractionArray$1[idx] = false;
                    var5_12 = BoxedUnit.UNIT;
                    break block4;
                }
                if (!var9_7) ** GOTO lbl-1000
                v2 = var10_8.getKind();
                var14_15 = SqlKind.MAX;
                if (v2 != null ? v2.equals((Object)var14_15) == false : var14_15 != null) ** GOTO lbl-1000
                v3 = monotonicity$1.fieldMonotonicities()[groupCount$1 + idx];
                var15_16 = SqlMonotonicity.INCREASING;
                if (!(v3 != null ? v3.equals((Object)var15_16) == false : var15_16 != null)) {
                    needRetractionArray$1[idx] = false;
                    var5_13 = BoxedUnit.UNIT;
                } else lbl-1000:
                // 3 sources

                {
                    var5_14 = BoxedUnit.UNIT;
                }
                break block4;
            }
            throw new MatchError((Object)var6_4);
        }
        var4_17 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ RelDataType $anonfun$inferLocalAggRowType$1(RelDataType inputRowType$1, int x$17) {
        return inputRowType$1.getFieldList().get(x$17).getType();
    }

    public static final /* synthetic */ String $anonfun$inferLocalAggRowType$3(RelDataType inputRowType$1, int x$18) {
        return inputRowType$1.getFieldNames().get(x$18);
    }

    public static final /* synthetic */ Object[] $anonfun$inferAggAccumulatorNames$1(AggregateInfoList aggInfoList$2, IntRef index$2, int i) {
        Object[] objectArray;
        UserDefinedFunction userDefinedFunction = aggInfoList$2.aggInfos()[i].function();
        if (userDefinedFunction instanceof AggregateFunction) {
            String name = aggInfoList$2.aggInfos()[i].agg().getAggregation().getName().toLowerCase();
            ++index$2.elem;
            objectArray = Predef$.MODULE$.refArrayOps((Object[])new String[]{new StringBuilder(1).append(name).append("$").append(index$2.elem).toString()});
        } else if (userDefinedFunction instanceof DeclarativeAggregateFunction) {
            DeclarativeAggregateFunction declarativeAggregateFunction = (DeclarativeAggregateFunction)userDefinedFunction;
            objectArray = Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])declarativeAggregateFunction.aggBufferAttributes())).map((Function1 & Serializable & scala.Serializable)a -> {
                ++index$2.elem;
                return new StringBuilder(1).append(a.getName()).append("$").append(index$2.elem).toString();
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        } else {
            throw new MatchError((Object)userDefinedFunction);
        }
        return objectArray;
    }

    public static final /* synthetic */ String $anonfun$inferAggAccumulatorNames$3(int i) {
        return new StringBuilder(9).append("distinct$").append(i).toString();
    }

    public static final /* synthetic */ boolean $anonfun$isTableAggregate$2(FunctionDefinition x$19) {
        FunctionKind functionKind = x$19.getKind();
        FunctionKind functionKind2 = FunctionKind.TABLE_AGGREGATE;
        return !(functionKind != null ? !functionKind.equals(functionKind2) : functionKind2 != null);
    }

    private AggregateUtil$() {
        MODULE$ = this;
    }
}

