/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.schema;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.catalog.CatalogSchemaTable;
import org.apache.flink.table.planner.connectors.DynamicSourceUtils;
import org.apache.flink.table.planner.hint.FlinkHints;
import org.apache.flink.table.planner.plan.schema.FlinkPreparingTableBase;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.util.OptionalUtils;
import org.apache.flink.util.Preconditions;

public final class CatalogSourceTable
extends FlinkPreparingTableBase {
    private final CatalogSchemaTable schemaTable;

    public CatalogSourceTable(RelOptSchema relOptSchema, List<String> names, RelDataType rowType, CatalogSchemaTable schemaTable) {
        super(relOptSchema, rowType, names, schemaTable.getStatistic());
        this.schemaTable = schemaTable;
    }

    public static CatalogSourceTable createAnonymous(FlinkRelBuilder relBuilder, ContextResolvedTable contextResolvedTable, boolean isBatchMode) {
        Preconditions.checkArgument((boolean)contextResolvedTable.isAnonymous(), (Object)"ContextResolvedTable must be anonymous");
        FlinkStatistic flinkStatistic = FlinkStatistic.unknown(contextResolvedTable.getResolvedSchema()).build();
        CatalogSchemaTable catalogSchemaTable = new CatalogSchemaTable(contextResolvedTable, flinkStatistic, !isBatchMode);
        return new CatalogSourceTable(relBuilder.getRelOptSchema(), contextResolvedTable.getIdentifier().toList(), catalogSchemaTable.getRowType(relBuilder.getTypeFactory()), catalogSchemaTable);
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext toRelContext) {
        RelOptCluster cluster = toRelContext.getCluster();
        List<RelHint> hints = toRelContext.getTableHints();
        FlinkContext context = ShortcutUtils.unwrapContext(cluster);
        FlinkRelBuilder relBuilder = FlinkRelBuilder.of(cluster, this.relOptSchema);
        Map<String, String> hintedOptions = FlinkHints.getHintedOptions(hints);
        ContextResolvedTable contextTableWithHints = this.computeContextResolvedTable(context, hintedOptions);
        DynamicTableSource tableSource = this.createDynamicTableSource(context, (ResolvedCatalogTable)contextTableWithHints.getResolvedTable());
        return DynamicSourceUtils.convertSourceToRel(!this.schemaTable.isStreamingMode(), (ReadableConfig)context.getTableConfig(), relBuilder, contextTableWithHints, this.schemaTable.getStatistic(), hints, tableSource);
    }

    private ContextResolvedTable computeContextResolvedTable(FlinkContext context, Map<String, String> hintedOptions) {
        ContextResolvedTable contextResolvedTable = this.schemaTable.getContextResolvedTable();
        if (hintedOptions.isEmpty()) {
            return contextResolvedTable;
        }
        if (!((Boolean)context.getTableConfig().get(TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED)).booleanValue()) {
            throw new ValidationException(String.format("The '%s' hint is allowed only when the config option '%s' is set to true.", "OPTIONS", TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED.key()));
        }
        if (contextResolvedTable.getResolvedTable().getTableKind() == CatalogBaseTable.TableKind.VIEW) {
            throw new ValidationException(String.format("View '%s' cannot be enriched with new options. Hints can only be applied to tables.", contextResolvedTable.getIdentifier()));
        }
        return contextResolvedTable.copy(FlinkHints.mergeTableOptions(hintedOptions, contextResolvedTable.getResolvedTable().getOptions()));
    }

    private DynamicTableSource createDynamicTableSource(FlinkContext context, ResolvedCatalogTable catalogTable) {
        Optional<DynamicTableSourceFactory> factoryFromCatalog = this.schemaTable.getContextResolvedTable().getCatalog().flatMap(Catalog::getFactory).map(f -> f instanceof DynamicTableSourceFactory ? (DynamicTableSourceFactory)f : null);
        Optional factoryFromModule = context.getModuleManager().getFactory(Module::getTableSourceFactory);
        DynamicTableSourceFactory factory = OptionalUtils.firstPresent((Optional[])new Optional[]{factoryFromCatalog, factoryFromModule}).orElse(null);
        return FactoryUtil.createDynamicTableSource((DynamicTableSourceFactory)factory, (ObjectIdentifier)this.schemaTable.getContextResolvedTable().getIdentifier(), (ResolvedCatalogTable)catalogTable, (ReadableConfig)context.getTableConfig(), (ClassLoader)context.getClassLoader(), (boolean)this.schemaTable.isTemporary());
    }

    public CatalogTable getCatalogTable() {
        return (CatalogTable)this.schemaTable.getContextResolvedTable().getResolvedTable();
    }
}

