/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.Collections;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Uncollect;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlFunction;
import org.apache.flink.table.planner.plan.rules.logical.ImmutableUncollectToTableFunctionScanRule;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.runtime.functions.table.UnnestRowsFunction;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;
import org.immutables.value.Value;

@Value.Enclosing
public class UncollectToTableFunctionScanRule
extends RelRule<UncollectToTableFunctionScanRuleConfig> {
    public static final UncollectToTableFunctionScanRule INSTANCE = UncollectToTableFunctionScanRuleConfig.DEFAULT.toRule();

    public UncollectToTableFunctionScanRule(UncollectToTableFunctionScanRuleConfig config) {
        super(config);
    }

    private boolean isProjectFilterValues(RelNode relNode) {
        if (relNode instanceof LogicalProject) {
            return this.isProjectFilterValues(((LogicalProject)relNode).getInput());
        }
        if (relNode instanceof LogicalFilter) {
            return this.isProjectFilterValues(((LogicalFilter)relNode).getInput());
        }
        if (relNode instanceof HepRelVertex) {
            return this.isProjectFilterValues(((HepRelVertex)relNode).getCurrentRel());
        }
        return relNode instanceof LogicalValues;
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Uncollect array = (Uncollect)call.rel(0);
        return this.isProjectFilterValues(array.getInput());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Uncollect array = (Uncollect)call.rel(0);
        RelNode tableFunctionScan = this.convertUncollect(array);
        call.transformTo(tableFunctionScan);
    }

    private RelNode convertUncollect(Uncollect uc) {
        RelOptCluster cluster = uc.getCluster();
        FlinkTypeFactory typeFactory = ShortcutUtils.unwrapTypeFactory(cluster);
        RelDataType relDataType = (RelDataType)uc.getInput().getRowType().getFieldList().get(0).getValue();
        LogicalType logicalType = FlinkTypeFactory.toLogicalType(relDataType);
        BridgingSqlFunction sqlFunction = BridgingSqlFunction.of(cluster, BuiltInFunctionDefinitions.INTERNAL_UNNEST_ROWS);
        RexNode rexCall = cluster.getRexBuilder().makeCall(typeFactory.createFieldTypeFromLogicalType((LogicalType)LogicalTypeUtils.toRowType((LogicalType)UnnestRowsFunction.getUnnestedType((LogicalType)logicalType))), sqlFunction, ((LogicalProject)this.getRel(uc.getInput())).getProjects());
        return new LogicalTableFunctionScan(cluster, uc.getTraitSet(), Collections.emptyList(), rexCall, null, rexCall.getType(), null);
    }

    private RelNode getRel(RelNode rel) {
        if (rel instanceof HepRelVertex) {
            return ((HepRelVertex)rel).getCurrentRel();
        }
        return rel;
    }

    @Value.Immutable(singleton=false)
    public static interface UncollectToTableFunctionScanRuleConfig
    extends RelRule.Config {
        public static final UncollectToTableFunctionScanRuleConfig DEFAULT = ImmutableUncollectToTableFunctionScanRule.UncollectToTableFunctionScanRuleConfig.builder().build().withOperandSupplier(b0 -> b0.operand(Uncollect.class).anyInputs()).withDescription("UncollectToTableFunctionScanRule");

        @Override
        default public UncollectToTableFunctionScanRule toRule() {
            return new UncollectToTableFunctionScanRule(this);
        }
    }
}

