/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.flink.sql.parser.ddl.SqlReplaceTableAs;
import org.apache.flink.sql.parser.ddl.SqlTableOption;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.ReplaceTableAsOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.operations.MergeTableAsUtil;
import org.apache.flink.table.planner.operations.PlannerQueryOperation;
import org.apache.flink.table.planner.operations.SqlNodeToOperationConversion;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.utils.OperationConverterUtils;

public class SqlReplaceTableAsConverter
implements SqlNodeConverter<SqlReplaceTableAs> {
    @Override
    public Operation convertSqlNode(SqlReplaceTableAs sqlReplaceTableAs, SqlNodeConverter.ConvertContext context) {
        CatalogManager catalogManager = context.getCatalogManager();
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlReplaceTableAs.fullTableName());
        ObjectIdentifier identifier = catalogManager.qualifyIdentifier(unresolvedIdentifier);
        FlinkPlannerImpl flinkPlanner = context.getFlinkPlanner();
        MergeTableAsUtil mergeTableAsUtil = new MergeTableAsUtil(context.getSqlValidator(), sqlNode -> sqlNode.toString(), catalogManager.getDataTypeFactory());
        PlannerQueryOperation query = (PlannerQueryOperation)SqlNodeToOperationConversion.convert(flinkPlanner, catalogManager, sqlReplaceTableAs.getAsQuery()).orElseThrow(() -> new TableException("RTAS unsupported node type " + sqlReplaceTableAs.getAsQuery().getClass().getSimpleName()));
        ResolvedCatalogTable tableWithResolvedSchema = this.createCatalogTable(context, mergeTableAsUtil, sqlReplaceTableAs, query.getResolvedSchema());
        query = mergeTableAsUtil.maybeRewriteQuery(context.getCatalogManager(), flinkPlanner, query, sqlReplaceTableAs.getAsQuery(), tableWithResolvedSchema);
        CreateTableOperation createTableOperation = new CreateTableOperation(identifier, (CatalogTable)tableWithResolvedSchema, sqlReplaceTableAs.isIfNotExists(), sqlReplaceTableAs.isTemporary());
        return new ReplaceTableAsOperation(createTableOperation, (QueryOperation)query, sqlReplaceTableAs.isCreateOrReplace());
    }

    private ResolvedCatalogTable createCatalogTable(SqlNodeConverter.ConvertContext context, MergeTableAsUtil mergeTableAsUtil, SqlReplaceTableAs sqlReplaceTableAs, ResolvedSchema querySchema) {
        CatalogManager catalogManager = context.getCatalogManager();
        String tableComment = OperationConverterUtils.getTableComment(sqlReplaceTableAs.getComment());
        HashMap properties = new HashMap();
        sqlReplaceTableAs.getPropertyList().getList().forEach(p -> properties.put(((SqlTableOption)p).getKeyString(), ((SqlTableOption)p).getValueString()));
        Schema mergedSchema = sqlReplaceTableAs.isSchemaWithColumnsIdentifiersOnly() ? mergeTableAsUtil.reorderSchema(sqlReplaceTableAs.getColumnList(), querySchema) : mergeTableAsUtil.mergeSchemas(sqlReplaceTableAs.getColumnList(), sqlReplaceTableAs.getWatermark().orElse(null), sqlReplaceTableAs.getFullConstraints(), querySchema);
        Optional<TableDistribution> tableDistribution = Optional.ofNullable(sqlReplaceTableAs.getDistribution()).map(OperationConverterUtils::getDistributionFromSqlDistribution);
        List<String> partitionKeys = this.getPartitionKeyColumnNames(sqlReplaceTableAs.getPartitionKeyList());
        this.verifyPartitioningColumnsExist(mergedSchema, partitionKeys);
        CatalogTable catalogTable = CatalogTable.newBuilder().schema(mergedSchema).comment(tableComment).distribution((TableDistribution)tableDistribution.orElse(null)).options(properties).partitionKeys(partitionKeys).build();
        return catalogManager.resolveCatalogTable(catalogTable);
    }

    private List<String> getPartitionKeyColumnNames(SqlNodeList partitionKey) {
        return partitionKey.getList().stream().map(p -> ((SqlIdentifier)p).getSimple()).collect(Collectors.toList());
    }

    private void verifyPartitioningColumnsExist(Schema mergedSchema, List<String> partitionKeys) {
        Set columnNames = mergedSchema.getColumns().stream().map(Schema.UnresolvedColumn::getName).collect(Collectors.toCollection(LinkedHashSet::new));
        for (String partitionKey : partitionKeys) {
            if (columnNames.contains(partitionKey)) continue;
            throw new ValidationException(String.format("Partition column '%s' not defined in the table schema. Available columns: [%s]", partitionKey, columnNames.stream().collect(Collectors.joining("', '", "'", "'"))));
        }
    }
}

