/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.ddl.SqlTableLike;
import org.apache.flink.sql.parser.ddl.SqlWatermark;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.operations.SchemaBuilderUtil;
import org.apache.flink.table.types.logical.LogicalType;

class MergeTableLikeUtil {
    private static final HashMap<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> defaultMergingStrategies = new HashMap();
    private final SqlValidator validator;
    private final Function<SqlNode, String> escapeExpression;
    private final DataTypeFactory dataTypeFactory;

    MergeTableLikeUtil(SqlValidator validator, Function<SqlNode, String> escapeExpression, DataTypeFactory dataTypeFactory) {
        this.validator = validator;
        this.escapeExpression = escapeExpression;
        this.dataTypeFactory = dataTypeFactory;
    }

    public Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> computeMergingStrategies(List<SqlTableLike.SqlTableLikeOption> mergingOptions) {
        HashMap<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> result = new HashMap<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy>(defaultMergingStrategies);
        Optional<SqlTableLike.SqlTableLikeOption> maybeAllOption = mergingOptions.stream().filter(option -> option.getFeatureOption() == SqlTableLike.FeatureOption.ALL).findFirst();
        maybeAllOption.ifPresent(allOption -> {
            SqlTableLike.MergingStrategy strategy = allOption.getMergingStrategy();
            for (SqlTableLike.FeatureOption featureOption : SqlTableLike.FeatureOption.values()) {
                if (featureOption == SqlTableLike.FeatureOption.ALL) continue;
                result.put(featureOption, strategy);
            }
        });
        for (SqlTableLike.SqlTableLikeOption mergingOption : mergingOptions) {
            result.put(mergingOption.getFeatureOption(), mergingOption.getMergingStrategy());
        }
        return result;
    }

    public Schema mergeTables(Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies, Schema sourceSchema, List<SqlNode> derivedColumns, List<SqlWatermark> derivedWatermarkSpecs, SqlTableConstraint derivedPrimaryKey) {
        SchemaBuilder schemaBuilder = new SchemaBuilder(mergingStrategies, sourceSchema, (FlinkTypeFactory)this.validator.getTypeFactory(), this.dataTypeFactory, this.validator, this.escapeExpression);
        schemaBuilder.appendDerivedColumns(mergingStrategies, derivedColumns);
        schemaBuilder.appendDerivedWatermarks(mergingStrategies, derivedWatermarkSpecs);
        schemaBuilder.appendDerivedPrimaryKey(derivedPrimaryKey);
        return schemaBuilder.build();
    }

    public Optional<TableDistribution> mergeDistribution(SqlTableLike.MergingStrategy mergingStrategy, Optional<TableDistribution> sourceTableDistribution, Optional<TableDistribution> derivedTabledDistribution) {
        if (derivedTabledDistribution.isPresent() && sourceTableDistribution.isPresent() && mergingStrategy != SqlTableLike.MergingStrategy.EXCLUDING) {
            throw new ValidationException("The base table already has a distribution defined. You might want to specify EXCLUDING DISTRIBUTION.");
        }
        if (derivedTabledDistribution.isPresent()) {
            return derivedTabledDistribution;
        }
        return sourceTableDistribution;
    }

    public List<String> mergePartitions(SqlTableLike.MergingStrategy mergingStrategy, List<String> sourcePartitions, List<String> derivedPartitions) {
        if (!derivedPartitions.isEmpty() && !sourcePartitions.isEmpty() && mergingStrategy != SqlTableLike.MergingStrategy.EXCLUDING) {
            throw new ValidationException("The base table already has partitions defined. You might want to specify EXCLUDING PARTITIONS.");
        }
        if (!derivedPartitions.isEmpty()) {
            return derivedPartitions;
        }
        return sourcePartitions;
    }

    public Map<String, String> mergeOptions(SqlTableLike.MergingStrategy mergingStrategy, Map<String, String> sourceOptions, Map<String, String> derivedOptions) {
        HashMap<String, String> options = new HashMap<String, String>();
        if (mergingStrategy != SqlTableLike.MergingStrategy.EXCLUDING) {
            options.putAll(sourceOptions);
        }
        derivedOptions.forEach((key, value) -> {
            if (mergingStrategy != SqlTableLike.MergingStrategy.OVERWRITING && options.containsKey(key)) {
                throw new ValidationException(String.format("There already exists an option ['%s' -> '%s']  in the base table. You might want to specify EXCLUDING OPTIONS or OVERWRITING OPTIONS.", key, options.get(key)));
            }
            options.put((String)key, (String)value);
        });
        return options;
    }

    static {
        defaultMergingStrategies.put(SqlTableLike.FeatureOption.OPTIONS, SqlTableLike.MergingStrategy.OVERWRITING);
        defaultMergingStrategies.put(SqlTableLike.FeatureOption.WATERMARKS, SqlTableLike.MergingStrategy.INCLUDING);
        defaultMergingStrategies.put(SqlTableLike.FeatureOption.GENERATED, SqlTableLike.MergingStrategy.INCLUDING);
        defaultMergingStrategies.put(SqlTableLike.FeatureOption.METADATA, SqlTableLike.MergingStrategy.INCLUDING);
        defaultMergingStrategies.put(SqlTableLike.FeatureOption.CONSTRAINTS, SqlTableLike.MergingStrategy.INCLUDING);
        defaultMergingStrategies.put(SqlTableLike.FeatureOption.DISTRIBUTION, SqlTableLike.MergingStrategy.INCLUDING);
        defaultMergingStrategies.put(SqlTableLike.FeatureOption.PARTITIONS, SqlTableLike.MergingStrategy.INCLUDING);
    }

    private static class SchemaBuilder
    extends SchemaBuilderUtil {
        Map<String, RelDataType> physicalFieldNamesToTypes = new LinkedHashMap<String, RelDataType>();
        Map<String, RelDataType> metadataFieldNamesToTypes = new LinkedHashMap<String, RelDataType>();
        Map<String, RelDataType> computedFieldNamesToTypes = new LinkedHashMap<String, RelDataType>();
        FlinkTypeFactory typeFactory;

        SchemaBuilder(Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies, Schema sourceSchema, FlinkTypeFactory typeFactory, DataTypeFactory dataTypeFactory, SqlValidator sqlValidator, Function<SqlNode, String> escapeExpressions) {
            super(sqlValidator, escapeExpressions, dataTypeFactory);
            this.typeFactory = typeFactory;
            this.populateColumnsFromSourceTable(mergingStrategies, sourceSchema);
            this.populateWatermarksFromSourceTable(mergingStrategies, sourceSchema);
            this.populatePrimaryKeyFromSourceTable(mergingStrategies, sourceSchema);
        }

        private void populateColumnsFromSourceTable(Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies, Schema sourceSchema) {
            for (Schema.UnresolvedColumn sourceColumn : sourceSchema.getColumns()) {
                if (sourceColumn instanceof Schema.UnresolvedPhysicalColumn) {
                    LogicalType columnType = this.getLogicalType((Schema.UnresolvedPhysicalColumn)sourceColumn);
                    this.physicalFieldNamesToTypes.put(sourceColumn.getName(), this.typeFactory.createFieldTypeFromLogicalType(columnType));
                    this.columns.put(sourceColumn.getName(), sourceColumn);
                    continue;
                }
                if (sourceColumn instanceof Schema.UnresolvedComputedColumn) {
                    if (mergingStrategies.get((Object)SqlTableLike.FeatureOption.GENERATED) == SqlTableLike.MergingStrategy.EXCLUDING) continue;
                    this.columns.put(sourceColumn.getName(), sourceColumn);
                    continue;
                }
                if (!(sourceColumn instanceof Schema.UnresolvedMetadataColumn) || mergingStrategies.get((Object)SqlTableLike.FeatureOption.METADATA) == SqlTableLike.MergingStrategy.EXCLUDING) continue;
                this.columns.put(sourceColumn.getName(), sourceColumn);
            }
        }

        private void populateWatermarksFromSourceTable(Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies, Schema sourceSchema) {
            for (Schema.UnresolvedWatermarkSpec sourceWatermarkSpec : sourceSchema.getWatermarkSpecs()) {
                if (mergingStrategies.get((Object)SqlTableLike.FeatureOption.WATERMARKS) == SqlTableLike.MergingStrategy.EXCLUDING) continue;
                this.watermarkSpecs.put(sourceWatermarkSpec.getColumnName(), sourceWatermarkSpec);
            }
        }

        private void populatePrimaryKeyFromSourceTable(Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies, Schema sourceSchema) {
            if (sourceSchema.getPrimaryKey().isPresent() && mergingStrategies.get((Object)SqlTableLike.FeatureOption.CONSTRAINTS) == SqlTableLike.MergingStrategy.INCLUDING) {
                this.primaryKey = (Schema.UnresolvedPrimaryKey)sourceSchema.getPrimaryKey().get();
            }
        }

        private void appendDerivedPrimaryKey(@Nullable SqlTableConstraint derivedPrimaryKey) {
            if (derivedPrimaryKey != null && this.primaryKey != null) {
                throw new ValidationException("The base table already has a primary key. You might want to specify EXCLUDING CONSTRAINTS.");
            }
            if (derivedPrimaryKey != null) {
                this.setPrimaryKey(derivedPrimaryKey);
            }
        }

        private void appendDerivedWatermarks(Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies, List<SqlWatermark> derivedWatermarkSpecs) {
            if (mergingStrategies.get((Object)SqlTableLike.FeatureOption.WATERMARKS) != SqlTableLike.MergingStrategy.OVERWRITING) {
                for (SqlWatermark derivedWatermarkSpec : derivedWatermarkSpecs) {
                    SqlIdentifier eventTimeColumnName = derivedWatermarkSpec.getEventTimeColumnName();
                    String rowtimeAttribute = eventTimeColumnName.toString();
                    if (!this.watermarkSpecs.containsKey(rowtimeAttribute)) continue;
                    throw new ValidationException(String.format("There already exists a watermark spec for column '%s' in the base table. You might want to specify EXCLUDING WATERMARKS or OVERWRITING WATERMARKS.", rowtimeAttribute));
                }
            }
            LinkedHashMap<String, RelDataType> nameToTypeMap = new LinkedHashMap<String, RelDataType>();
            nameToTypeMap.putAll(this.physicalFieldNamesToTypes);
            nameToTypeMap.putAll(this.metadataFieldNamesToTypes);
            nameToTypeMap.putAll(this.computedFieldNamesToTypes);
            this.addWatermarks(derivedWatermarkSpecs, nameToTypeMap, true);
        }

        private void appendDerivedColumns(Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies, List<SqlNode> derivedColumns) {
            this.collectPhysicalFieldsTypes(derivedColumns);
            for (SqlNode derivedColumn : derivedColumns) {
                Schema.UnresolvedPhysicalColumn column;
                String name = ((SqlTableColumn)derivedColumn).getName().getSimple();
                if (derivedColumn instanceof SqlTableColumn.SqlRegularColumn) {
                    column = this.toUnresolvedPhysicalColumn((SqlTableColumn.SqlRegularColumn)derivedColumn);
                } else if (derivedColumn instanceof SqlTableColumn.SqlComputedColumn) {
                    SqlTableColumn.SqlComputedColumn computedColumn = (SqlTableColumn.SqlComputedColumn)derivedColumn;
                    if (this.physicalFieldNamesToTypes.containsKey(name)) {
                        throw new ValidationException(String.format("A column named '%s' already exists in the table. Duplicate columns exist in the compute column and regular column. ", name));
                    }
                    if (this.columns.containsKey(name)) {
                        if (!(this.columns.get(name) instanceof Schema.UnresolvedComputedColumn)) {
                            throw new ValidationException(String.format("A column named '%s' already exists in the base table. Computed columns can only overwrite other computed columns.", name));
                        }
                        if (mergingStrategies.get((Object)SqlTableLike.FeatureOption.GENERATED) != SqlTableLike.MergingStrategy.OVERWRITING) {
                            throw new ValidationException(String.format("A generated column named '%s' already exists in the base table. You might want to specify EXCLUDING GENERATED or OVERWRITING GENERATED.", name));
                        }
                    }
                    HashMap<String, RelDataType> accessibleFieldNamesToTypes = new HashMap<String, RelDataType>();
                    accessibleFieldNamesToTypes.putAll(this.physicalFieldNamesToTypes);
                    accessibleFieldNamesToTypes.putAll(this.metadataFieldNamesToTypes);
                    SqlNode validatedExpr = this.sqlValidator.validateParameterizedExpression(computedColumn.getExpr(), accessibleFieldNamesToTypes);
                    RelDataType validatedType = this.sqlValidator.getValidatedNodeType(validatedExpr);
                    column = this.toUnresolvedComputedColumn((SqlTableColumn.SqlComputedColumn)derivedColumn, validatedExpr);
                    this.computedFieldNamesToTypes.put(name, validatedType);
                } else if (derivedColumn instanceof SqlTableColumn.SqlMetadataColumn) {
                    SqlTableColumn.SqlMetadataColumn metadataColumn = (SqlTableColumn.SqlMetadataColumn)derivedColumn;
                    if (this.physicalFieldNamesToTypes.containsKey(name)) {
                        throw new ValidationException(String.format("A column named '%s' already exists in the table. Duplicate columns exist in the metadata column and regular column. ", name));
                    }
                    if (this.columns.containsKey(name)) {
                        if (!(this.columns.get(name) instanceof Schema.UnresolvedMetadataColumn)) {
                            throw new ValidationException(String.format("A column named '%s' already exists in the base table. Metadata columns can only overwrite other metadata columns.", name));
                        }
                        if (mergingStrategies.get((Object)SqlTableLike.FeatureOption.METADATA) != SqlTableLike.MergingStrategy.OVERWRITING) {
                            throw new ValidationException(String.format("A metadata column named '%s' already exists in the base table. You might want to specify EXCLUDING METADATA or OVERWRITING METADATA.", name));
                        }
                    }
                    RelDataType relType = this.toRelDataType(metadataColumn.getType());
                    column = this.toUnresolvedMetadataColumn((SqlTableColumn.SqlMetadataColumn)derivedColumn);
                    this.metadataFieldNamesToTypes.put(name, relType);
                } else {
                    throw new ValidationException("Unsupported column type: " + derivedColumn);
                }
                this.columns.put(column.getName(), column);
            }
        }

        private void collectPhysicalFieldsTypes(List<SqlNode> derivedColumns) {
            for (SqlNode derivedColumn : derivedColumns) {
                if (!(derivedColumn instanceof SqlTableColumn.SqlRegularColumn)) continue;
                SqlTableColumn.SqlRegularColumn regularColumn = (SqlTableColumn.SqlRegularColumn)derivedColumn;
                String name = regularColumn.getName().getSimple();
                if (this.columns.containsKey(name)) {
                    throw new ValidationException(String.format("A column named '%s' already exists in the base table.", name));
                }
                RelDataType relType = this.toRelDataType(regularColumn.getType());
                RelDataType oldType = this.physicalFieldNamesToTypes.put(name, relType);
                if (oldType == null) continue;
                throw new ValidationException(String.format("A regular Column named '%s' already exists in the table.", name));
            }
        }
    }
}

