/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.hint;

import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import org.apache.calcite.rel.hint.HintOptionChecker;
import org.apache.calcite.rel.hint.HintPredicates;
import org.apache.calcite.rel.hint.HintStrategy;
import org.apache.calcite.rel.hint.HintStrategyTable;
import org.apache.calcite.util.Litmus;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.guava32.com.google.common.collect.ImmutableSet;
import org.apache.flink.table.api.config.LookupJoinHintOptions;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.planner.hint.FlinkHints;
import org.apache.flink.table.planner.hint.JoinStrategy;
import org.apache.flink.table.planner.hint.StateTtlHint;
import org.apache.flink.table.planner.plan.rules.logical.WrapJsonAggFunctionArgumentsRule;
import org.apache.flink.util.TimeUtils;

public abstract class FlinkHintStrategies {
    private static final HintOptionChecker NON_EMPTY_LIST_OPTION_CHECKER = (hint, errorHandler) -> errorHandler.check(hint.listOptions.size() > 0, "Invalid hint: {}, expecting at least one table or view specified in hint {}.", FlinkHints.stringifyHints(Collections.singletonList(hint)), hint.hintName);
    private static final HintOptionChecker OPTIONS_KV_OPTION_CHECKER = (hint, errorHandler) -> {
        errorHandler.check(hint.kvOptions.size() > 0, "Hint [{}] only support non empty key value options", hint.hintName);
        Configuration conf = Configuration.fromMap(hint.kvOptions);
        Optional errMsgOptional = FactoryUtil.checkWatermarkOptions((ReadableConfig)conf);
        errorHandler.check(!errMsgOptional.isPresent(), errMsgOptional.orElse("No errors."), new Object[0]);
        return true;
    };
    private static final HintOptionChecker LOOKUP_NON_EMPTY_KV_OPTION_CHECKER = (lookupHint, litmus) -> {
        litmus.check(lookupHint.listOptions.size() == 0, "Invalid list options in LOOKUP hint, only support key-value options.", new Object[0]);
        Configuration conf = Configuration.fromMap(lookupHint.kvOptions);
        ImmutableSet requiredKeys = LookupJoinHintOptions.getRequiredOptions();
        litmus.check(requiredKeys.stream().allMatch(arg_0 -> ((Configuration)conf).contains(arg_0)), "Invalid LOOKUP hint: incomplete required option(s): {}", requiredKeys);
        ImmutableSet supportedKeys = LookupJoinHintOptions.getSupportedOptions();
        litmus.check(lookupHint.kvOptions.size() <= supportedKeys.size(), "Too many LOOKUP hint options {} beyond max number of supported options {}", lookupHint.kvOptions.size(), supportedKeys.size());
        try {
            supportedKeys.forEach(arg_0 -> ((Configuration)conf).get(arg_0));
        }
        catch (IllegalArgumentException e) {
            litmus.fail("Invalid LOOKUP hint options: {}", e.getMessage());
        }
        Boolean async = (Boolean)conf.get(LookupJoinHintOptions.ASYNC_LOOKUP);
        if (Boolean.TRUE.equals(async)) {
            Integer capacity = (Integer)conf.get(LookupJoinHintOptions.ASYNC_CAPACITY);
            litmus.check(null == capacity || capacity > 0, "Invalid LOOKUP hint option: {} value should be positive integer but was {}", LookupJoinHintOptions.ASYNC_CAPACITY.key(), capacity);
        }
        String retryPredicate = (String)conf.get(LookupJoinHintOptions.RETRY_PREDICATE);
        LookupJoinHintOptions.RetryStrategy retryStrategy = (LookupJoinHintOptions.RetryStrategy)conf.get(LookupJoinHintOptions.RETRY_STRATEGY);
        Duration fixedDelay = (Duration)conf.get(LookupJoinHintOptions.FIXED_DELAY);
        Integer maxAttempts = (Integer)conf.get(LookupJoinHintOptions.MAX_ATTEMPTS);
        litmus.check(null == retryPredicate && null == retryStrategy && null == fixedDelay && null == fixedDelay && null == maxAttempts || null != retryPredicate && null != retryStrategy && null != fixedDelay && null != fixedDelay && null != maxAttempts, "Invalid LOOKUP hint: retry options can be both null or all not null", new Object[0]);
        if (null != retryPredicate) {
            litmus.check("lookup_miss".equalsIgnoreCase(retryPredicate), "Invalid LOOKUP hint option: unsupported {} '{}', only '{}' is supported currently", LookupJoinHintOptions.RETRY_PREDICATE.key(), retryPredicate, "lookup_miss");
            litmus.check(maxAttempts > 0, "Invalid LOOKUP hint option: {} value should be positive integer but was {}", LookupJoinHintOptions.MAX_ATTEMPTS.key(), maxAttempts);
        }
        return true;
    };
    private static final HintOptionChecker STATE_TTL_NON_EMPTY_KV_OPTION_CHECKER = (ttlHint, litmus) -> {
        litmus.check(ttlHint.listOptions.size() == 0, "Invalid list options in STATE_TTL hint, only support key-value options.", new Object[0]);
        litmus.check(ttlHint.kvOptions.size() > 0, "Invalid STATE_TTL hint, expecting at least one key-value options specified.", new Object[0]);
        ttlHint.kvOptions.values().forEach(value -> {
            try {
                TimeUtils.parseDuration((String)value);
            }
            catch (IllegalArgumentException e) {
                litmus.fail("Invalid STATE_TTL hint value: {}", e.getMessage());
            }
        });
        return true;
    };

    public static HintStrategyTable createHintStrategyTable() {
        return HintStrategyTable.builder().errorHandler(Litmus.THROW).hintStrategy("OPTIONS", HintStrategy.builder(HintPredicates.TABLE_SCAN).optionChecker(OPTIONS_KV_OPTION_CHECKER).build()).hintStrategy("JSON_AGGREGATE_WRAPPED", HintStrategy.builder(HintPredicates.AGGREGATE).excludedRules(WrapJsonAggFunctionArgumentsRule.INSTANCE).build()).hintStrategy("ALIAS", HintStrategy.builder(HintPredicates.or(HintPredicates.CORRELATE, HintPredicates.JOIN)).optionChecker(FlinkHintStrategies.fixedSizeListOptionChecker(1)).build()).hintStrategy(JoinStrategy.BROADCAST.getJoinHintName(), HintStrategy.builder(HintPredicates.JOIN).optionChecker(NON_EMPTY_LIST_OPTION_CHECKER).build()).hintStrategy(JoinStrategy.SHUFFLE_HASH.getJoinHintName(), HintStrategy.builder(HintPredicates.JOIN).optionChecker(NON_EMPTY_LIST_OPTION_CHECKER).build()).hintStrategy(JoinStrategy.SHUFFLE_MERGE.getJoinHintName(), HintStrategy.builder(HintPredicates.JOIN).optionChecker(NON_EMPTY_LIST_OPTION_CHECKER).build()).hintStrategy(JoinStrategy.NEST_LOOP.getJoinHintName(), HintStrategy.builder(HintPredicates.JOIN).optionChecker(NON_EMPTY_LIST_OPTION_CHECKER).build()).hintStrategy(JoinStrategy.LOOKUP.getJoinHintName(), HintStrategy.builder(HintPredicates.or(HintPredicates.CORRELATE, HintPredicates.JOIN)).optionChecker(LOOKUP_NON_EMPTY_KV_OPTION_CHECKER).build()).hintStrategy(StateTtlHint.STATE_TTL.getHintName(), HintStrategy.builder(HintPredicates.or(HintPredicates.JOIN, HintPredicates.AGGREGATE)).optionChecker(STATE_TTL_NON_EMPTY_KV_OPTION_CHECKER).build()).build();
    }

    private static HintOptionChecker fixedSizeListOptionChecker(int size) {
        return (hint, errorHandler) -> errorHandler.check(hint.listOptions.size() == size, "Invalid hint: {}, expecting {} table or view {} specified in hint {}.", FlinkHints.stringifyHints(Collections.singletonList(hint)), size, size > 1 ? "names" : "name", hint.hintName);
    }
}

