/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rex.RexProgram;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCalc;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalAsyncCalc;
import org.apache.flink.table.planner.plan.utils.AsyncUtil;

public class StreamPhysicalAsyncCalcRule
extends ConverterRule {
    public static final RelOptRule INSTANCE = new StreamPhysicalAsyncCalcRule(ConverterRule.Config.INSTANCE.withConversion(FlinkLogicalCalc.class, FlinkConventions.LOGICAL(), FlinkConventions.STREAM_PHYSICAL(), "StreamPhysicalAsyncCalcRule"));

    protected StreamPhysicalAsyncCalcRule(ConverterRule.Config config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalCalc calc = (FlinkLogicalCalc)call.rel(0);
        RexProgram program = calc.getProgram();
        return program.getExprList().stream().anyMatch(AsyncUtil::containsAsyncCall);
    }

    @Override
    public @Nullable RelNode convert(RelNode rel) {
        FlinkLogicalCalc calc = (FlinkLogicalCalc)rel;
        RelTraitSet traitSet = rel.getTraitSet().replace(FlinkConventions.STREAM_PHYSICAL());
        RelNode newInput = RelOptRule.convert(calc.getInput(), FlinkConventions.STREAM_PHYSICAL());
        return new StreamPhysicalAsyncCalc(rel.getCluster(), traitSet, newInput, calc.getProgram(), rel.getRowType());
    }
}

