/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.rex.RexInputRef;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionDefaultVisitor;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.LocalReferenceExpression;
import org.apache.flink.table.planner.expressions.RexNodeExpression;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil;

public class ColumnReferenceFinder {
    private ColumnReferenceFinder() {
    }

    public static Set<String> findReferencedColumn(String columnName, ResolvedSchema schema) {
        Column column = (Column)schema.getColumn(columnName).orElseThrow(() -> new ValidationException(String.format("The input column %s doesn't exist in the schema.", columnName)));
        if (!(column instanceof Column.ComputedColumn)) {
            return Collections.emptySet();
        }
        ColumnReferenceVisitor visitor = new ColumnReferenceVisitor(schema.getColumns().stream().filter(c -> !(c instanceof Column.ComputedColumn)).map(Column::getName).collect(Collectors.toList()));
        return visitor.visit((Expression)((Column.ComputedColumn)column).getExpression());
    }

    public static Set<String> findWatermarkReferencedColumn(ResolvedSchema schema) {
        ColumnReferenceVisitor visitor = new ColumnReferenceVisitor(schema.getColumnNames());
        return schema.getWatermarkSpecs().stream().flatMap(spec -> Stream.concat(visitor.visit((Expression)spec.getWatermarkExpression()).stream(), Stream.of(spec.getRowtimeAttribute()))).collect(Collectors.toSet());
    }

    private static class ColumnReferenceVisitor
    extends ExpressionDefaultVisitor<Set<String>> {
        private final List<String> tableColumns;

        public ColumnReferenceVisitor(List<String> tableColumns) {
            this.tableColumns = tableColumns;
        }

        public Set<String> visit(Expression expression) {
            if (expression instanceof LocalReferenceExpression) {
                return this.visit((LocalReferenceExpression)expression);
            }
            if (expression instanceof FieldReferenceExpression) {
                return this.visit((FieldReferenceExpression)expression);
            }
            if (expression instanceof RexNodeExpression) {
                return this.visit((RexNodeExpression)expression);
            }
            if (expression instanceof CallExpression) {
                return this.visit((CallExpression)expression);
            }
            return (Set)super.visit(expression);
        }

        public Set<String> visit(FieldReferenceExpression fieldReference) {
            return Collections.singleton(fieldReference.getName());
        }

        public Set<String> visit(LocalReferenceExpression localReference) {
            return Collections.singleton(localReference.getName());
        }

        public Set<String> visit(RexNodeExpression rexNode) {
            HashSet<RexInputRef> inputRefs = FlinkRexUtil.findAllInputRefs(rexNode.getRexNode());
            return inputRefs.stream().map(inputRef -> this.tableColumns.get(inputRef.getIndex())).collect(Collectors.toSet());
        }

        public Set<String> visit(CallExpression call) {
            HashSet<String> references = new HashSet<String>();
            for (Expression expression : call.getChildren()) {
                references.addAll((Collection<String>)this.visit(expression));
            }
            return references;
        }

        protected Set<String> defaultMethod(Expression expression) {
            throw new TableException("Unexpected expression: " + expression);
        }
    }
}

