/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen.agg.batch;

import java.io.Serializable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.codegen.OperatorCodeGenerator$;
import org.apache.flink.table.planner.codegen.ProjectionCodeGenerator$;
import org.apache.flink.table.planner.codegen.agg.batch.AggCodeGenHelper$;
import org.apache.flink.table.planner.codegen.agg.batch.HashAggCodeGenHelper$;
import org.apache.flink.table.planner.plan.utils.AggregateInfo;
import org.apache.flink.table.planner.plan.utils.AggregateInfoList;
import org.apache.flink.table.planner.typeutils.RowTypeUtils;
import org.apache.flink.table.runtime.generated.GeneratedOperator;
import org.apache.flink.table.runtime.operators.TableStreamOperator;
import org.apache.flink.table.runtime.operators.aggregate.BytesHashMapSpillMemorySegmentPool;
import org.apache.flink.table.runtime.util.collections.binary.BytesMap;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class HashAggCodeGenerator$ {
    public static HashAggCodeGenerator$ MODULE$;
    @Deprecated
    @Experimental
    private final ConfigOption<Boolean> TABLE_EXEC_LOCAL_HASH_AGG_ADAPTIVE_ENABLED;
    @Deprecated
    @Experimental
    private final ConfigOption<Long> TABLE_EXEC_LOCAL_HASH_AGG_ADAPTIVE_SAMPLING_THRESHOLD;
    @Deprecated
    @Experimental
    private final ConfigOption<Double> TABLE_EXEC_LOCAL_HASH_AGG_ADAPTIVE_DISTINCT_VALUE_RATE_THRESHOLD;

    static {
        new HashAggCodeGenerator$();
    }

    public ConfigOption<Boolean> TABLE_EXEC_LOCAL_HASH_AGG_ADAPTIVE_ENABLED() {
        return this.TABLE_EXEC_LOCAL_HASH_AGG_ADAPTIVE_ENABLED;
    }

    public ConfigOption<Long> TABLE_EXEC_LOCAL_HASH_AGG_ADAPTIVE_SAMPLING_THRESHOLD() {
        return this.TABLE_EXEC_LOCAL_HASH_AGG_ADAPTIVE_SAMPLING_THRESHOLD;
    }

    public ConfigOption<Double> TABLE_EXEC_LOCAL_HASH_AGG_ADAPTIVE_DISTINCT_VALUE_RATE_THRESHOLD() {
        return this.TABLE_EXEC_LOCAL_HASH_AGG_ADAPTIVE_DISTINCT_VALUE_RATE_THRESHOLD;
    }

    public GeneratedOperator<OneInputStreamOperator<RowData, RowData>> genWithKeys(CodeGeneratorContext ctx, RelBuilder builder, AggregateInfoList aggInfoList, RowType inputType, RowType outputType, int[] grouping, int[] auxGrouping, boolean isMerge, boolean isFinal, boolean supportAdaptiveLocalHashAgg, int maxNumFileHandles, boolean compressionEnabled, int compressionBlockSize) {
        String string;
        Tuple5 tuple5;
        Tuple5 tuple52;
        String valueProjectionCode;
        AggregateInfo[] aggInfos = aggInfoList.aggInfos();
        Map<AggregateFunction<?, ?>, String> functionIdentifiers = AggCodeGenHelper$.MODULE$.getFunctionIdentifiers((Seq<AggregateInfo>)Predef$.MODULE$.wrapRefArray((Object[])aggInfos));
        String aggBufferPrefix = "hash";
        String[][] aggBufferNames = AggCodeGenHelper$.MODULE$.getAggBufferNames(aggBufferPrefix, auxGrouping, (Seq<AggregateInfo>)Predef$.MODULE$.wrapRefArray((Object[])aggInfos));
        LogicalType[][] aggBufferTypes = AggCodeGenHelper$.MODULE$.getAggBufferTypes(inputType, auxGrouping, (Seq<AggregateInfo>)Predef$.MODULE$.wrapRefArray((Object[])aggInfos));
        RowType groupKeyRowType = RowTypeUtils.projectRowType(inputType, grouping);
        RowType aggBufferRowType = RowType.of((LogicalType[])((LogicalType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggBufferTypes)).flatten((Function1 & Serializable & scala.Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(LogicalType.class))), (String[])((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggBufferNames)).flatten((Function1 & Serializable & scala.Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(String.class))));
        String inputTerm = CodeGenUtils$.MODULE$.DEFAULT_INPUT1_TERM();
        String className = isFinal ? "HashAggregateWithKeys" : "LocalHashAggregateWithKeys";
        String logTerm = CodeGenUtils$.MODULE$.newName(ctx, "LOG");
        ctx.addReusableLogger(logTerm, className);
        String currentKeyTerm = CodeGenUtils$.MODULE$.newName(ctx, "currentKey");
        String currentKeyWriterTerm = CodeGenUtils$.MODULE$.newName(ctx, "currentKeyWriter");
        String currentValueTerm = CodeGenUtils$.MODULE$.newName(ctx, "currentValue");
        String currentValueWriterTerm = CodeGenUtils$.MODULE$.newName(ctx, "currentValueWriter");
        CodeGeneratorContext x$5 = ctx;
        RowType x$6 = inputType;
        RowType x$7 = groupKeyRowType;
        int[] x$8 = grouping;
        String x$9 = inputTerm;
        String x$10 = currentKeyTerm;
        String x$11 = currentKeyWriterTerm;
        Class<? extends RowData> x$12 = ProjectionCodeGenerator$.MODULE$.generateProjectionExpression$default$5();
        boolean x$13 = ProjectionCodeGenerator$.MODULE$.generateProjectionExpression$default$9();
        String keyProjectionCode = ProjectionCodeGenerator$.MODULE$.generateProjectionExpression(x$5, x$6, x$7, x$8, x$12, x$9, x$10, x$11, x$13).code();
        String groupKeyTypesTerm = CodeGenUtils$.MODULE$.newName(ctx, "groupKeyTypes");
        String aggBufferTypesTerm = CodeGenUtils$.MODULE$.newName(ctx, "aggBufferTypes");
        HashAggCodeGenHelper$.MODULE$.prepareHashAggKVTypes(ctx, groupKeyTypesTerm, aggBufferTypesTerm, groupKeyRowType, aggBufferRowType);
        String binaryRowTypeTerm = BinaryRowData.class.getName();
        String aggregateMapTerm = CodeGenUtils$.MODULE$.newName(ctx, "aggregateMap");
        String lookupInfoTypeTerm = BytesMap.LookupInfo.class.getCanonicalName();
        String lookupInfo = ctx.addReusableLocalVariable(lookupInfoTypeTerm, "lookupInfo");
        HashAggCodeGenHelper$.MODULE$.prepareHashAggMap(ctx, groupKeyTypesTerm, aggBufferTypesTerm, aggregateMapTerm);
        String outputTerm = CodeGenUtils$.MODULE$.newName(ctx, "hashAggOutput");
        Tuple2<String, String> tuple2 = HashAggCodeGenHelper$.MODULE$.prepareTermForAggMapIteration(ctx, outputTerm, outputType, new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(grouping)).isEmpty() ? GenericRowData.class : JoinedRowData.class);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String reuseGroupKeyTerm = (String)tuple2._1();
        String reuseAggBufferTerm = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)reuseGroupKeyTerm, (Object)reuseAggBufferTerm);
        Tuple2 tuple23 = tuple22;
        String reuseGroupKeyTerm2 = (String)tuple23._1();
        String reuseAggBufferTerm2 = (String)tuple23._2();
        String currentAggBufferTerm = ctx.addReusableLocalVariable(binaryRowTypeTerm, "currentAggBuffer");
        Tuple3<GeneratedExpression, GeneratedExpression, GeneratedExpression> tuple3 = HashAggCodeGenHelper$.MODULE$.genHashAggCodes(isMerge, isFinal, ctx, builder, (Tuple2<int[], int[]>)new Tuple2((Object)grouping, (Object)auxGrouping), inputTerm, inputType, (Seq<AggregateInfo>)Predef$.MODULE$.wrapRefArray((Object[])aggInfos), currentAggBufferTerm, aggBufferRowType, aggBufferTypes, outputTerm, outputType, reuseGroupKeyTerm2, reuseAggBufferTerm2);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        GeneratedExpression initedAggBuffer = (GeneratedExpression)tuple3._1();
        GeneratedExpression aggregate = (GeneratedExpression)tuple3._2();
        GeneratedExpression outputExpr = (GeneratedExpression)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)initedAggBuffer, (Object)aggregate, (Object)outputExpr);
        Tuple3 tuple33 = tuple32;
        GeneratedExpression initedAggBuffer2 = (GeneratedExpression)tuple33._1();
        GeneratedExpression aggregate2 = (GeneratedExpression)tuple33._2();
        GeneratedExpression outputExpr2 = (GeneratedExpression)tuple33._3();
        String outputResultFromMap = HashAggCodeGenHelper$.MODULE$.genAggMapIterationAndOutput(ctx, isFinal, aggregateMapTerm, reuseGroupKeyTerm2, reuseAggBufferTerm2, outputExpr2);
        String sorterTerm = CodeGenUtils$.MODULE$.newName(ctx, "sorter");
        String retryAppend = HashAggCodeGenHelper$.MODULE$.genRetryAppendToMap(aggregateMapTerm, currentKeyTerm, initedAggBuffer2, lookupInfo, currentAggBufferTerm);
        Tuple2<String, String> tuple24 = HashAggCodeGenHelper$.MODULE$.genAggMapOOMHandling(isFinal, ctx, builder, (Tuple2<int[], int[]>)new Tuple2((Object)grouping, (Object)auxGrouping), (Seq<AggregateInfo>)Predef$.MODULE$.wrapRefArray((Object[])aggInfos), functionIdentifiers, logTerm, aggregateMapTerm, (Tuple2<String, String>)new Tuple2((Object)groupKeyTypesTerm, (Object)aggBufferTypesTerm), (Tuple2<RowType, RowType>)new Tuple2((Object)groupKeyRowType, (Object)aggBufferRowType), aggBufferPrefix, aggBufferNames, aggBufferTypes, outputTerm, outputType, outputResultFromMap, sorterTerm, retryAppend, maxNumFileHandles, compressionEnabled, compressionBlockSize);
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        String dealWithAggHashMapOOM = (String)tuple24._1();
        String fallbackToSortAggCode = (String)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)dealWithAggHashMapOOM, (Object)fallbackToSortAggCode);
        Tuple2 tuple26 = tuple25;
        String dealWithAggHashMapOOM2 = (String)tuple26._1();
        String fallbackToSortAggCode2 = (String)tuple26._2();
        HashAggCodeGenHelper$.MODULE$.prepareMetrics(ctx, aggregateMapTerm, isFinal ? sorterTerm : null);
        String inputUnboxingCode = String.valueOf(ctx.reuseInputUnboxingCode(reuseAggBufferTerm2));
        String outputResultForAdaptiveLocalHashAgg = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(140).append("\n         |   // set result and output\n         |   ").append(reuseGroupKeyTerm2).append(" =  (").append(CodeGenUtils$.MODULE$.ROW_DATA()).append(")").append(currentKeyTerm).append(";\n         |   ").append(reuseAggBufferTerm2).append(" = (").append(CodeGenUtils$.MODULE$.ROW_DATA()).append(")").append(currentValueTerm).append(";\n         |   ").append(inputUnboxingCode).append("\n         |   ").append(outputExpr2.code()).append("\n         |   ").append(OperatorCodeGenerator$.MODULE$.generateCollect(outputExpr2.resultTerm())).append("\n         |\n       ").toString())).stripMargin();
        String localAggSuppressedTerm = CodeGenUtils$.MODULE$.newName(ctx, "localAggSuppressed");
        ctx.addReusableMember(new StringBuilder(35).append("private transient boolean ").append(localAggSuppressedTerm).append(" = false;").toString());
        String string2 = valueProjectionCode = !isFinal && supportAdaptiveLocalHashAgg ? ProjectionCodeGenerator$.MODULE$.genAdaptiveLocalHashAggValueProjectionCode(ctx, inputType, BinaryRowData.class, inputTerm, aggInfos, auxGrouping, currentValueTerm, currentValueWriterTerm) : "";
        if (!isFinal && Predef$.MODULE$.Boolean2boolean((Boolean)ctx.tableConfig().get(ExecutionConfigOptions.TABLE_EXEC_LOCAL_HASH_AGG_ADAPTIVE_ENABLED)) && supportAdaptiveLocalHashAgg) {
            String adaptiveDistinctCountTerm = CodeGenUtils$.MODULE$.newName(ctx, "distinctCount");
            String adaptiveTotalCountTerm = CodeGenUtils$.MODULE$.newName(ctx, "totalCount");
            ctx.addReusableMember(new StringBuilder(28).append("private transient long ").append(adaptiveDistinctCountTerm).append(" = 0;").toString());
            ctx.addReusableMember(new StringBuilder(28).append("private transient long ").append(adaptiveTotalCountTerm).append(" = 0;").toString());
            Long samplingThreshold = (Long)ctx.tableConfig().get(ExecutionConfigOptions.TABLE_EXEC_LOCAL_HASH_AGG_ADAPTIVE_SAMPLING_THRESHOLD);
            Double distinctValueRateThreshold = (Double)ctx.tableConfig().get(ExecutionConfigOptions.TABLE_EXEC_LOCAL_HASH_AGG_ADAPTIVE_DISTINCT_VALUE_RATE_THRESHOLD);
            tuple52 = new Tuple5((Object)new StringBuilder(3).append(adaptiveDistinctCountTerm).append("++;").toString(), (Object)new StringBuilder(3).append(adaptiveTotalCountTerm).append("++;").toString(), (Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(447).append("\n             |if (").append(adaptiveTotalCountTerm).append(" == ").append(samplingThreshold).append(") {\n             |  ").append(logTerm).append(".info(\"Local hash aggregation checkpoint reached, sampling threshold = \" +\n             |    ").append(samplingThreshold).append(" + \", distinct value count = \" + ").append(adaptiveDistinctCountTerm).append(" + \", total = \" +\n             |    ").append(adaptiveTotalCountTerm).append(" + \", distinct value rate threshold = \" \n             |    + ").append(distinctValueRateThreshold).append(");\n             |  if (").append(adaptiveDistinctCountTerm).append(" / (1.0 * ").append(adaptiveTotalCountTerm).append(") > ").append(distinctValueRateThreshold).append(") {\n             |    ").append(logTerm).append(".info(\"Local hash aggregation is suppressed\");\n             |    ").append(localAggSuppressedTerm).append(" = true;\n             |  }\n             |}\n             |").toString())).stripMargin(), (Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(111).append("\n             |if (").append(localAggSuppressedTerm).append(") {\n             |  ").append(valueProjectionCode).append("\n             |  ").append(outputResultForAdaptiveLocalHashAgg).append("\n             |  return;\n             |}\n             |").toString())).stripMargin(), (Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(94).append("\n             |if (").append(localAggSuppressedTerm).append(") {\n             |  ").append(outputResultFromMap).append("\n             |  return;\n             |}\n             |").toString())).stripMargin());
        } else {
            tuple52 = tuple5 = new Tuple5((Object)"", (Object)"", (Object)"", (Object)"", (Object)"");
        }
        if (tuple5 == null) {
            throw new MatchError((Object)tuple5);
        }
        String distinctCountIncCode = (String)tuple5._1();
        String totalCountIncCode = (String)tuple5._2();
        String adaptiveSamplingCode = (String)tuple5._3();
        String adaptiveLocalHashAggCode = (String)tuple5._4();
        String flushResultSuppressEnableCode = (String)tuple5._5();
        Tuple5 tuple53 = new Tuple5((Object)distinctCountIncCode, (Object)totalCountIncCode, (Object)adaptiveSamplingCode, (Object)adaptiveLocalHashAggCode, (Object)flushResultSuppressEnableCode);
        Tuple5 tuple54 = tuple53;
        String distinctCountIncCode2 = (String)tuple54._1();
        String totalCountIncCode2 = (String)tuple54._2();
        String adaptiveSamplingCode2 = (String)tuple54._3();
        String adaptiveLocalHashAggCode2 = (String)tuple54._4();
        String flushResultSuppressEnableCode2 = (String)tuple54._5();
        String lazyInitAggBufferCode = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(auxGrouping)).nonEmpty() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(72).append("\n         |// lazy init agg buffer (with auxGrouping)\n         |").append(initedAggBuffer2.code()).append("\n       ").toString())).stripMargin() : "";
        String processCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(836).append("\n         | // input field access for group key projection and aggregate buffer update\n         |").append(ctx.reuseInputUnboxingCode(inputTerm)).append("\n         | // project key from input\n         |").append(keyProjectionCode).append("\n         |\n         |").append(adaptiveLocalHashAggCode2).append("\n         |\n         | // look up output buffer using current group key\n         |").append(lookupInfo).append(" = (").append(lookupInfoTypeTerm).append(") ").append(aggregateMapTerm).append(".lookup(").append(currentKeyTerm).append(");\n         |").append(currentAggBufferTerm).append(" = (").append(binaryRowTypeTerm).append(") ").append(lookupInfo).append(".getValue();\n         |\n         |if (!").append(lookupInfo).append(".isFound()) {\n         |  ").append(distinctCountIncCode2).append("\n         |  ").append(lazyInitAggBufferCode).append("\n         |  // append empty agg buffer into aggregate map for current group key\n         |  try {\n         |    ").append(currentAggBufferTerm).append(" =\n         |      ").append(aggregateMapTerm).append(".append(").append(lookupInfo).append(", ").append(initedAggBuffer2.resultTerm()).append(");\n         |  } catch (java.io.EOFException exp) {\n         |    ").append(dealWithAggHashMapOOM2).append("\n         |  }\n         |}\n         |\n         |").append(totalCountIncCode2).append("\n         |").append(adaptiveSamplingCode2).append("\n         |\n         | // aggregate buffer fields access\n         |").append(ctx.reuseInputUnboxingCode(currentAggBufferTerm)).append("\n         | // do aggregate and update agg buffer\n         |").append(aggregate2.code()).append("\n         | // flush result form map if suppress is enable. \n         |").append(flushResultSuppressEnableCode2).append("\n         |").toString())).stripMargin().trim();
        if (isFinal) {
            String memPoolTypeTerm = BytesHashMapSpillMemorySegmentPool.class.getName();
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(512).append("\n         |if (").append(sorterTerm).append(" == null) {\n         | // no spilling, output by iterating aggregate map.\n         | ").append(outputResultFromMap).append("\n         |} else {\n         |  // spill last part of input' aggregation output buffer\n         |  ").append(sorterTerm).append(".sortAndSpill(\n         |    ").append(aggregateMapTerm).append(".getRecordAreaMemorySegments(),\n         |    ").append(aggregateMapTerm).append(".getNumElements(),\n         |    new ").append(memPoolTypeTerm).append("(").append(aggregateMapTerm).append(".getBucketAreaMemorySegments()));\n         |   // only release floating memory in advance.\n         |   ").append(aggregateMapTerm).append(".free(true);\n         |  // fall back to sort based aggregation\n         |  ").append(fallbackToSortAggCode2).append("\n         |}\n       ").toString())).stripMargin();
        } else {
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(54).append("\n         |if (!").append(localAggSuppressedTerm).append(") {\n         | ").append(outputResultFromMap).append("\n         |}\n         |").toString())).stripMargin();
        }
        String endInputCode = string;
        return AggCodeGenHelper$.MODULE$.generateOperator(ctx, className, TableStreamOperator.class.getCanonicalName(), processCode, endInputCode, inputType);
    }

    private HashAggCodeGenerator$() {
        MODULE$ = this;
        this.TABLE_EXEC_LOCAL_HASH_AGG_ADAPTIVE_ENABLED = ConfigOptions.key((String)"table.exec.local-hash-agg.adaptive.enabled").booleanType().defaultValue((Object)BoxesRunTime.boxToBoolean((boolean)true)).withDescription(new StringOps(Predef$.MODULE$.augmentString("\n           |Whether to enable adaptive local hash aggregation. Adaptive local hash\n           |aggregation is an optimization of local hash aggregation, which can adaptively \n           |determine whether to continue to do local hash aggregation according to the distinct\n           | value rate of sampling data. If distinct value rate bigger than defined threshold\n           |(see parameter: table.exec.local-hash-agg.adaptive.distinct-value-rate-threshold), \n           |we will stop aggregating and just send the input data to the downstream after a simple \n           |projection. Otherwise, we will continue to do aggregation. Adaptive local hash aggregation\n           |only works in batch mode. Default value of this parameter is true.\n           |")).stripMargin());
        this.TABLE_EXEC_LOCAL_HASH_AGG_ADAPTIVE_SAMPLING_THRESHOLD = ConfigOptions.key((String)"table.exec.local-hash-agg.adaptive.sampling-threshold").longType().defaultValue((Object)BoxesRunTime.boxToLong((long)500000L)).withDescription(new StringOps(Predef$.MODULE$.augmentString("\n           |If adaptive local hash aggregation is enabled, this value defines how \n           |many records will be used as sampled data to calculate distinct value rate \n           |(see parameter: table.exec.local-hash-agg.adaptive.distinct-value-rate-threshold) \n           |for the local aggregate. The higher the sampling threshold, the more accurate \n           |the distinct value rate is. But as the sampling threshold increases, local \n           |aggregation is meaningless when the distinct values rate is low. \n           |The default value is 500000.\n           |")).stripMargin());
        this.TABLE_EXEC_LOCAL_HASH_AGG_ADAPTIVE_DISTINCT_VALUE_RATE_THRESHOLD = ConfigOptions.key((String)"table.exec.local-hash-agg.adaptive.distinct-value-rate-threshold").doubleType().defaultValue((Object)Predef$.MODULE$.double2Double(0.5)).withDescription(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(530).append("\n           |The distinct value rate can be defined as the number of local \n           |aggregation result for the sampled data divided by the sampling \n           |threshold (see ").append(this.TABLE_EXEC_LOCAL_HASH_AGG_ADAPTIVE_SAMPLING_THRESHOLD().key()).append("). \n           |If the computed result is lower than the given configuration value, \n           |the remaining input records proceed to do local aggregation, otherwise \n           |the remaining input records are subjected to simple projection which \n           |calculation cost is less than local aggregation. The default value is 0.5.\n           |").toString())).stripMargin());
    }
}

