/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import java.io.IOException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.linq4j.function.Deterministic;
import org.apache.calcite.linq4j.function.Strict;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.io.geojson.GeoJsonReader;
import org.locationtech.jts.io.geojson.GeoJsonWriter;
import org.locationtech.jts.io.gml2.GMLReader;
import org.locationtech.jts.io.gml2.GMLWriter;
import org.xml.sax.SAXException;

@Deterministic
@Strict
public class SpatialTypeUtils {
    static final int NO_SRID = 0;
    public static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();

    private SpatialTypeUtils() {
    }

    private static int dimension(Geometry geometry) {
        int dimension = 3;
        for (Coordinate coordinate : geometry.getCoordinates()) {
            if (!Double.isNaN(coordinate.getZ())) continue;
            dimension = 2;
            break;
        }
        return dimension;
    }

    public static Geometry fromGeoJson(String geoJson) {
        try {
            GeoJsonReader reader = new GeoJsonReader();
            return reader.read(geoJson);
        }
        catch (ParseException e) {
            throw new RuntimeException("Unable to parse GeoJSON");
        }
    }

    public static Geometry fromGml(String gml) {
        try {
            GMLReader reader = new GMLReader();
            return reader.read(gml, GEOMETRY_FACTORY);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException("Unable to parse GML");
        }
    }

    public static Geometry fromWkb(ByteString wkb) {
        try {
            WKBReader reader = new WKBReader();
            return reader.read(wkb.getBytes());
        }
        catch (ParseException e) {
            throw new RuntimeException("Unable to parse WKB");
        }
    }

    public static Geometry fromEwkt(String ewkt) {
        Pattern pattern = Pattern.compile("^(?:srid:(\\d*);)?(.*)$");
        Matcher matcher = pattern.matcher(ewkt);
        if (!matcher.matches()) {
            throw new RuntimeException("Unable to parse EWKT");
        }
        String wkt = matcher.group(2);
        if (wkt == null) {
            throw new RuntimeException("Unable to parse EWKT");
        }
        Geometry geometry = SpatialTypeUtils.fromWkt(wkt);
        String srid = matcher.group(1);
        if (srid != null) {
            geometry.setSRID(Integer.parseInt(srid));
        }
        return geometry;
    }

    public static Geometry fromWkt(String wkt) {
        try {
            WKTReader reader = new WKTReader();
            return reader.read(wkt);
        }
        catch (ParseException e) {
            throw new RuntimeException("Unable to parse WKT");
        }
    }

    public static String asGeoJson(Geometry geometry) {
        GeoJsonWriter geoJsonWriter = new GeoJsonWriter();
        return geoJsonWriter.write(geometry);
    }

    public static String asGml(Geometry geometry) {
        GMLWriter gmlWriter = new GMLWriter();
        String minified = gmlWriter.write(geometry).replace("\n", "").replace("  ", "");
        return minified;
    }

    public static ByteString asWkb(Geometry geometry) {
        int outputDimension = SpatialTypeUtils.dimension(geometry);
        WKBWriter wkbWriter = new WKBWriter(outputDimension);
        return new ByteString(wkbWriter.write(geometry));
    }

    public static String asEwkt(Geometry geometry) {
        return String.format(Locale.ROOT, "srid:%s;%s", geometry.getSRID(), SpatialTypeUtils.asWkt(geometry));
    }

    public static String asWkt(Geometry geometry) {
        int outputDimension = SpatialTypeUtils.dimension(geometry);
        WKTWriter wktWriter = new WKTWriter(outputDimension);
        return wktWriter.write(geometry);
    }

    public static enum SpatialType {
        GEOMETRY(0),
        POINT(1),
        LINESTRING(2),
        POLYGON(3),
        MULTIPOINT(4),
        MULTILINESTRING(5),
        MULTIPOLYGON(6),
        GEOMETRYCOLLECTION(7);

        private final int code;

        private SpatialType(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }

        public static SpatialType fromGeometry(Geometry g2) {
            switch (g2.getGeometryType()) {
                case "Geometry": {
                    return GEOMETRY;
                }
                case "Point": {
                    return POINT;
                }
                case "LineString": {
                    return LINESTRING;
                }
                case "Polygon": {
                    return POLYGON;
                }
                case "MultiPoint": {
                    return MULTIPOINT;
                }
                case "MultiLineString": {
                    return MULTILINESTRING;
                }
                case "MultiPolygon": {
                    return MULTIPOLYGON;
                }
                case "GeometryCollection": {
                    return GEOMETRYCOLLECTION;
                }
            }
            throw new AssertionError(g2);
        }
    }
}

