/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.batch.runtimefilter;

import java.util.Arrays;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.runtimefilter.BatchExecRuntimeFilter;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalRel;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.types.logical.LogicalType;

public class BatchPhysicalRuntimeFilter
extends BiRel
implements BatchPhysicalRel {
    private final int[] probeIndices;
    private final double estimatedFilterRatio;

    public BatchPhysicalRuntimeFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, int[] probeIndices, double estimatedFilterRatio) {
        super(cluster, traitSet, left, right);
        this.probeIndices = probeIndices;
        this.estimatedFilterRatio = estimatedFilterRatio;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new BatchPhysicalRuntimeFilter(this.getCluster(), traitSet, inputs.get(0), inputs.get(1), this.probeIndices, this.estimatedFilterRatio);
    }

    @Override
    protected RelDataType deriveRowType() {
        return this.getRight().getRowType();
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        List<String> fieldNames = this.getInput(1).getRowType().getFieldNames();
        return super.explainTerms(pw).item("select", String.join((CharSequence)", ", (CharSequence[])Arrays.stream(this.probeIndices).mapToObj(fieldNames::get).toArray(String[]::new))).item("estimatedFilterRatio", this.estimatedFilterRatio);
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return Math.ceil(mq.getRowCount(this.getInput(1)) * (1.0 - this.estimatedFilterRatio));
    }

    @Override
    public ExecNode<?> translateToExecNode() {
        return new BatchExecRuntimeFilter((ReadableConfig)ShortcutUtils.unwrapTableConfig(this), this.getInputProperties(), (LogicalType)FlinkTypeFactory.toLogicalRowType(this.getRowType()), this.getRelDetailedDescription(), this.probeIndices);
    }

    private List<InputProperty> getInputProperties() {
        InputProperty buildEdge = InputProperty.builder().requiredDistribution(InputProperty.BROADCAST_DISTRIBUTION).damBehavior(InputProperty.DamBehavior.BLOCKING).priority(0).build();
        InputProperty probeEdge = InputProperty.builder().requiredDistribution(InputProperty.ANY_DISTRIBUTION).damBehavior(InputProperty.DamBehavior.PIPELINED).priority(1).build();
        return Arrays.asList(buildEdge, probeEdge);
    }
}

