/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DatabindContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ResolvedCatalogTableJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;

@Internal
final class ContextResolvedTableJsonSerializer
extends StdSerializer<ContextResolvedTable> {
    private static final long serialVersionUID = 1L;
    static final String FIELD_NAME_IDENTIFIER = "identifier";
    static final String FIELD_NAME_CATALOG_TABLE = "resolvedTable";

    ContextResolvedTableJsonSerializer() {
        super(ContextResolvedTable.class);
    }

    public void serialize(ContextResolvedTable contextResolvedTable, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        TableConfigOptions.CatalogPlanCompilation planCompilationOption = (TableConfigOptions.CatalogPlanCompilation)SerdeContext.get((DatabindContext)serializerProvider).getConfiguration().get(TableConfigOptions.PLAN_COMPILE_CATALOG_OBJECTS);
        jsonGenerator.writeStartObject();
        if (contextResolvedTable.isAnonymous()) {
            jsonGenerator.writeFieldName(FIELD_NAME_CATALOG_TABLE);
            ResolvedCatalogTableJsonSerializer.serialize((ResolvedCatalogTable)contextResolvedTable.getResolvedTable(), true, jsonGenerator, serializerProvider);
        } else {
            jsonGenerator.writeObjectField(FIELD_NAME_IDENTIFIER, (Object)contextResolvedTable.getIdentifier());
            if (contextResolvedTable.isPermanent() && planCompilationOption != TableConfigOptions.CatalogPlanCompilation.IDENTIFIER) {
                jsonGenerator.writeFieldName(FIELD_NAME_CATALOG_TABLE);
                try {
                    ResolvedCatalogTableJsonSerializer.serialize((ResolvedCatalogTable)contextResolvedTable.getResolvedTable(), planCompilationOption == TableConfigOptions.CatalogPlanCompilation.ALL, jsonGenerator, serializerProvider);
                }
                catch (ValidationException e) {
                    throw new ValidationException(String.format("Error when trying to serialize table '%s'.", contextResolvedTable.getIdentifier()), (Throwable)e);
                }
            }
        }
        jsonGenerator.writeEndObject();
    }
}

