/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen;

import java.io.Serializable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.OperatorCodeGenerator$;
import org.apache.flink.table.planner.codegen.ProjectionCodeGenerator$;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.generated.GeneratedOperator;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.hashtable.LongHashPartition;
import org.apache.flink.table.runtime.hashtable.LongHybridHashTable;
import org.apache.flink.table.runtime.hashtable.ProbeIterator;
import org.apache.flink.table.runtime.operators.CodeGenOperatorFactory;
import org.apache.flink.table.runtime.operators.join.HashJoinType;
import org.apache.flink.table.runtime.operators.join.SortMergeJoinFunction;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.runtime.util.RowIterator;
import org.apache.flink.table.runtime.util.StreamRecordCollector;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public final class LongHashJoinGenerator$ {
    public static LongHashJoinGenerator$ MODULE$;

    static {
        new LongHashJoinGenerator$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean support(HashJoinType joinType, RowType keyType, boolean[] filterNulls) {
        boolean bl;
        HashJoinType hashJoinType = joinType;
        HashJoinType hashJoinType2 = HashJoinType.INNER;
        if (hashJoinType == null ? hashJoinType2 != null : !hashJoinType.equals(hashJoinType2)) {
            HashJoinType hashJoinType3 = joinType;
            HashJoinType hashJoinType4 = HashJoinType.SEMI;
            if (hashJoinType3 == null ? hashJoinType4 != null : !hashJoinType3.equals(hashJoinType4)) {
                HashJoinType hashJoinType5 = joinType;
                HashJoinType hashJoinType6 = HashJoinType.ANTI;
                if (hashJoinType5 == null ? hashJoinType6 != null : !hashJoinType5.equals(hashJoinType6)) {
                    HashJoinType hashJoinType7 = joinType;
                    HashJoinType hashJoinType8 = HashJoinType.PROBE_OUTER;
                    if (hashJoinType7 == null) {
                        if (hashJoinType8 != null) {
                            return false;
                        }
                    } else if (!hashJoinType7.equals(hashJoinType8)) return false;
                }
            }
        }
        if (!new ArrayOps.ofBoolean(Predef$.MODULE$.booleanArrayOps(filterNulls)).forall((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)b)))) return false;
        if (keyType.getFieldCount() != 1) return false;
        LogicalTypeRoot logicalTypeRoot = keyType.getTypeAt(0).getTypeRoot();
        if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot)) {
            return true;
        }
        if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot)) {
            return true;
        }
        if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
            return true;
        }
        if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
            return true;
        }
        if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
            return true;
        }
        if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
            return true;
        }
        if (LogicalTypeRoot.DATE.equals(logicalTypeRoot)) {
            return true;
        }
        if (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) {
            return true;
        }
        if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            TimestampType timestampType = (TimestampType)keyType.getTypeAt(0);
            bl = TimestampData.isCompact((int)timestampType.getPrecision());
        } else {
            if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot)) return false;
            LocalZonedTimestampType lzTs = (LocalZonedTimestampType)keyType.getTypeAt(0);
            bl = TimestampData.isCompact((int)lzTs.getPrecision());
        }
        if (!bl) return false;
        return true;
    }

    public String genGetLongKey(RowType keyType, int[] keyMapping, String rowTerm) {
        LogicalType singleType = keyType.getTypeAt(0);
        String getCode = CodeGenUtils$.MODULE$.rowFieldReadAccess(keyMapping[0], rowTerm, singleType);
        LogicalTypeRoot logicalTypeRoot = singleType.getTypeRoot();
        String string = LogicalTypeRoot.FLOAT.equals(logicalTypeRoot) ? new java.lang.StringBuilder(22).append("Float.floatToIntBits(").append(getCode).append(")").toString() : (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot) ? new java.lang.StringBuilder(25).append("Double.doubleToLongBits(").append(getCode).append(")").toString() : (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? new java.lang.StringBuilder(17).append(getCode).append(".getMillisecond()").toString() : (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot) ? new java.lang.StringBuilder(17).append(getCode).append(".getMillisecond()").toString() : getCode)));
        String term = string;
        return new java.lang.StringBuilder(8).append("return ").append(term).append(";").toString();
    }

    public Tuple2<String, String> genAnyNullsInKeys(int[] keyMapping, String rowTerm, CodeGeneratorContext ctx) {
        StringBuilder builder = new StringBuilder();
        String anyNullTerm = CodeGenUtils$.MODULE$.newName(ctx, "anyNull");
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(keyMapping)).foreach((Function1 & Serializable & scala.Serializable)key -> builder.append(new java.lang.StringBuilder(16).append(anyNullTerm).append(" |= ").append(rowTerm).append(".isNullAt(").append(BoxesRunTime.unboxToInt((Object)key)).append(");").toString()));
        return new Tuple2((Object)new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(45).append("\n         |boolean ").append(anyNullTerm).append(" = false;\n         |").append((CharSequence)builder).append("\n     ").toString())).stripMargin(), (Object)anyNullTerm);
    }

    public GeneratedProjection genProjection(ReadableConfig tableConfig, ClassLoader classLoader, LogicalType[] types, CodeGeneratorContext parentCtx) {
        RowType rowType = RowType.of((LogicalType[])types);
        return ProjectionCodeGenerator$.MODULE$.generateProjection(new CodeGeneratorContext(tableConfig, classLoader, parentCtx), "Projection", rowType, rowType, (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])types)).indices().toArray(ClassTag$.MODULE$.Int()));
    }

    public CodeGenOperatorFactory<RowData> gen(ReadableConfig tableConfig, ClassLoader classLoader, HashJoinType hashJoinType, RowType keyType, RowType buildType, RowType probeType, int[] buildKeyMapping, int[] probeKeyMapping, int buildRowSize, long buildRowCount, boolean reverseJoinFunction, GeneratedJoinCondition condFunc, boolean leftIsBuild, boolean compressionEnabled, int compressionBlockSize, SortMergeJoinFunction sortMergeJoinFunction) {
        String string;
        BinaryRowDataSerializer buildSer = new BinaryRowDataSerializer(buildType.getFieldCount());
        BinaryRowDataSerializer probeSer = new BinaryRowDataSerializer(probeType.getFieldCount());
        CodeGeneratorContext ctx = new CodeGeneratorContext(tableConfig, classLoader);
        String tableTerm = CodeGenUtils$.MODULE$.newName(ctx, "LongHashTable");
        String buildSerTerm = ctx.addReusableObject(buildSer, "buildSer", ctx.addReusableObject$default$3());
        String probeSerTerm = ctx.addReusableObject(probeSer, "probeSer", ctx.addReusableObject$default$3());
        GeneratedProjection bGenProj = this.genProjection(tableConfig, classLoader, (LogicalType[])buildType.getChildren().toArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(LogicalType.class))), ctx);
        ctx.addReusableInnerClass(bGenProj.getClassName(), bGenProj.getCode());
        GeneratedProjection pGenProj = this.genProjection(tableConfig, classLoader, (LogicalType[])probeType.getChildren().toArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(LogicalType.class))), ctx);
        ctx.addReusableInnerClass(pGenProj.getClassName(), pGenProj.getCode());
        ctx.addReusableInnerClass(condFunc.getClassName(), condFunc.getCode());
        ctx.addReusableMember(new java.lang.StringBuilder(18).append(bGenProj.getClassName()).append(" buildToBinaryRow;").toString());
        String buildProjRefs = ctx.addReusableObject(bGenProj.getReferences(), "buildProjRefs", ctx.addReusableObject$default$3());
        ctx.addReusableInitStatement(new java.lang.StringBuilder(26).append("buildToBinaryRow = new ").append(bGenProj.getClassName()).append("(").append(buildProjRefs).append(");").toString());
        ctx.addReusableMember(new java.lang.StringBuilder(18).append(pGenProj.getClassName()).append(" probeToBinaryRow;").toString());
        String probeProjRefs = ctx.addReusableObject(pGenProj.getReferences(), "probeProjRefs", ctx.addReusableObject$default$3());
        ctx.addReusableInitStatement(new java.lang.StringBuilder(26).append("probeToBinaryRow = new ").append(pGenProj.getClassName()).append("(").append(probeProjRefs).append(");").toString());
        ctx.addReusableMember(new java.lang.StringBuilder(10).append(condFunc.getClassName()).append(" condFunc;").toString());
        String condRefs = ctx.addReusableObject(condFunc.getReferences(), "condRefs", ctx.addReusableObject$default$3());
        ctx.addReusableInitStatement(new java.lang.StringBuilder(18).append("condFunc = new ").append(condFunc.getClassName()).append("(").append(condRefs).append(");").toString());
        ctx.addReusableOpenStatement("condFunc.setRuntimeContext(getRuntimeContext());");
        ctx.addReusableOpenStatement(new java.lang.StringBuilder(22).append("condFunc.open(new ").append(CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(Configuration.class))).append("());").toString());
        ctx.addReusableCloseStatement("condFunc.close();");
        String leftIsBuildTerm = CodeGenUtils$.MODULE$.newName(ctx, "leftIsBuild");
        ctx.addReusableMember(new java.lang.StringBuilder(26).append("private final boolean ").append(leftIsBuildTerm).append(" = ").append(leftIsBuild).append(";").toString());
        String smjFunctionTerm = CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(SortMergeJoinFunction.class));
        ctx.addReusableMember(new java.lang.StringBuilder(37).append("private final ").append(smjFunctionTerm).append(" sortMergeJoinFunction;").toString());
        String smjFunctionRefs = ctx.addReusableObject(new SortMergeJoinFunction[]{sortMergeJoinFunction}, "smjFunctionRefs", ctx.addReusableObject$default$3());
        ctx.addReusableInitStatement(new java.lang.StringBuilder(28).append("sortMergeJoinFunction = ").append(smjFunctionRefs).append("[0];").toString());
        String fallbackSMJ = CodeGenUtils$.MODULE$.newName(ctx, "fallbackSMJ");
        ctx.addReusableMember(new java.lang.StringBuilder(35).append("private transient boolean ").append(fallbackSMJ).append(" = false;").toString());
        String gauge = Gauge.class.getCanonicalName();
        ctx.addReusableOpenStatement(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(615).append("\n         |getMetricGroup().gauge(\"memoryUsedSizeInBytes\", new ").append(gauge).append("<Long>() {\n         |  @Override\n         |  public Long getValue() {\n         |    return table.getUsedMemoryInBytes();\n         |  }\n         |});\n         |getMetricGroup().gauge(\"numSpillFiles\", new ").append(gauge).append("<Long>() {\n         |  @Override\n         |  public Long getValue() {\n         |    return table.getNumSpillFiles();\n         |  }\n         |});\n         |getMetricGroup().gauge(\"spillInBytes\", new ").append(gauge).append("<Long>() {\n         |  @Override\n         |  public Long getValue() {\n         |    return table.getSpillInBytes();\n         |  }\n         |});\n       ").toString())).stripMargin());
        String tableCode = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(922).append("\n         |public class ").append(tableTerm).append(" extends ").append(LongHybridHashTable.class.getCanonicalName()).append(" {\n         |\n         |  public ").append(tableTerm).append("() {\n         |    super(getContainingTask(),\n         |      ").append(compressionEnabled).append(", ").append(compressionBlockSize).append(",\n         |      ").append(buildSerTerm).append(", ").append(probeSerTerm).append(",\n         |      getContainingTask().getEnvironment().getMemoryManager(),\n         |      computeMemorySize(),\n         |      getContainingTask().getEnvironment().getIOManager(),\n         |      ").append(buildRowSize).append(",\n         |      ").append(buildRowCount).append("L / getRuntimeContext().getNumberOfParallelSubtasks());\n         |  }\n         |\n         |  @Override\n         |  public long getBuildLongKey(").append(CodeGenUtils$.MODULE$.ROW_DATA()).append(" row) {\n         |    ").append(this.genGetLongKey(keyType, buildKeyMapping, "row")).append("\n         |  }\n         |\n         |  @Override\n         |  public long getProbeLongKey(").append(CodeGenUtils$.MODULE$.ROW_DATA()).append(" row) {\n         |    ").append(this.genGetLongKey(keyType, probeKeyMapping, "row")).append("\n         |  }\n         |\n         |  @Override\n         |  public ").append(CodeGenUtils$.MODULE$.BINARY_ROW()).append(" probeToBinary(").append(CodeGenUtils$.MODULE$.ROW_DATA()).append(" row) {\n         |    if (row instanceof ").append(CodeGenUtils$.MODULE$.BINARY_ROW()).append(") {\n         |      return (").append(CodeGenUtils$.MODULE$.BINARY_ROW()).append(") row;\n         |    } else {\n         |      return probeToBinaryRow.apply(row);\n         |    }\n         |  }\n         |}\n       ").toString())).stripMargin();
        ctx.addReusableInnerClass(tableTerm, tableCode);
        ctx.addReusableNullRow("buildSideNullRow", buildSer.getArity());
        ctx.addReusableOutputRecord((LogicalType)RowType.of((LogicalType[])new LogicalType[0]), JoinedRowData.class, "joinedRow", ctx.addReusableOutputRecord$default$4());
        ctx.addReusableMember(new java.lang.StringBuilder(7).append(tableTerm).append(" table;").toString());
        ctx.addReusableOpenStatement(new java.lang.StringBuilder(15).append("table = new ").append(tableTerm).append("();").toString());
        Tuple2<String, String> tuple2 = this.genAnyNullsInKeys(buildKeyMapping, "row", ctx);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String nullCheckBuildCode = (String)tuple2._1();
        String nullCheckBuildTerm = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)nullCheckBuildCode, (Object)nullCheckBuildTerm);
        Tuple2 tuple23 = tuple22;
        String nullCheckBuildCode2 = (String)tuple23._1();
        String nullCheckBuildTerm2 = (String)tuple23._2();
        Tuple2<String, String> tuple24 = this.genAnyNullsInKeys(probeKeyMapping, "row", ctx);
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        String nullCheckProbeCode = (String)tuple24._1();
        String nullCheckProbeTerm = (String)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)nullCheckProbeCode, (Object)nullCheckProbeTerm);
        Tuple2 tuple26 = tuple25;
        String nullCheckProbeCode2 = (String)tuple26._1();
        String nullCheckProbeTerm2 = (String)tuple26._2();
        String applyCond = reverseJoinFunction ? "condFunc.apply(probeRow, buildIter.getRow())" : "condFunc.apply(buildIter.getRow(), probeRow)";
        HashJoinType hashJoinType2 = hashJoinType;
        if (HashJoinType.INNER.equals(hashJoinType2)) {
            string = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(125).append("\n           |while (buildIter.advanceNext()) {\n           |  if (").append(applyCond).append(") {\n           |    ").append(LongHashJoinGenerator$.collectCode$1("buildIter.getRow()", "probeRow", reverseJoinFunction)).append("\n           |  }\n           |}\n         ").toString())).stripMargin();
        } else if (HashJoinType.SEMI.equals(hashJoinType2)) {
            string = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(148).append("\n           |while (buildIter.advanceNext()) {\n           |  if (").append(applyCond).append(") {\n           |    ").append(OperatorCodeGenerator$.MODULE$.generateCollect("probeRow")).append("\n           |    break;\n           |  }\n           |}\n         ").toString())).stripMargin();
        } else if (HashJoinType.ANTI.equals(hashJoinType2)) {
            string = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(257).append("\n           |boolean matched = false;\n           |while (buildIter.advanceNext()) {\n           |  if (").append(applyCond).append(") {\n           |    matched = true;\n           |    break;\n           |  }\n           |}\n           |if (!matched) {\n           |  ").append(OperatorCodeGenerator$.MODULE$.generateCollect("probeRow")).append("\n           |}\n         ").toString())).stripMargin();
        } else if (HashJoinType.PROBE_OUTER.equals(hashJoinType2)) {
            string = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(251).append("\n           |boolean matched = false;\n           |while (buildIter.advanceNext()) {\n           |  if (").append(applyCond).append(") {\n           |    ").append(LongHashJoinGenerator$.collectCode$1("buildIter.getRow()", "probeRow", reverseJoinFunction)).append("\n           |    matched = true;\n           |  }\n           |}\n           |if (!matched) {\n           |  ").append(LongHashJoinGenerator$.collectCode$1("buildSideNullRow", "probeRow", reverseJoinFunction)).append("\n           |}\n         ").toString())).stripMargin();
        } else {
            throw new MatchError((Object)hashJoinType2);
        }
        String joinCode = string;
        HashJoinType hashJoinType3 = hashJoinType;
        String string2 = HashJoinType.ANTI.equals(hashJoinType3) ? new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(58).append("\n           |else {\n           |  ").append(OperatorCodeGenerator$.MODULE$.generateCollect("row")).append("\n           |}\n         ").toString())).stripMargin() : (HashJoinType.PROBE_OUTER.equals(hashJoinType3) ? new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(58).append("\n           |else {\n           |  ").append(LongHashJoinGenerator$.collectCode$1("buildSideNullRow", "row", reverseJoinFunction)).append("\n           |}\n         ").toString())).stripMargin() : "");
        String nullOuterJoin = string2;
        ctx.addReusableMember(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(339).append("\n         |private void joinWithNextKey() throws Exception {\n         |  ").append(LongHashPartition.MatchIterator.class.getCanonicalName()).append(" buildIter =\n         |      table.getBuildSideIterator();\n         |  ").append(CodeGenUtils$.MODULE$.ROW_DATA()).append(" probeRow = table.getCurrentProbeRow();\n         |  if (probeRow == null) {\n         |    throw new RuntimeException(\"ProbeRow should not be null\");\n         |  }\n         |  ").append(joinCode).append("\n         |}\n       ").toString())).stripMargin());
        String rowIter = RowIterator.class.getCanonicalName();
        ctx.addReusableMember(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(1847).append("\n                             |private void fallbackSMJProcessPartition() throws Exception {\n                             |  if(!table.getPartitionsPendingForSMJ().isEmpty()) {\n                             |    table.releaseMemoryCacheForSMJ();\n                             |    LOG.info(\n                             |    \"Fallback to sort merge join to process spilled partitions.\");\n                             |    initialSortMergeJoinFunction();\n                             |    ").append(fallbackSMJ).append(" = true;\n                             |\n                             |    for(").append(LongHashPartition.class.getCanonicalName()).append(" p : \n                             |      table.getPartitionsPendingForSMJ()) {\n                             |      ").append(rowIter).append("<").append(CodeGenUtils$.MODULE$.BINARY_ROW()).append("> buildSideIter = \n                             |      table.getSpilledPartitionBuildSideIter(p);\n                             |      while (buildSideIter.advanceNext()) {\n                             |        processSortMergeJoinElement1(buildSideIter.getRow());\n                             |      }\n                             |\n                             |      ").append(ProbeIterator.class.getCanonicalName()).append(" probeIter =\n                             |      table.getSpilledPartitionProbeSideIter(p);\n                             |      ").append(CodeGenUtils$.MODULE$.BINARY_ROW()).append(" probeNext;\n                             |      while ((probeNext = probeIter.next()) != null) {\n                             |        processSortMergeJoinElement2(probeNext);\n                             |      }\n                             |    }\n                             |\n                             |    closeHashTable();\n                             |\n                             |    sortMergeJoinFunction.endInput(1);\n                             |    sortMergeJoinFunction.endInput(2);\n                             |    LOG.info(\"Finish sort merge join for spilled partitions.\");\n                             |  }\n                             |}\n       ").toString())).stripMargin());
        String collector = StreamRecordCollector.class.getCanonicalName();
        ctx.addReusableMember(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(581).append("\n                             |private void initialSortMergeJoinFunction() throws Exception {\n                             |  sortMergeJoinFunction.open(\n                             |    true,\n                             |    this.getContainingTask(),\n                             |    this.getOperatorConfig(),\n                             |    new ").append(collector).append("<").append(CodeGenUtils$.MODULE$.ROW_DATA()).append(">(output),\n                             |    this.computeMemorySize(),\n                             |    this.getRuntimeContext(),\n                             |    this.getMetricGroup());\n                             |}\n       ").toString())).stripMargin());
        ctx.addReusableMember(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(279).append("\n         |private void processSortMergeJoinElement1(").append(CodeGenUtils$.MODULE$.ROW_DATA()).append(" rowData) throws Exception {\n         |  if(").append(leftIsBuild).append(") {\n         |    sortMergeJoinFunction.processElement1(rowData);\n         |  } else {\n         |    sortMergeJoinFunction.processElement2(rowData);\n         |  }\n         |}\n       ").toString())).stripMargin());
        ctx.addReusableMember(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(279).append("\n         |private void processSortMergeJoinElement2(").append(CodeGenUtils$.MODULE$.ROW_DATA()).append(" rowData) throws Exception {\n         |  if(").append(leftIsBuild).append(") {\n         |    sortMergeJoinFunction.processElement2(rowData);\n         |  } else {\n         |    sortMergeJoinFunction.processElement1(rowData);\n         |  }\n         |}\n       ").toString())).stripMargin());
        ctx.addReusableMember(new StringOps(Predef$.MODULE$.augmentString("\n                             |private void closeHashTable() {\n                             |  if (this.table != null) {\n                             |    this.table.close();\n                             |    this.table.free();\n                             |    this.table = null;\n                             |  }\n                             |}\n       ")).stripMargin());
        ctx.addReusableCloseStatement(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(260).append("\n                                     |closeHashTable();\n                                     |\n                                     |if (").append(fallbackSMJ).append(") {\n                                     |  sortMergeJoinFunction.close();\n                                     |}\n       ").toString())).stripMargin());
        String buildEnd = CodeGenUtils$.MODULE$.newName(ctx, "buildEnd");
        ctx.addReusableMember(new java.lang.StringBuilder(35).append("private transient boolean ").append(buildEnd).append(" = false;").toString());
        CodeGeneratorContext x$3 = ctx;
        String x$4 = "LongHashJoinOperator";
        String x$5 = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(191).append("\n         |").append(CodeGenUtils$.MODULE$.ROW_DATA()).append(" row = (").append(CodeGenUtils$.MODULE$.ROW_DATA()).append(") element.getValue();\n         |").append(nullCheckBuildCode2).append("\n         |if (!").append(nullCheckBuildTerm2).append(") {\n         |  table.putBuildRow(row instanceof ").append(CodeGenUtils$.MODULE$.BINARY_ROW()).append(" ?\n         |    (").append(CodeGenUtils$.MODULE$.BINARY_ROW()).append(") row : buildToBinaryRow.apply(row));\n         |}\n       ").toString())).stripMargin();
        String x$6 = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(187).append("\n         |").append(CodeGenUtils$.MODULE$.ROW_DATA()).append(" row = (").append(CodeGenUtils$.MODULE$.ROW_DATA()).append(") element.getValue();\n         |").append(nullCheckProbeCode2).append("\n         |if (!").append(nullCheckProbeTerm2).append(") {\n         |  if (table.tryProbe(row)) {\n         |    joinWithNextKey();\n         |  }\n         |}\n         |").append(nullOuterJoin).append("\n       ").toString())).stripMargin();
        RowType x$7 = buildType;
        RowType x$8 = probeType;
        Some x$9 = new Some((Object)new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(239).append("\n                                  |if (").append(buildEnd).append(") {\n                                  |  return ").append(OperatorCodeGenerator$.MODULE$.INPUT_SELECTION()).append(".SECOND;\n                                  |} else {\n                                  |  return ").append(OperatorCodeGenerator$.MODULE$.INPUT_SELECTION()).append(".FIRST;\n                                  |}\n         ").toString())).stripMargin());
        Some x$10 = new Some((Object)new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(161).append("\n                              |LOG.info(\"Finish build phase.\");\n                              |table.endBuild();\n                              |").append(buildEnd).append(" = true;\n       ").toString())).stripMargin());
        Some x$11 = new Some((Object)new StringOps(Predef$.MODULE$.augmentString("\n                              |LOG.info(\"Finish probe phase.\");\n                              |while (this.table.nextMatching()) {\n                              |  joinWithNextKey();\n                              |}\n                              |LOG.info(\"Finish rebuild phase.\");\n                              |\n                              |fallbackSMJProcessPartition();\n         ")).stripMargin());
        String x$12 = OperatorCodeGenerator$.MODULE$.generateTwoInputStreamOperator$default$7();
        String x$13 = OperatorCodeGenerator$.MODULE$.generateTwoInputStreamOperator$default$8();
        boolean x$14 = OperatorCodeGenerator$.MODULE$.generateTwoInputStreamOperator$default$12();
        GeneratedOperator genOp = OperatorCodeGenerator$.MODULE$.generateTwoInputStreamOperator(x$3, x$4, x$5, x$6, (LogicalType)x$7, (LogicalType)x$8, x$12, x$13, (Option<String>)x$9, (Option<String>)x$10, (Option<String>)x$11, x$14);
        return new CodeGenOperatorFactory(genOp);
    }

    private static final String collectCode$1(String term1, String term2, boolean reverseJoinFunction$1) {
        return reverseJoinFunction$1 ? OperatorCodeGenerator$.MODULE$.generateCollect(new java.lang.StringBuilder(21).append("joinedRow.replace(").append(term2).append(", ").append(term1).append(")").toString()) : OperatorCodeGenerator$.MODULE$.generateCollect(new java.lang.StringBuilder(21).append("joinedRow.replace(").append(term1).append(", ").append(term2).append(")").toString());
    }

    private LongHashJoinGenerator$() {
        MODULE$ = this;
    }
}

