/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.rules.ProjectCalcMergeRule;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.flink.calcite.shaded.com.google.common.base.MoreObjects;
import org.apache.flink.calcite.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ProjectCalcMergeRule", generator="Immutables")
final class ImmutableProjectCalcMergeRule {
    private ImmutableProjectCalcMergeRule() {
    }

    @CheckReturnValue
    @Generated(from="ProjectCalcMergeRule.Config", generator="Immutables")
    @Immutable
    static final class Config
    implements ProjectCalcMergeRule.Config {
        private final RelBuilderFactory relBuilderFactory;
        @javax.annotation.Nullable
        private final @Nullable String description;
        private final RelRule.OperandTransform operandSupplier;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();
        private static final Config INSTANCE = Config.validate(new Config());

        private Config() {
            this.description = null;
            this.relBuilderFactory = this.initShim.relBuilderFactory();
            this.operandSupplier = this.initShim.operandSupplier();
            this.initShim = null;
        }

        private Config(Builder builder) {
            this.description = builder.description;
            if (builder.relBuilderFactory != null) {
                this.initShim.withRelBuilderFactory(builder.relBuilderFactory);
            }
            if (builder.operandSupplier != null) {
                this.initShim.withOperandSupplier(builder.operandSupplier);
            }
            this.relBuilderFactory = this.initShim.relBuilderFactory();
            this.operandSupplier = this.initShim.operandSupplier();
            this.initShim = null;
        }

        private Config(RelBuilderFactory relBuilderFactory, @javax.annotation.Nullable @Nullable String description, RelRule.OperandTransform operandSupplier) {
            this.relBuilderFactory = relBuilderFactory;
            this.description = description;
            this.operandSupplier = operandSupplier;
            this.initShim = null;
        }

        private RelBuilderFactory relBuilderFactoryInitialize() {
            return ProjectCalcMergeRule.Config.super.relBuilderFactory();
        }

        private RelRule.OperandTransform operandSupplierInitialize() {
            return ProjectCalcMergeRule.Config.super.operandSupplier();
        }

        @Override
        public RelBuilderFactory relBuilderFactory() {
            InitShim shim = this.initShim;
            return shim != null ? shim.relBuilderFactory() : this.relBuilderFactory;
        }

        @Override
        @javax.annotation.Nullable
        public @Nullable String description() {
            return this.description;
        }

        @Override
        public RelRule.OperandTransform operandSupplier() {
            InitShim shim = this.initShim;
            return shim != null ? shim.operandSupplier() : this.operandSupplier;
        }

        @Override
        public final Config withRelBuilderFactory(RelBuilderFactory value) {
            if (this.relBuilderFactory == value) {
                return this;
            }
            RelBuilderFactory newValue = Objects.requireNonNull(value, "relBuilderFactory");
            return Config.validate(new Config(newValue, this.description, this.operandSupplier));
        }

        @Override
        public final Config withDescription(@javax.annotation.Nullable @Nullable String value) {
            if (Objects.equals(this.description, value)) {
                return this;
            }
            return Config.validate(new Config(this.relBuilderFactory, value, this.operandSupplier));
        }

        @Override
        public final Config withOperandSupplier(RelRule.OperandTransform value) {
            if (this.operandSupplier == value) {
                return this;
            }
            RelRule.OperandTransform newValue = Objects.requireNonNull(value, "operandSupplier");
            return Config.validate(new Config(this.relBuilderFactory, this.description, newValue));
        }

        public boolean equals(@javax.annotation.Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Config && this.equalTo((Config)another);
        }

        private boolean equalTo(Config another) {
            return this.relBuilderFactory.equals(another.relBuilderFactory) && Objects.equals(this.description, another.description) && this.operandSupplier.equals(another.operandSupplier);
        }

        public int hashCode() {
            int h2 = 5381;
            h2 += (h2 << 5) + this.relBuilderFactory.hashCode();
            h2 += (h2 << 5) + Objects.hashCode(this.description);
            h2 += (h2 << 5) + this.operandSupplier.hashCode();
            return h2;
        }

        public String toString() {
            return MoreObjects.toStringHelper("Config").omitNullValues().add("relBuilderFactory", this.relBuilderFactory).add("description", this.description).add("operandSupplier", this.operandSupplier).toString();
        }

        public static Config of() {
            return INSTANCE;
        }

        private static Config validate(Config instance) {
            return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
        }

        public static Config copyOf(ProjectCalcMergeRule.Config instance) {
            if (instance instanceof Config) {
                return (Config)instance;
            }
            return Config.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="ProjectCalcMergeRule.Config", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            @javax.annotation.Nullable
            private RelBuilderFactory relBuilderFactory;
            @javax.annotation.Nullable
            private @Nullable String description;
            @javax.annotation.Nullable
            private RelRule.OperandTransform operandSupplier;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(RelRule.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(ProjectCalcMergeRule.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                if (object instanceof RelRule.Config) {
                    RelRule.Config instance = (RelRule.Config)object;
                    this.withRelBuilderFactory(instance.relBuilderFactory());
                    this.withOperandSupplier(instance.operandSupplier());
                    @Nullable String descriptionValue = instance.description();
                    if (descriptionValue != null) {
                        this.withDescription(descriptionValue);
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = Objects.requireNonNull(relBuilderFactory, "relBuilderFactory");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withDescription(@javax.annotation.Nullable @Nullable String description) {
                this.description = description;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withOperandSupplier(RelRule.OperandTransform operandSupplier) {
                this.operandSupplier = Objects.requireNonNull(operandSupplier, "operandSupplier");
                return this;
            }

            public Config build() {
                return Config.validate(new Config(this));
            }
        }

        @Generated(from="ProjectCalcMergeRule.Config", generator="Immutables")
        private final class InitShim {
            private byte relBuilderFactoryBuildStage = 0;
            private RelBuilderFactory relBuilderFactory;
            private byte operandSupplierBuildStage = 0;
            private RelRule.OperandTransform operandSupplier;

            private InitShim() {
            }

            RelBuilderFactory relBuilderFactory() {
                if (this.relBuilderFactoryBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.relBuilderFactoryBuildStage == 0) {
                    this.relBuilderFactoryBuildStage = (byte)-1;
                    this.relBuilderFactory = Objects.requireNonNull(Config.this.relBuilderFactoryInitialize(), "relBuilderFactory");
                    this.relBuilderFactoryBuildStage = 1;
                }
                return this.relBuilderFactory;
            }

            void withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = relBuilderFactory;
                this.relBuilderFactoryBuildStage = 1;
            }

            RelRule.OperandTransform operandSupplier() {
                if (this.operandSupplierBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.operandSupplierBuildStage == 0) {
                    this.operandSupplierBuildStage = (byte)-1;
                    this.operandSupplier = Objects.requireNonNull(Config.this.operandSupplierInitialize(), "operandSupplier");
                    this.operandSupplierBuildStage = 1;
                }
                return this.operandSupplier;
            }

            void withOperandSupplier(RelRule.OperandTransform operandSupplier) {
                this.operandSupplier = operandSupplier;
                this.operandSupplierBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.relBuilderFactoryBuildStage == -1) {
                    attributes.add("relBuilderFactory");
                }
                if (this.operandSupplierBuildStage == -1) {
                    attributes.add("operandSupplier");
                }
                return "Cannot build Config, attribute initializers form cycle " + attributes;
            }
        }
    }
}

