/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.logical;

import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.planner.plan.logical.WindowSpec;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TimeUtils;

@JsonTypeName(value="CumulativeWindow")
public class CumulativeWindowSpec
implements WindowSpec {
    public static final String FIELD_NAME_MAX_SIZE = "maxSize";
    public static final String FIELD_NAME_STEP = "step";
    public static final String FIELD_NAME_OFFSET = "offset";
    @JsonProperty(value="maxSize")
    private final Duration maxSize;
    @JsonProperty(value="step")
    private final Duration step;
    @JsonProperty(value="offset")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    private final Duration offset;

    @JsonCreator
    public CumulativeWindowSpec(@JsonProperty(value="maxSize") Duration maxSize, @JsonProperty(value="step") Duration step, @JsonProperty(value="offset") @Nullable Duration offset) {
        this.maxSize = (Duration)Preconditions.checkNotNull((Object)maxSize);
        this.step = (Duration)Preconditions.checkNotNull((Object)step);
        this.offset = offset;
    }

    @Override
    public String toSummaryString(String windowing, String[] inputFieldNames) {
        if (this.offset == null) {
            return String.format("CUMULATE(%s, max_size=[%s], step=[%s])", windowing, TimeUtils.formatWithHighestUnit((Duration)this.maxSize), TimeUtils.formatWithHighestUnit((Duration)this.step));
        }
        return String.format("CUMULATE(%s, max_size=[%s], step=[%s], offset=[%s])", windowing, TimeUtils.formatWithHighestUnit((Duration)this.maxSize), TimeUtils.formatWithHighestUnit((Duration)this.step), TimeUtils.formatWithHighestUnit((Duration)this.offset));
    }

    public Duration getMaxSize() {
        return this.maxSize;
    }

    public Duration getStep() {
        return this.step;
    }

    public Duration getOffset() {
        return this.offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CumulativeWindowSpec that = (CumulativeWindowSpec)o;
        return this.maxSize.equals(that.maxSize) && this.step.equals(that.step) && Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        return Objects.hash(CumulativeWindowSpec.class, this.maxSize, this.step, this.offset);
    }

    public String toString() {
        if (this.offset == null) {
            return String.format("CUMULATE(max_size=[%s], step=[%s])", TimeUtils.formatWithHighestUnit((Duration)this.maxSize), TimeUtils.formatWithHighestUnit((Duration)this.step));
        }
        return String.format("CUMULATE(max_size=[%s], step=[%s], offset=[%s])", TimeUtils.formatWithHighestUnit((Duration)this.maxSize), TimeUtils.formatWithHighestUnit((Duration)this.step), TimeUtils.formatWithHighestUnit((Duration)this.offset));
    }

    @Override
    public boolean isAlignedWindow() {
        return true;
    }
}

