/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.fusion;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.plan.fusion.OpFusionCodegenSpec;
import org.apache.flink.table.planner.plan.fusion.OpFusionContext;
import org.apache.flink.table.types.logical.RowType;

@Internal
public abstract class OpFusionCodegenSpecGenerator {
    private final RowType outputType;
    protected final OpFusionCodegenSpec opFusionCodegenSpec;
    private final OpFusionContext opFusionContext;
    private double managedMemoryFraction = 0.0;

    public OpFusionCodegenSpecGenerator(RowType outputType, OpFusionCodegenSpec opFusionCodegenSpec) {
        this.outputType = outputType;
        this.opFusionCodegenSpec = opFusionCodegenSpec;
        this.opFusionContext = new OpFusionContextImpl(this);
    }

    public void setup(Context context) {
        this.managedMemoryFraction = context.getManagedMemoryFraction();
        this.opFusionCodegenSpec.setup(this.opFusionContext);
    }

    public RowType getOutputType() {
        return this.outputType;
    }

    public OpFusionCodegenSpec getOpFusionCodegenSpec() {
        return this.opFusionCodegenSpec;
    }

    public OpFusionContext getOpFusionContext() {
        return this.opFusionContext;
    }

    public abstract long getManagedMemory();

    public abstract List<OpFusionCodegenSpecGenerator> getInputs();

    public abstract void addOutput(int var1, OpFusionCodegenSpecGenerator var2);

    public abstract void processProduce(CodeGeneratorContext var1);

    public abstract String processConsume(List<GeneratedExpression> var1, String var2);

    public abstract void endInputProduce(CodeGeneratorContext var1);

    public abstract String endInputConsume();

    public abstract void addReusableInitCode(CodeGeneratorContext var1);

    public abstract void addReusableOpenCode(CodeGeneratorContext var1);

    public abstract void addReusableCloseCode(CodeGeneratorContext var1);

    @Internal
    static interface Context {
        public double getManagedMemoryFraction();
    }

    private static class OpFusionContextImpl
    implements OpFusionContext {
        private final OpFusionCodegenSpecGenerator fusionCodegenSpecGenerator;

        public OpFusionContextImpl(OpFusionCodegenSpecGenerator fusionCodegenSpecGenerator) {
            this.fusionCodegenSpecGenerator = fusionCodegenSpecGenerator;
        }

        @Override
        public RowType getOutputType() {
            return this.fusionCodegenSpecGenerator.outputType;
        }

        @Override
        public double getManagedMemoryFraction() {
            return this.fusionCodegenSpecGenerator.managedMemoryFraction;
        }

        @Override
        public List<OpFusionContext> getInputFusionContexts() {
            return this.fusionCodegenSpecGenerator.getInputs().stream().map(OpFusionCodegenSpecGenerator::getOpFusionContext).collect(Collectors.toList());
        }

        @Override
        public void processProduce(CodeGeneratorContext codegenCtx) {
            this.fusionCodegenSpecGenerator.processProduce(codegenCtx);
        }

        @Override
        public void endInputProduce(CodeGeneratorContext codegenCtx) {
            this.fusionCodegenSpecGenerator.endInputProduce(codegenCtx);
        }

        @Override
        public String processConsume(List<GeneratedExpression> outputVars, String row) {
            return this.fusionCodegenSpecGenerator.processConsume(outputVars, row);
        }

        @Override
        public String endInputConsume() {
            return this.fusionCodegenSpecGenerator.endInputConsume();
        }
    }
}

