/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.ExplicitOperatorBinding;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.calcite.FlinkSqlCallBinding;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlProcedure;
import org.apache.flink.table.planner.functions.inference.OperatorBindingCallContext;
import org.apache.flink.table.planner.operations.PlannerCallProcedureOperation;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.plan.utils.RexLiteralUtil;
import org.apache.flink.table.planner.typeutils.LogicalRelDataTypeConverter;
import org.apache.flink.table.procedures.ProcedureDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeInferenceUtil;

public class SqlProcedureCallConverter
implements SqlNodeConverter<SqlNode> {
    @Override
    public Optional<EnumSet<SqlKind>> supportedSqlKinds() {
        return Optional.of(EnumSet.of(SqlKind.PROCEDURE_CALL));
    }

    @Override
    public Operation convertSqlNode(SqlNode sqlNode, SqlNodeConverter.ConvertContext context) {
        SqlCall callProcedure = (SqlCall)((SqlCall)sqlNode).getOperandList().get(0);
        BridgingSqlProcedure sqlProcedure = (BridgingSqlProcedure)callProcedure.getOperator();
        SqlValidator sqlValidator = context.getSqlValidator();
        ProcedureDefinition procedureDefinition = new ProcedureDefinition(sqlProcedure.getContextResolveProcedure().getProcedure());
        FlinkSqlCallBinding sqlCallBinding = new FlinkSqlCallBinding(context.getSqlValidator(), ((SqlValidatorImpl)context.getSqlValidator()).getEmptyScope(), callProcedure);
        List<RexNode> reducedOperands = this.reduceOperands(sqlCallBinding, context);
        ExplicitOperatorBinding sqlOperatorBinding = new ExplicitOperatorBinding(context.getSqlValidator().getTypeFactory(), sqlProcedure, reducedOperands.stream().map(RexNode::getType).collect(Collectors.toList()));
        OperatorBindingCallContext bindingCallContext = new OperatorBindingCallContext(context.getCatalogManager().getDataTypeFactory(), (FunctionDefinition)procedureDefinition, sqlOperatorBinding, sqlValidator.getValidatedNodeType(callProcedure));
        TypeInferenceUtil.Result typeInferResult = TypeInferenceUtil.runTypeInference((TypeInference)procedureDefinition.getTypeInference(context.getCatalogManager().getDataTypeFactory()), (CallContext)bindingCallContext, null);
        List argumentTypes = typeInferResult.getExpectedArgumentTypes();
        int argumentCount = argumentTypes.size();
        DataType[] inputTypes = new DataType[argumentCount];
        Object[] params = new Object[argumentCount];
        for (int i = 0; i < argumentCount; ++i) {
            Object internalValue;
            inputTypes[i] = (DataType)argumentTypes.get(i);
            RexNode reducedOperand = reducedOperands.get(i);
            if (!(reducedOperand instanceof RexLiteral)) {
                throw new ValidationException(String.format("The argument at position %s %s for calling procedure can't be converted to literal.", i, context.toQuotedSqlString((SqlNode)callProcedure.operand(i))));
            }
            RexLiteral literalOperand = (RexLiteral)reducedOperand;
            params[i] = internalValue = RexLiteralUtil.toFlinkInternalValue(literalOperand.getValueAs(Comparable.class), inputTypes[i].getLogicalType());
        }
        return new PlannerCallProcedureOperation((ObjectIdentifier)sqlProcedure.getContextResolveProcedure().getIdentifier().getIdentifier().get(), sqlProcedure.getContextResolveProcedure().getProcedure(), params, inputTypes, typeInferResult.getOutputDataType());
    }

    private List<RexNode> reduceOperands(FlinkSqlCallBinding sqlCallBinding, SqlNodeConverter.ConvertContext context) {
        RelDataType inputRowType = LogicalRelDataTypeConverter.toRelDataType(DataTypes.ROW().getLogicalType(), context.getSqlValidator().getTypeFactory());
        return context.reduceRexNodes(sqlCallBinding.operands().stream().map(node -> context.toRexNode((SqlNode)node, inputRowType, null)).collect(Collectors.toList()));
    }
}

