/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.hint;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSnapshot;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.hint.CapitalizeQueryHintsShuttle;
import org.apache.flink.table.planner.hint.ClearQueryHintsOnUnmatchedNodesShuttle;
import org.apache.flink.table.planner.hint.JoinStrategy;
import org.apache.flink.table.planner.hint.StateTtlHint;
import org.apache.flink.table.planner.plan.schema.FlinkPreparingTableBase;

public abstract class FlinkHints {
    public static final String HINT_NAME_OPTIONS = "OPTIONS";
    public static final String HINT_ALIAS = "ALIAS";
    public static final String LEFT_INPUT = "LEFT";
    public static final String RIGHT_INPUT = "RIGHT";
    public static final String HINT_NAME_JSON_AGGREGATE_WRAPPED = "JSON_AGGREGATE_WRAPPED";

    public static Map<String, String> getHintedOptions(List<RelHint> tableHints) {
        return tableHints.stream().filter(hint -> hint.hintName.equalsIgnoreCase(HINT_NAME_OPTIONS)).findFirst().map(hint -> hint.kvOptions).orElse(Collections.emptyMap());
    }

    public static Map<String, String> mergeTableOptions(Map<String, String> hints, Map<String, String> props) {
        if (hints.size() == 0) {
            return props;
        }
        HashMap<String, String> newProps = new HashMap<String, String>();
        newProps.putAll(props);
        newProps.putAll(hints);
        return Collections.unmodifiableMap(newProps);
    }

    public static Optional<String> getTableAlias(RelNode node) {
        if (node instanceof Hintable) {
            Hintable aliasNode = (Hintable)((Object)node);
            List aliasNames = aliasNode.getHints().stream().filter(h2 -> h2.hintName.equalsIgnoreCase(HINT_ALIAS)).flatMap(h2 -> h2.listOptions.stream()).collect(Collectors.toList());
            if (aliasNames.size() > 0) {
                return Optional.of(aliasNames.get(0));
            }
            if (FlinkHints.canTransposeToTableScan(node)) {
                return FlinkHints.getTableAlias(node.getInput(0));
            }
        }
        return Optional.empty();
    }

    public static boolean canTransposeToTableScan(RelNode node) {
        return node instanceof LogicalProject || node instanceof LogicalFilter || node instanceof LogicalSnapshot;
    }

    public static Optional<String> getTableName(RelOptTable table) {
        if (table == null) {
            return Optional.empty();
        }
        if (!(table instanceof FlinkPreparingTableBase)) {
            throw new TableException(String.format("Could not get the table name with the unknown table class `%s`", table.getClass().getCanonicalName()));
        }
        String tableName = StringUtils.join(((FlinkPreparingTableBase)table).getNames(), (char)'.');
        return Optional.of(tableName);
    }

    public static String stringifyHints(List<RelHint> hints) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (RelHint h2 : hints) {
            if (h2.hintName.equalsIgnoreCase(HINT_ALIAS)) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append(h2.hintName);
            if (h2.listOptions.size() > 0) {
                String listStr = h2.listOptions.stream().collect(Collectors.joining(",", "(", ")"));
                sb.append(listStr);
            } else if (h2.kvOptions.size() > 0) {
                String mapStr = h2.kvOptions.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(", ", "(", ")"));
                sb.append(mapStr);
            }
            first = false;
        }
        return sb.toString();
    }

    public static List<RelHint> getAllQueryHints(List<RelHint> allHints) {
        return allHints.stream().filter(hint -> JoinStrategy.isJoinStrategy(hint.hintName) || StateTtlHint.isStateTtlHint(hint.hintName)).collect(Collectors.toList());
    }

    public static List<RelHint> getAllJoinHints(List<RelHint> allHints) {
        return allHints.stream().filter(hint -> JoinStrategy.isJoinStrategy(hint.hintName)).collect(Collectors.toList());
    }

    public static List<RelHint> getAllStateTtlHints(List<RelHint> allHints) {
        return allHints.stream().filter(hint -> StateTtlHint.isStateTtlHint(hint.hintName)).collect(Collectors.toList());
    }

    public static List<RelHint> getQueryBlockAliasHints(List<RelHint> allHints) {
        return allHints.stream().filter(hint -> hint.hintName.equals(HINT_ALIAS)).collect(Collectors.toList());
    }

    public static RelNode capitalizeQueryHints(RelNode root) {
        return root.accept(new CapitalizeQueryHintsShuttle());
    }

    public static RelNode resolveSubQuery(RelNode node, Function<RelNode, RelNode> resolver) {
        if (node instanceof LogicalProject) {
            LogicalProject project = (LogicalProject)node;
            List newProjects = project.getProjects().stream().map(p -> FlinkHints.resolveSubQuery(p, resolver)).collect(Collectors.toList());
            return project.copy(project.getTraitSet(), project.getInput(), newProjects, project.getRowType());
        }
        if (node instanceof LogicalFilter) {
            LogicalFilter filter = (LogicalFilter)node;
            RexNode newCondition = FlinkHints.resolveSubQuery(filter.getCondition(), resolver);
            return filter.copy(filter.getTraitSet(), filter.getInput(), newCondition);
        }
        if (node instanceof LogicalJoin) {
            LogicalJoin join = (LogicalJoin)node;
            RexNode newCondition = FlinkHints.resolveSubQuery(join.getCondition(), resolver);
            return join.copy(join.getTraitSet(), newCondition, join.getLeft(), join.getRight(), join.getJoinType(), join.isSemiJoinDone());
        }
        return node;
    }

    private static RexNode resolveSubQuery(RexNode rexNode, final Function<RelNode, RelNode> resolver) {
        return rexNode.accept(new RexShuttle(){

            @Override
            public RexNode visitSubQuery(RexSubQuery subQuery) {
                RelNode oldRel = subQuery.rel;
                RelNode newRel = (RelNode)resolver.apply(oldRel);
                if (oldRel != newRel) {
                    return super.visitSubQuery(subQuery.clone(newRel));
                }
                return subQuery;
            }
        });
    }

    public static RelNode clearQueryHintsOnUnmatchedNodes(RelNode root) {
        return root.accept(new ClearQueryHintsOnUnmatchedNodesShuttle(root.getCluster().getHintStrategies()));
    }

    public static boolean isQueryHint(String hintName) {
        return JoinStrategy.isJoinStrategy(hintName) || StateTtlHint.isStateTtlHint(hintName);
    }

    public static boolean isAliasHint(String hintName) {
        return HINT_ALIAS.equalsIgnoreCase(hintName);
    }
}

