/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.analyze;

import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.AggregatePhaseStrategy;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.analyze.PlanAdvice;
import org.apache.flink.table.planner.analyze.PlanAnalyzer;
import org.apache.flink.table.planner.plan.nodes.FlinkRelNode;
import org.apache.flink.table.planner.plan.nodes.physical.FlinkPhysicalRel;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalGroupAggregate;
import org.apache.flink.table.planner.plan.rules.physical.stream.TwoStageOptimizedAggregateRule;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.planner.utils.TableConfigUtils;

@Internal
public class GroupAggregationAnalyzer
implements PlanAnalyzer {
    public static final GroupAggregationAnalyzer INSTANCE = new GroupAggregationAnalyzer();

    private GroupAggregationAnalyzer() {
    }

    @Override
    public Optional<PlanAnalyzer.AnalyzedResult> analyze(FlinkRelNode rel) {
        final TableConfig tableConfig = ShortcutUtils.unwrapTableConfig(rel);
        final ArrayList targetRelIds = new ArrayList();
        if (rel instanceof FlinkPhysicalRel) {
            rel.accept(new RelShuttleImpl(){

                @Override
                public RelNode visit(RelNode other) {
                    if (other instanceof StreamPhysicalGroupAggregate && ((TwoStageOptimizedAggregateRule)TwoStageOptimizedAggregateRule.INSTANCE()).matchesTwoStage((StreamPhysicalGroupAggregate)other, other.getInput(0).getInput(0))) {
                        targetRelIds.add(other.getId());
                    }
                    return super.visit(other);
                }
            });
            if (!targetRelIds.isEmpty()) {
                return Optional.of(new PlanAnalyzer.AnalyzedResult(){

                    @Override
                    public PlanAdvice getAdvice() {
                        return new PlanAdvice(PlanAdvice.Kind.ADVICE, PlanAdvice.Scope.NODE_LEVEL, GroupAggregationAnalyzer.this.getAdviceContent(tableConfig));
                    }

                    @Override
                    public List<Integer> getTargetIds() {
                        return targetRelIds;
                    }
                });
            }
        }
        return Optional.empty();
    }

    private String getAdviceContent(TableConfig tableConfig) {
        boolean isMiniBatchEnabled = (Boolean)tableConfig.get(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED);
        AggregatePhaseStrategy aggStrategy = TableConfigUtils.getAggPhaseStrategy((ReadableConfig)tableConfig);
        long miniBatchLatency = ((Duration)tableConfig.get(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY)).toMillis();
        long miniBatchSize = (Long)tableConfig.get(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE);
        LinkedHashMap<ConfigOption, String> tuningConfigs = new LinkedHashMap<ConfigOption, String>();
        if (aggStrategy == AggregatePhaseStrategy.ONE_PHASE) {
            tuningConfigs.put(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, String.format("'%s'", OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY.defaultValue()));
        }
        if (!isMiniBatchEnabled) {
            tuningConfigs.put(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, "'true'");
        }
        if (miniBatchLatency <= 0L) {
            tuningConfigs.put(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, "a positive long value");
        }
        if (miniBatchSize <= 0L) {
            tuningConfigs.put(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, "a positive long value");
        }
        return String.format("You might want to enable local-global two-phase optimization by configuring %s.", tuningConfigs.entrySet().stream().map(entry -> String.format("'%s' to %s", ((ConfigOption)entry.getKey()).key(), entry.getValue())).collect(Collectors.joining(", ", "(", ")")));
    }
}

