/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl.position;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.ddl.position.SqlColumnPosSpec;

public class SqlTableColumnPosition
extends SqlCall {
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("SqlTableColumnPosition", SqlKind.OTHER);
    private final SqlTableColumn column;
    @Nullable
    private final SqlLiteral positionSpec;
    @Nullable
    private final SqlIdentifier referencedColumn;

    public SqlTableColumnPosition(SqlParserPos pos, SqlTableColumn column, @Nullable SqlLiteral positionSpec, @Nullable SqlIdentifier referencedColumn) {
        super(pos);
        this.column = column;
        this.positionSpec = positionSpec;
        this.referencedColumn = referencedColumn;
    }

    public boolean isFirstColumn() {
        return this.positionSpec != null && this.positionSpec.getValueAs(SqlColumnPosSpec.class) == SqlColumnPosSpec.FIRST;
    }

    public boolean isAfterReferencedColumn() {
        return this.positionSpec != null && this.positionSpec.getValueAs(SqlColumnPosSpec.class) == SqlColumnPosSpec.AFTER && this.referencedColumn != null;
    }

    public SqlTableColumn getColumn() {
        return this.column;
    }

    public SqlLiteral getPositionSpec() {
        return this.positionSpec;
    }

    @Nullable
    public SqlIdentifier getAfterReferencedColumn() {
        return this.referencedColumn;
    }

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.column, this.positionSpec, this.referencedColumn);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.column.unparse(writer, leftPrec, rightPrec);
        if (this.isFirstColumn()) {
            this.positionSpec.unparse(writer, leftPrec, rightPrec);
        } else if (this.isAfterReferencedColumn()) {
            this.positionSpec.unparse(writer, leftPrec, rightPrec);
            this.referencedColumn.unparse(writer, leftPrec, rightPrec);
        }
    }
}

