/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.SqlUnparseUtils;
import org.apache.flink.sql.parser.ddl.SqlAlterMaterializedTable;

public class SqlAlterMaterializedTableResume
extends SqlAlterMaterializedTable {
    private final SqlNodeList propertyList;

    public SqlAlterMaterializedTableResume(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList propertyList) {
        super(pos, tableName);
        this.propertyList = Objects.requireNonNull(propertyList, "propertyList should not be null");
    }

    public SqlNodeList getPropertyList() {
        return this.propertyList;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.getTableName(), this.propertyList);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("RESUME");
        if (this.propertyList.size() > 0) {
            writer.newlineAndIndent();
            writer.keyword("WITH");
            SqlWriter.Frame withFrame = writer.startList("(", ")");
            for (SqlNode property : this.propertyList) {
                SqlUnparseUtils.printIndent(writer);
                property.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
    }
}

