/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlAlterFunction
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("ALTER FUNCTION", SqlKind.OTHER_DDL);
    private final SqlIdentifier functionIdentifier;
    private final SqlCharStringLiteral functionClassName;
    private final String functionLanguage;
    private final boolean ifExists;
    private final boolean isSystemFunction;
    private final boolean isTemporary;

    public SqlAlterFunction(SqlParserPos pos, SqlIdentifier functionIdentifier, SqlCharStringLiteral functionClassName, String functionLanguage, boolean ifExists, boolean isTemporary, boolean isSystemFunction) {
        super(pos);
        this.functionIdentifier = Objects.requireNonNull(functionIdentifier, "functionIdentifier should not be null");
        this.functionClassName = Objects.requireNonNull(functionClassName, "functionClassName should not be null");
        this.isSystemFunction = Objects.requireNonNull(isSystemFunction);
        this.isTemporary = isTemporary;
        this.functionLanguage = functionLanguage;
        this.ifExists = ifExists;
    }

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("ALTER");
        if (this.isTemporary) {
            writer.keyword("TEMPORARY");
        }
        if (this.isSystemFunction) {
            writer.keyword("SYSTEM");
        }
        writer.keyword("FUNCTION");
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.functionIdentifier.unparse(writer, leftPrec, rightPrec);
        writer.keyword("AS");
        this.functionClassName.unparse(writer, leftPrec, rightPrec);
        if (this.functionLanguage != null) {
            writer.keyword("LANGUAGE");
            writer.keyword(this.functionLanguage);
        }
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.functionIdentifier, this.functionClassName);
    }

    public String getFunctionLanguage() {
        return this.functionLanguage;
    }

    public SqlCharStringLiteral getFunctionClassName() {
        return this.functionClassName;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public boolean isSystemFunction() {
        return this.isSystemFunction;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    public String[] getFunctionIdentifier() {
        return this.functionIdentifier.names.toArray(new String[0]);
    }
}

