/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil;

public class FlinkRelUtil {
    public static boolean isMergeable(Filter topFilter, Calc bottomCalc) {
        RelDataType inputRowType = topFilter.getInput().getRowType();
        int inputFieldCnt = inputRowType.getFieldCount();
        int[] topInputRefCounter = FlinkRelUtil.initializeArray(inputFieldCnt, 0);
        RexProgram bottomProgram = bottomCalc.getProgram();
        ArrayList<RexNode> topProjects = new ArrayList<RexNode>();
        topProjects.add(topFilter.getCondition());
        for (int i = 0; i < inputFieldCnt; ++i) {
            topProjects.add(new RexInputRef(i, inputRowType.getFieldList().get(i).getType()));
        }
        List<RexNode> bottomProjects = bottomProgram.getProjectList().stream().map(bottomProgram::expandLocalRef).collect(Collectors.toList());
        return FlinkRelUtil.mergeable(topInputRefCounter, topProjects, bottomProjects);
    }

    public static boolean isMergeable(Project topProject, Calc bottomCalc) {
        int[] topInputRefCounter = FlinkRelUtil.initializeArray(topProject.getInput().getRowType().getFieldCount(), 0);
        RexProgram bottomProgram = bottomCalc.getProgram();
        List<RexNode> bottomProjects = bottomProgram.getProjectList().stream().map(bottomProgram::expandLocalRef).collect(Collectors.toList());
        return FlinkRelUtil.mergeable(topInputRefCounter, topProject.getProjects(), bottomProjects);
    }

    public static boolean isMergeable(Project topProject, Project bottomProject) {
        int[] topInputRefCounter = FlinkRelUtil.initializeArray(topProject.getInput().getRowType().getFieldCount(), 0);
        return FlinkRelUtil.mergeable(topInputRefCounter, topProject.getProjects(), bottomProject.getProjects());
    }

    public static boolean isMergeable(Calc topCalc, Calc bottomCalc) {
        RexProgram topProgram = topCalc.getProgram();
        RexProgram bottomProgram = bottomCalc.getProgram();
        int[] topInputRefCounter = FlinkRelUtil.initializeArray(topCalc.getInput().getRowType().getFieldCount(), 0);
        List<RexNode> topInputRefs = topProgram.getProjectList().stream().map(topProgram::expandLocalRef).collect(Collectors.toList());
        List<RexNode> bottomProjects = bottomProgram.getProjectList().stream().map(bottomProgram::expandLocalRef).collect(Collectors.toList());
        if (null != topProgram.getCondition()) {
            topInputRefs.add(topProgram.expandLocalRef(topProgram.getCondition()));
        }
        return FlinkRelUtil.mergeable(topInputRefCounter, topInputRefs, bottomProjects);
    }

    public static Calc merge(Calc topCalc, Calc bottomCalc) {
        RexProgram newMergedProgram;
        RexProgram topProgram = topCalc.getProgram();
        RexBuilder rexBuilder = topCalc.getCluster().getRexBuilder();
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms(topProgram, bottomCalc.getProgram(), rexBuilder);
        if (!mergedProgram.getOutputRowType().equals(topProgram.getOutputRowType())) {
            throw new IllegalArgumentException("Output row type of merged program is not the same top program.");
        }
        if (mergedProgram.getCondition() != null) {
            RexNode condition = mergedProgram.expandLocalRef(mergedProgram.getCondition());
            RexNode simplifiedCondition = FlinkRexUtil.simplify(rexBuilder, condition, topCalc.getCluster().getPlanner().getExecutor());
            if (simplifiedCondition.equals(condition)) {
                newMergedProgram = mergedProgram;
            } else {
                RexProgramBuilder programBuilder = RexProgramBuilder.forProgram(mergedProgram, rexBuilder, true);
                programBuilder.clearCondition();
                programBuilder.addCondition(simplifiedCondition);
                newMergedProgram = programBuilder.getProgram(true);
            }
        } else {
            newMergedProgram = mergedProgram;
        }
        return topCalc.copy(topCalc.getTraitSet(), bottomCalc.getInput(), newMergedProgram);
    }

    public static int[] initializeArray(int length, int initVal) {
        int[] array = new int[length];
        Arrays.fill(array, initVal);
        return array;
    }

    private static boolean mergeable(int[] topInputRefCounter, List<RexNode> topProjects, List<RexNode> bottomProjects) {
        RexUtil.apply((RexVisitor<Void>)new InputRefCounter(true, topInputRefCounter), topProjects, null);
        boolean mergeable = true;
        for (int idx = 0; idx < bottomProjects.size(); ++idx) {
            RexNode node = bottomProjects.get(idx);
            if (RexUtil.isDeterministic(node)) continue;
            assert (idx < topInputRefCounter.length);
            if (topInputRefCounter[idx] <= 1) continue;
            mergeable = false;
            break;
        }
        return mergeable;
    }

    private static class InputRefCounter
    extends RexVisitorImpl<Void> {
        final int[] refCounts;

        public InputRefCounter(boolean deep, int[] refCounts) {
            super(deep);
            this.refCounts = refCounts;
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            int index;
            int n = index = inputRef.getIndex();
            this.refCounts[n] = this.refCounts[n] + 1;
            return null;
        }
    }
}

