/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize.program;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkRuleSetProgram;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.utils.Logging;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0001\u0003\u0001M\u00111C\u00127j].\u001c\u0005.Y5oK\u0012\u0004&o\\4sC6T!a\u0001\u0003\u0002\u000fA\u0014xn\u001a:b[*\u0011QAB\u0001\t_B$\u0018.\\5{K*\u0011q\u0001C\u0001\u0005a2\fgN\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0006\r\u0003\u0015!\u0018M\u00197f\u0015\tia\"A\u0003gY&t7N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\u000b\u0003)\u0005\u001aB\u0001A\u000b\u001cUA\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\u00042\u0001H\u000f \u001b\u0005\u0011\u0011B\u0001\u0010\u0003\u0005Q1E.\u001b8l\u001fB$\u0018.\\5{KB\u0013xn\u001a:b[B\u0011\u0001%\t\u0007\u0001\t\u0015\u0011\u0003A1\u0001$\u0005\ty5)\u0005\u0002%OA\u0011a#J\u0005\u0003M]\u0011qAT8uQ&tw\r\u0005\u0002\u001dQ%\u0011\u0011F\u0001\u0002\u0015\r2Lgn[(qi&l\u0017N_3D_:$X\r\u001f;\u0011\u0005-rS\"\u0001\u0017\u000b\u00055B\u0011!B;uS2\u001c\u0018BA\u0018-\u0005\u001daunZ4j]\u001eDQ!\r\u0001\u0005\u0002I\na\u0001P5oSRtD#A\u001a\u0011\u0007q\u0001q\u0004C\u00046\u0001\t\u0007I\u0011\u0002\u001c\u0002\u0019A\u0014xn\u001a:b[:\u000bW.Z:\u0016\u0003]\u00022\u0001O\u001f@\u001b\u0005I$B\u0001\u001e<\u0003\u0011)H/\u001b7\u000b\u0003q\nAA[1wC&\u0011a(\u000f\u0002\n\u0003J\u0014\u0018-\u001f'jgR\u0004\"\u0001Q$\u000f\u0005\u0005+\u0005C\u0001\"\u0018\u001b\u0005\u0019%B\u0001#\u0013\u0003\u0019a$o\\8u}%\u0011aiF\u0001\u0007!J,G-\u001a4\n\u0005!K%AB*ue&twM\u0003\u0002G/!11\n\u0001Q\u0001\n]\nQ\u0002\u001d:pOJ\fWNT1nKN\u0004\u0003bB'\u0001\u0005\u0004%IAT\u0001\u000baJ|wM]1n\u001b\u0006\u0004X#A(\u0011\ta\u0002vhG\u0005\u0003#f\u0012q\u0001S1tQ6\u000b\u0007\u000f\u0003\u0004T\u0001\u0001\u0006IaT\u0001\faJ|wM]1n\u001b\u0006\u0004\b\u0005C\u0003\u0006\u0001\u0011\u0005Q\u000bF\u0002W=\u0002\u0004\"a\u0016/\u000e\u0003aS!!\u0017.\u0002\u0007I,GN\u0003\u0002\\\u001d\u000591-\u00197dSR,\u0017BA/Y\u0005\u001d\u0011V\r\u001c(pI\u0016DQa\u0018+A\u0002Y\u000bAA]8pi\")\u0011\r\u0016a\u0001?\u000591m\u001c8uKb$\b\"B2\u0001\t\u0003!\u0017aA4fiR\u0011Q\r\u001b\t\u0004-\u0019\\\u0012BA4\u0018\u0005\u0019y\u0005\u000f^5p]\")\u0011N\u0019a\u0001\u007f\u0005!a.Y7f\u0011\u0015Y\u0007\u0001\"\u0001m\u0003Y9W\r\u001e$mS:\\'+\u001e7f'\u0016$\bK]8he\u0006lGCA7r!\r1bM\u001c\t\u00049=|\u0012B\u00019\u0003\u0005M1E.\u001b8l%VdWmU3u!J|wM]1n\u0011\u0015I'\u000e1\u0001@\u0011\u0015\u0019\b\u0001\"\u0001u\u0003\u001d\tG\r\u001a'bgR$2!\u001e=z!\t1b/\u0003\u0002x/\t9!i\\8mK\u0006t\u0007\"B5s\u0001\u0004y\u0004\"B\u0002s\u0001\u0004Y\u0002\"B>\u0001\t\u0003a\u0018\u0001C1eI\u001aK'o\u001d;\u0015\u0007Ulh\u0010C\u0003ju\u0002\u0007q\bC\u0003\u0004u\u0002\u00071\u0004C\u0004\u0002\u0002\u0001!\t!a\u0001\u0002\u0013\u0005$GMQ3g_J,GcB;\u0002\u0006\u0005%\u00111\u0002\u0005\u0007\u0003\u000fy\b\u0019A \u0002\u00199\fW.Z(g\u0005\u00164wN]3\t\u000b%|\b\u0019A \t\u000b\ry\b\u0019A\u000e\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012\u00051!/Z7pm\u0016$2!ZA\n\u0011\u0019I\u0017Q\u0002a\u0001\u007f!9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0011aD4fiB\u0013xn\u001a:b[:\u000bW.Z:\u0016\u0005\u0005m\u0001\u0003\u0002\u001d\u0002\u001e}J1!a\b:\u0005\u0011a\u0015n\u001d;")
public class FlinkChainedProgram<OC extends FlinkOptimizeContext>
implements FlinkOptimizeProgram<OC>,
Logging {
    private final ArrayList<String> programNames;
    private final HashMap<String, FlinkOptimizeProgram<OC>> programMap;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        FlinkChainedProgram flinkChainedProgram = this;
        synchronized (flinkChainedProgram) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    private ArrayList<String> programNames() {
        return this.programNames;
    }

    private HashMap<String, FlinkOptimizeProgram<OC>> programMap() {
        return this.programMap;
    }

    @Override
    public RelNode optimize(RelNode root, OC context) {
        return (RelNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.programNames()).foldLeft((Object)root, (Function2 & Serializable & scala.Serializable)(input, name) -> {
            RelNode result;
            block0: {
                FlinkOptimizeProgram program = (FlinkOptimizeProgram)this.get((String)name).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new TableException("This should not happen.");
                });
                long start = System.currentTimeMillis();
                result = program.optimize((RelNode)input, context);
                long end = System.currentTimeMillis();
                if (!this.LOG().isDebugEnabled()) break block0;
                this.LOG().debug(new StringBuilder(20).append("optimize ").append((String)name).append(" cost ").append(end - start).append(" ms.\n").append(new StringBuilder(18).append("optimize result: \n").append(FlinkRelOptUtil$.MODULE$.toString(result, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7())).toString()).toString());
            }
            return result;
        });
    }

    public Option<FlinkOptimizeProgram<OC>> get(String name) {
        return Option$.MODULE$.apply(this.programMap().get(name));
    }

    public Option<FlinkRuleSetProgram<OC>> getFlinkRuleSetProgram(String name) {
        None$ none$;
        Object object = this.get(name).getOrElse((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
        if (object instanceof FlinkRuleSetProgram) {
            FlinkRuleSetProgram flinkRuleSetProgram = (FlinkRuleSetProgram)object;
            none$ = new Some((Object)flinkRuleSetProgram);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public boolean addLast(String name, FlinkOptimizeProgram<OC> program) {
        boolean bl;
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(program);
        if (this.programNames().contains(name)) {
            bl = false;
        } else {
            this.programNames().add(name);
            this.programMap().put(name, program);
            bl = true;
        }
        return bl;
    }

    public boolean addFirst(String name, FlinkOptimizeProgram<OC> program) {
        boolean bl;
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(program);
        if (this.programNames().contains(name)) {
            bl = false;
        } else {
            this.programNames().add(0, name);
            this.programMap().put(name, program);
            bl = true;
        }
        return bl;
    }

    public boolean addBefore(String nameOfBefore, String name, FlinkOptimizeProgram<OC> program) {
        boolean bl;
        Preconditions.checkNotNull((Object)nameOfBefore);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(program);
        if (this.programNames().contains(name) || !this.programNames().contains(nameOfBefore)) {
            bl = false;
        } else if (this.programNames().isEmpty()) {
            bl = this.addLast(name, program);
        } else {
            int index = this.programNames().indexOf(nameOfBefore);
            this.programNames().add(index, name);
            this.programMap().put(name, program);
            bl = true;
        }
        return bl;
    }

    public Option<FlinkOptimizeProgram<OC>> remove(String name) {
        this.programNames().remove(name);
        return Option$.MODULE$.apply(this.programMap().remove(name));
    }

    public List<String> getProgramNames() {
        return new ArrayList<String>(this.programNames());
    }

    public FlinkChainedProgram() {
        Logging.$init$(this);
        this.programNames = new ArrayList();
        this.programMap = new HashMap();
    }
}

