/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.Collections;
import java.util.HashMap;
import org.apache.calcite.sql.SqlNode;
import org.apache.flink.sql.parser.ddl.SqlReplaceTableAs;
import org.apache.flink.sql.parser.ddl.SqlTableOption;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.ReplaceTableAsOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.planner.operations.PlannerQueryOperation;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.utils.OperationConverterUtils;

public class SqlReplaceTableAsConverter
implements SqlNodeConverter<SqlReplaceTableAs> {
    @Override
    public Operation convertSqlNode(SqlReplaceTableAs sqlReplaceTableAs, SqlNodeConverter.ConvertContext context) {
        CatalogManager catalogManager = context.getCatalogManager();
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlReplaceTableAs.fullTableName());
        ObjectIdentifier identifier = catalogManager.qualifyIdentifier(unresolvedIdentifier);
        SqlNode asQuerySqlNode = sqlReplaceTableAs.getAsQuery();
        context.getSqlValidator().validate(asQuerySqlNode);
        PlannerQueryOperation query = new PlannerQueryOperation(context.toRelRoot(asQuerySqlNode).project(), () -> context.toQuotedSqlString(asQuerySqlNode));
        String tableComment = OperationConverterUtils.getTableComment(sqlReplaceTableAs.getComment());
        HashMap properties = new HashMap();
        sqlReplaceTableAs.getPropertyList().getList().forEach(p -> properties.put(((SqlTableOption)p).getKeyString(), ((SqlTableOption)p).getValueString()));
        CatalogTable catalogTable = CatalogTable.of((Schema)Schema.newBuilder().fromResolvedSchema(query.getResolvedSchema()).build(), (String)tableComment, Collections.emptyList(), properties);
        CreateTableOperation createTableOperation = new CreateTableOperation(identifier, catalogTable, sqlReplaceTableAs.isIfNotExists(), sqlReplaceTableAs.isTemporary());
        return new ReplaceTableAsOperation(createTableOperation, (QueryOperation)query, sqlReplaceTableAs.isCreateOrReplace());
    }
}

