/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods;
import org.apache.flink.table.planner.functions.casting.AbstractExpressionCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

class TimestampToTimestampCastRule
extends AbstractExpressionCodeGeneratorCastRule<TimestampData, TimestampData> {
    static final TimestampToTimestampCastRule INSTANCE = new TimestampToTimestampCastRule();

    private TimestampToTimestampCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE).input(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).target(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE).target(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).build());
    }

    @Override
    public String generateExpression(CodeGeneratorCastRule.Context context, String inputTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        int inputPrecision = LogicalTypeChecks.getPrecision((LogicalType)inputLogicalType);
        int targetPrecision = LogicalTypeChecks.getPrecision((LogicalType)targetLogicalType);
        if (inputLogicalType.is(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE) && targetLogicalType.is(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)) {
            TimestampKind inputTimestampKind = ((TimestampType)inputLogicalType).getKind();
            TimestampKind targetTimestampKind = ((TimestampType)targetLogicalType).getKind();
            if (inputTimestampKind == TimestampKind.ROWTIME || inputTimestampKind == TimestampKind.PROCTIME || targetTimestampKind == TimestampKind.ROWTIME || targetTimestampKind == TimestampKind.PROCTIME) {
                targetPrecision = 3;
            }
        }
        String operand = inputLogicalType.is(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE) && targetLogicalType.is(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE) ? CastRuleUtils.staticCall(BuiltInMethods.TIMESTAMP_TO_TIMESTAMP_WITH_LOCAL_ZONE(), inputTerm, context.getSessionTimeZoneTerm()) : (inputLogicalType.is(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE) && targetLogicalType.is(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE) ? CastRuleUtils.staticCall(BuiltInMethods.TIMESTAMP_WITH_LOCAL_ZONE_TO_TIMESTAMP(), inputTerm, context.getSessionTimeZoneTerm()) : inputTerm);
        if (inputPrecision <= targetPrecision) {
            return operand;
        }
        return CastRuleUtils.staticCall(BuiltInMethods.TRUNCATE_SQL_TIMESTAMP(), operand, targetPrecision);
    }
}

