/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCallBinding;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.SqlOperandMetadata;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class FlinkOperatorBinding
extends SqlOperatorBinding {
    private final SqlOperatorBinding sqlOperatorBinding;
    private final List<RelDataType> argumentTypes;

    public FlinkOperatorBinding(SqlOperatorBinding sqlOperatorBinding) {
        super(sqlOperatorBinding.getTypeFactory(), sqlOperatorBinding.getOperator());
        this.sqlOperatorBinding = sqlOperatorBinding;
        this.argumentTypes = this.getArgumentTypes();
    }

    @Override
    public int getOperandCount() {
        if (!this.argumentTypes.isEmpty()) {
            return this.argumentTypes.size();
        }
        return this.sqlOperatorBinding.getOperandCount();
    }

    @Override
    public RelDataType getOperandType(int ordinal) {
        if (this.sqlOperatorBinding instanceof SqlCallBinding) {
            SqlNode sqlNode = ((SqlCallBinding)this.sqlOperatorBinding).operands().get(ordinal);
            if (sqlNode.getKind() == SqlKind.DEFAULT && !this.argumentTypes.isEmpty()) {
                return this.argumentTypes.get(ordinal);
            }
            return ((SqlCallBinding)this.sqlOperatorBinding).getValidator().deriveType(((SqlCallBinding)this.sqlOperatorBinding).getScope(), sqlNode);
        }
        if (this.sqlOperatorBinding instanceof RexCallBinding) {
            RexNode rexNode = ((RexCallBinding)this.sqlOperatorBinding).operands().get(ordinal);
            if (rexNode.getKind() == SqlKind.DEFAULT && !this.argumentTypes.isEmpty()) {
                return this.argumentTypes.get(ordinal);
            }
            return rexNode.getType();
        }
        return this.sqlOperatorBinding.getOperandType(ordinal);
    }

    @Override
    public CalciteException newError(Resources.ExInst<SqlValidatorException> e) {
        return this.sqlOperatorBinding.newError(e);
    }

    @Override
    public int getGroupCount() {
        return this.sqlOperatorBinding.getGroupCount();
    }

    @Override
    public boolean hasFilter() {
        return this.sqlOperatorBinding.hasFilter();
    }

    @Override
    public SqlOperator getOperator() {
        return this.sqlOperatorBinding.getOperator();
    }

    @Override
    public RelDataTypeFactory getTypeFactory() {
        return this.sqlOperatorBinding.getTypeFactory();
    }

    @Override
    public @Nullable String getStringLiteralOperand(int ordinal) {
        return this.sqlOperatorBinding.getStringLiteralOperand(ordinal);
    }

    @Override
    public int getIntLiteralOperand(int ordinal) {
        return this.sqlOperatorBinding.getIntLiteralOperand(ordinal);
    }

    @Override
    public boolean isOperandNull(int ordinal, boolean allowCast) {
        return this.sqlOperatorBinding.isOperandNull(ordinal, allowCast);
    }

    @Override
    public boolean isOperandLiteral(int ordinal, boolean allowCast) {
        return this.sqlOperatorBinding.isOperandLiteral(ordinal, allowCast);
    }

    @Override
    public @Nullable Object getOperandLiteralValue(int ordinal, RelDataType type) {
        return this.sqlOperatorBinding.getOperandLiteralValue(ordinal, type);
    }

    @Override
    public @Nullable Comparable getOperandLiteralValue(int ordinal) {
        return this.sqlOperatorBinding.getOperandLiteralValue(ordinal);
    }

    @Override
    public SqlMonotonicity getOperandMonotonicity(int ordinal) {
        return this.sqlOperatorBinding.getOperandMonotonicity(ordinal);
    }

    @Override
    public List<RelDataType> collectOperandTypes() {
        return this.sqlOperatorBinding.collectOperandTypes();
    }

    @Override
    public @Nullable RelDataType getCursorOperand(int ordinal) {
        return this.sqlOperatorBinding.getCursorOperand(ordinal);
    }

    @Override
    public @Nullable String getColumnListParamInfo(int ordinal, String paramName, List<String> columnList) {
        return this.sqlOperatorBinding.getColumnListParamInfo(ordinal, paramName, columnList);
    }

    @Override
    public <T> @Nullable T getOperandLiteralValue(int ordinal, Class<T> clazz) {
        return this.sqlOperatorBinding.getOperandLiteralValue(ordinal, clazz);
    }

    private List<RelDataType> getArgumentTypes() {
        SqlOperandTypeChecker sqlOperandTypeChecker = this.getOperator().getOperandTypeChecker();
        if (sqlOperandTypeChecker != null && sqlOperandTypeChecker.isFixedParameters() && sqlOperandTypeChecker instanceof SqlOperandMetadata) {
            SqlOperandMetadata sqlOperandMetadata = (SqlOperandMetadata)this.getOperator().getOperandTypeChecker();
            return sqlOperandMetadata.paramTypes(this.getTypeFactory());
        }
        return Collections.emptyList();
    }
}

