/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptQuery;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.hint.HintStrategyTable;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.MetadataFactory;
import org.apache.calcite.rel.metadata.MetadataFactoryImpl;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.metadata.RelMetadataQueryBase;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class RelOptCluster {
    private final RelDataTypeFactory typeFactory;
    private final RelOptPlanner planner;
    private final AtomicInteger nextCorrel;
    private final Map<String, RelNode> mapCorrelToRel;
    private RexNode originalExpression;
    private final RexBuilder rexBuilder;
    private RelMetadataProvider metadataProvider;
    @Deprecated
    private MetadataFactory metadataFactory;
    private @Nullable HintStrategyTable hintStrategies;
    private final RelTraitSet emptyTraitSet;
    private @Nullable RelMetadataQuery mq;
    private Supplier<RelMetadataQuery> mqSupplier;

    @Deprecated
    RelOptCluster(RelOptQuery query, RelOptPlanner planner, RelDataTypeFactory typeFactory, RexBuilder rexBuilder) {
        this(planner, typeFactory, rexBuilder, query.nextCorrel, query.mapCorrelToRel);
    }

    RelOptCluster(RelOptPlanner planner, RelDataTypeFactory typeFactory, RexBuilder rexBuilder, AtomicInteger nextCorrel, Map<String, RelNode> mapCorrelToRel) {
        this.nextCorrel = nextCorrel;
        this.mapCorrelToRel = mapCorrelToRel;
        this.planner = Objects.requireNonNull(planner, "planner");
        this.typeFactory = Objects.requireNonNull(typeFactory, "typeFactory");
        this.rexBuilder = rexBuilder;
        this.originalExpression = rexBuilder.makeLiteral("?");
        this.setMetadataProvider(DefaultRelMetadataProvider.INSTANCE);
        this.setMetadataQuerySupplier(RelMetadataQuery::instance);
        this.emptyTraitSet = planner.emptyTraitSet();
        assert (this.emptyTraitSet.size() == planner.getRelTraitDefs().size());
    }

    public static RelOptCluster create(RelOptPlanner planner, RexBuilder rexBuilder) {
        return new RelOptCluster(planner, rexBuilder.getTypeFactory(), rexBuilder, new AtomicInteger(0), new HashMap<String, RelNode>());
    }

    @Deprecated
    public RelOptQuery getQuery() {
        return new RelOptQuery(Nullness.castNonNull(this.planner), this.nextCorrel, this.mapCorrelToRel);
    }

    @Deprecated
    public RexNode getOriginalExpression() {
        return this.originalExpression;
    }

    @Deprecated
    public void setOriginalExpression(RexNode originalExpression) {
        this.originalExpression = originalExpression;
    }

    public RelOptPlanner getPlanner() {
        return this.planner;
    }

    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public RexBuilder getRexBuilder() {
        return this.rexBuilder;
    }

    public @Nullable RelMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    @EnsuresNonNull(value={"this.metadataProvider", "this.metadataFactory"})
    public void setMetadataProvider(@UnknownInitialization RelOptCluster this, RelMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
        this.metadataFactory = new MetadataFactoryImpl(metadataProvider);
        RelMetadataQueryBase.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.of(metadataProvider));
    }

    @Deprecated
    public MetadataFactory getMetadataFactory() {
        return this.metadataFactory;
    }

    @EnsuresNonNull(value={"this.mqSupplier"})
    public void setMetadataQuerySupplier(@UnknownInitialization RelOptCluster this, Supplier<RelMetadataQuery> mqSupplier) {
        this.mqSupplier = mqSupplier;
    }

    public RelMetadataQuery getMetadataQuery() {
        if (this.mq == null) {
            this.mq = Nullness.castNonNull(this.mqSupplier).get();
        }
        return this.mq;
    }

    public Supplier<RelMetadataQuery> getMetadataQuerySupplier() {
        return this.mqSupplier;
    }

    public void invalidateMetadataQuery() {
        this.mq = null;
    }

    public void setHintStrategies(HintStrategyTable hintStrategies) {
        Objects.requireNonNull(hintStrategies, "hintStrategies");
        this.hintStrategies = hintStrategies;
    }

    public HintStrategyTable getHintStrategies() {
        if (this.hintStrategies == null) {
            this.hintStrategies = HintStrategyTable.EMPTY;
        }
        return this.hintStrategies;
    }

    public CorrelationId createCorrel() {
        return new CorrelationId(this.nextCorrel.getAndIncrement());
    }

    public RelTraitSet traitSet() {
        return this.emptyTraitSet;
    }

    @Deprecated
    public RelTraitSet traitSetOf(RelTrait ... traits) {
        RelTraitSet traitSet = this.emptyTraitSet;
        for (RelTrait trait : traits) {
            traitSet = traitSet.replace(trait);
        }
        return traitSet;
    }

    public RelTraitSet traitSetOf(RelTrait trait) {
        return this.emptyTraitSet.replace(trait);
    }
}

