/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.reuse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.flink.table.planner.plan.nodes.physical.common.CommonPhysicalTableSourceScan;
import org.apache.flink.table.planner.plan.reuse.ScanReuserUtils;

public class ReusableScanVisitor
extends RelVisitor {
    private final Map<String, List<CommonPhysicalTableSourceScan>> digestToReusableScans = new HashMap<String, List<CommonPhysicalTableSourceScan>>();

    @Override
    public void visit(RelNode node, int ordinal, RelNode parent) {
        if (node instanceof CommonPhysicalTableSourceScan) {
            CommonPhysicalTableSourceScan scan = (CommonPhysicalTableSourceScan)node;
            String digest = ScanReuserUtils.getDigest(scan, true);
            this.digestToReusableScans.computeIfAbsent(digest, k -> new ArrayList()).add(scan);
            if (!scan.getInputs().isEmpty()) {
                super.visit(scan.getInput(0), 0, scan);
            }
        } else {
            super.visit(node, ordinal, parent);
        }
    }

    public Map<String, List<CommonPhysicalTableSourceScan>> digestToReusableScans() {
        return this.digestToReusableScans;
    }
}

