/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.reuse;

import java.util.Map;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Calc;
import org.apache.flink.table.planner.plan.nodes.physical.common.CommonPhysicalTableSourceScan;
import org.apache.flink.table.planner.plan.utils.DefaultRelShuttle;
import org.apache.flink.table.planner.plan.utils.FlinkRelUtil;

public class ReplaceScanWithCalcShuttle
extends DefaultRelShuttle {
    private final Map<CommonPhysicalTableSourceScan, RelNode> replaceMap;

    public ReplaceScanWithCalcShuttle(Map<CommonPhysicalTableSourceScan, RelNode> replaceMap) {
        this.replaceMap = replaceMap;
    }

    @Override
    public RelNode visit(RelNode rel) {
        RelNode newNode;
        if (rel instanceof Calc && rel.getInput(0) instanceof CommonPhysicalTableSourceScan) {
            Calc calc = (Calc)rel;
            RelNode input = calc.getInput();
            RelNode newNode2 = this.replaceMap.get(input);
            if (newNode2 instanceof Calc && FlinkRelUtil.isMergeable(calc, (Calc)newNode2)) {
                return FlinkRelUtil.merge(calc, (Calc)newNode2);
            }
        } else if (rel instanceof CommonPhysicalTableSourceScan && (newNode = this.replaceMap.get(rel)) != null) {
            return newNode;
        }
        return super.visit(rel);
    }
}

