/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.logical.WindowAttachedWindowingStrategy;
import org.apache.flink.table.planner.plan.logical.WindowingStrategy;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.deduplicate.window.RowTimeWindowDeduplicateOperatorBuilder;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowAggOperator;
import org.apache.flink.table.runtime.typeutils.AbstractRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.PagedTypeSerializer;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@ExecNodeMetadata(name="stream-exec-window-deduplicate", version=1, consumedOptions={"table.local-time-zone"}, producedTransformations={"window-deduplicate"}, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)
public class StreamExecWindowDeduplicate
extends ExecNodeBase<RowData>
implements StreamExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    public static final String WINDOW_DEDUPLICATE_TRANSFORMATION = "window-deduplicate";
    private static final long WINDOW_RANK_MEMORY_RATIO = 100L;
    public static final String FIELD_NAME_PARTITION_KEYS = "partitionKeys";
    public static final String FIELD_NAME_ORDER_KEY = "orderKey";
    public static final String FIELD_NAME_KEEP_LAST_ROW = "keepLastRow";
    public static final String FIELD_NAME_WINDOWING = "windowing";
    @JsonProperty(value="partitionKeys")
    private final int[] partitionKeys;
    @JsonProperty(value="orderKey")
    private final int orderKey;
    @JsonProperty(value="keepLastRow")
    private final boolean keepLastRow;
    @JsonProperty(value="windowing")
    private final WindowingStrategy windowing;

    public StreamExecWindowDeduplicate(ReadableConfig tableConfig, int[] partitionKeys, int orderKey, boolean keepLastRow, WindowingStrategy windowing, InputProperty inputProperty, RowType outputType, String description) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecWindowDeduplicate.class), ExecNodeContext.newPersistedConfig(StreamExecWindowDeduplicate.class, tableConfig), partitionKeys, orderKey, keepLastRow, windowing, Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecWindowDeduplicate(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="partitionKeys") int[] partitionKeys, @JsonProperty(value="orderKey") int orderKey, @JsonProperty(value="keepLastRow") boolean keepLastRow, @JsonProperty(value="windowing") WindowingStrategy windowing, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 1 ? 1 : 0) != 0);
        this.partitionKeys = (int[])Preconditions.checkNotNull((Object)partitionKeys);
        this.orderKey = orderKey;
        this.keepLastRow = keepLastRow;
        this.windowing = (WindowingStrategy)Preconditions.checkNotNull((Object)windowing);
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        if (!this.windowing.isRowtime()) {
            throw new TableException("Processing time Window Deduplication is not supported yet.");
        }
        if (!(this.windowing instanceof WindowAttachedWindowingStrategy)) {
            throw new UnsupportedOperationException(this.windowing.getClass().getName() + " is not supported yet.");
        }
        int windowEndIndex = ((WindowAttachedWindowingStrategy)this.windowing).getWindowEnd();
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        ZoneId shiftTimeZone = TimeWindowUtil.getShiftTimeZone((LogicalType)this.windowing.getTimeAttributeType(), (ZoneId)TableConfigUtils.getLocalTimeZone(config));
        RowType inputType = (RowType)inputEdge.getOutputType();
        RowDataKeySelector selector = KeySelectorUtil.getRowDataSelector(planner.getFlinkContext().getClassLoader(), this.partitionKeys, (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)inputType));
        WindowAggOperator operator = RowTimeWindowDeduplicateOperatorBuilder.builder().inputSerializer((AbstractRowDataSerializer)new RowDataSerializer(inputType)).shiftTimeZone(shiftTimeZone).keySerializer((PagedTypeSerializer)selector.getProducedType().toSerializer()).keepLastRow(this.keepLastRow).rowtimeIndex(this.orderKey).windowEndIndex(windowEndIndex).build();
        OneInputTransformation transform = ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta(WINDOW_DEDUPLICATE_TRANSFORMATION, config), SimpleOperatorFactory.of((StreamOperator)operator), InternalTypeInfo.of((LogicalType)this.getOutputType()), inputTransform.getParallelism(), 100L, false);
        transform.setStateKeySelector((KeySelector)selector);
        transform.setStateKeyType((TypeInformation)selector.getProducedType());
        return transform;
    }
}

