/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.Collections;
import java.util.UUID;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.InputFormatSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecDynamicFilteringDataCollector;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecExchange;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DynamicTableSourceSpec;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class BatchExecTableSourceScan
extends CommonExecTableSourceScan
implements BatchExecNode<RowData> {
    private final String dynamicFilteringDataListenerID = UUID.randomUUID().toString();
    private final ReadableConfig tableConfig;

    public BatchExecTableSourceScan(ReadableConfig tableConfig, DynamicTableSourceSpec tableSourceSpec, InputProperty inputProperty, RowType outputType, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecTableSourceScan.class), ExecNodeContext.newPersistedConfig(BatchExecTableSourceScan.class, tableConfig), tableSourceSpec, Collections.singletonList(inputProperty), (LogicalType)outputType, description);
        this.tableConfig = tableConfig;
    }

    public BatchExecTableSourceScan(ReadableConfig tableConfig, DynamicTableSourceSpec tableSourceSpec, RowType outputType, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecTableSourceScan.class), ExecNodeContext.newPersistedConfig(BatchExecTableSourceScan.class, tableConfig), tableSourceSpec, Collections.emptyList(), (LogicalType)outputType, description);
        this.tableConfig = tableConfig;
    }

    public String getDynamicFilteringDataListenerID() {
        return this.dynamicFilteringDataListenerID;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        Transformation<RowData> transformation = super.translateToPlanInternal(planner, config);
        ExecNodeUtil.makeLegacySourceTransformationsBounded(transformation);
        return transformation;
    }

    public static BatchExecDynamicFilteringDataCollector getDynamicFilteringDataCollector(BatchExecNode<?> node) {
        Preconditions.checkState((node.getInputEdges().size() == 1 ? 1 : 0) != 0, (Object)"The fact source must have one input representing dynamic filtering data collector");
        BatchExecNode input = (BatchExecNode)node.getInputEdges().get(0).getSource();
        if (input instanceof BatchExecDynamicFilteringDataCollector) {
            return (BatchExecDynamicFilteringDataCollector)input;
        }
        Preconditions.checkState((boolean)(input instanceof BatchExecExchange), (Object)"There could only be BatchExecExchange between fact source and dynamic filtering data collector");
        return BatchExecTableSourceScan.getDynamicFilteringDataCollector(input);
    }

    @Override
    public Transformation<RowData> createInputFormatTransformation(StreamExecutionEnvironment env, InputFormat<RowData, ?> inputFormat, InternalTypeInfo<RowData> outputTypeInfo, String operatorName) {
        InputFormatSourceFunction function = new InputFormatSourceFunction(inputFormat, outputTypeInfo);
        return env.addSource((SourceFunction)function, operatorName, outputTypeInfo).getTransformation();
    }

    public BatchExecTableSourceScan copyAndRemoveInputs() {
        BatchExecTableSourceScan tableSourceScan = new BatchExecTableSourceScan(this.tableConfig, this.getTableSourceSpec(), (RowType)this.getOutputType(), this.getDescription());
        tableSourceScan.setInputEdges(Collections.emptyList());
        return tableSourceScan;
    }
}

