/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.logical;

import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.planner.plan.logical.WindowSpec;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TimeUtils;

@JsonTypeName(value="TumblingWindow")
public class TumblingWindowSpec
implements WindowSpec {
    public static final String FIELD_NAME_SIZE = "size";
    public static final String FIELD_NAME_OFFSET = "offset";
    @JsonProperty(value="size")
    private final Duration size;
    @JsonProperty(value="offset")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    private final Duration offset;

    @JsonCreator
    public TumblingWindowSpec(@JsonProperty(value="size") Duration size, @JsonProperty(value="offset") @Nullable Duration offset) {
        this.size = (Duration)Preconditions.checkNotNull((Object)size);
        this.offset = offset;
    }

    @Override
    public String toSummaryString(String windowing, String[] inputFieldNames) {
        if (this.offset == null) {
            return String.format("TUMBLE(%s, size=[%s])", windowing, TimeUtils.formatWithHighestUnit((Duration)this.size));
        }
        return String.format("TUMBLE(%s, size=[%s], offset=[%s])", windowing, TimeUtils.formatWithHighestUnit((Duration)this.size), TimeUtils.formatWithHighestUnit((Duration)this.offset));
    }

    public Duration getSize() {
        return this.size;
    }

    public Duration getOffset() {
        return this.offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TumblingWindowSpec that = (TumblingWindowSpec)o;
        return this.size.equals(that.size) && Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        return Objects.hash(TumblingWindowSpec.class, this.size, this.offset);
    }

    public String toString() {
        if (this.offset == null) {
            return String.format("TUMBLE(size=[%s])", TimeUtils.formatWithHighestUnit((Duration)this.size));
        }
        return String.format("TUMBLE(size=[%s], offset=[%s])", TimeUtils.formatWithHighestUnit((Duration)this.size), TimeUtils.formatWithHighestUnit((Duration)this.offset));
    }

    @Override
    public boolean isAlignedWindow() {
        return true;
    }
}

