/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.internal.ResultProvider;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.data.conversion.RowRowConverter;
import org.apache.flink.table.operations.CallProcedureOperation;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.functions.casting.RowDataToStringConverterImpl;
import org.apache.flink.table.procedure.DefaultProcedureContext;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.flink.table.procedures.Procedure;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.utils.print.RowDataToStringConverter;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlannerCallProcedureOperation
implements CallProcedureOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlannerCallProcedureOperation.class);
    private final ObjectIdentifier procedureIdentifier;
    private final Procedure procedure;
    private final Object[] internalInputArguments;
    private final DataType[] inputTypes;
    private final DataType outputType;

    public PlannerCallProcedureOperation(ObjectIdentifier procedureIdentifier, Procedure procedure, Object[] internalInputArguments, DataType[] inputTypes, DataType outputType) {
        this.procedureIdentifier = procedureIdentifier;
        this.procedure = procedure;
        this.internalInputArguments = internalInputArguments;
        this.inputTypes = inputTypes;
        this.outputType = outputType;
    }

    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        TableConfig tableConfig = ctx.getTableConfig();
        URLClassLoader userClassLoader = ctx.getResourceManager().getUserClassLoader();
        Class[] argumentClz = new Class[1 + this.inputTypes.length];
        argumentClz[0] = ProcedureContext.class;
        for (int i = 0; i < this.inputTypes.length; ++i) {
            argumentClz[i + 1] = this.inputTypes[i].getConversionClass();
        }
        Object[] argumentVal = this.getConvertedArgumentValues(tableConfig, userClassLoader);
        Object procedureResult = this.callProcedure(this.procedure, argumentClz, argumentVal);
        return this.procedureResultToTableResult(procedureResult, tableConfig, userClassLoader);
    }

    private Object[] getConvertedArgumentValues(TableConfig tableConfig, ClassLoader userClassLoader) {
        Object[] argumentVal = new Object[1 + this.internalInputArguments.length];
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)tableConfig.getConfiguration());
        argumentVal[0] = new DefaultProcedureContext(env);
        for (int i = 0; i < this.internalInputArguments.length; ++i) {
            argumentVal[i + 1] = this.internalInputArguments[i] != null ? this.toExternal(this.internalInputArguments[i], this.inputTypes[i], userClassLoader) : null;
        }
        return argumentVal;
    }

    private Object toExternal(Object internalValue, DataType inputType, ClassLoader classLoader) {
        if (!DataTypeUtils.isInternal((DataType)inputType)) {
            DataStructureConverter converter = DataStructureConverters.getConverter((DataType)inputType);
            converter.open(classLoader);
            return converter.toExternal(internalValue);
        }
        return internalValue;
    }

    private Object callProcedure(Procedure procedure, Class<?>[] inputClz, Object[] inputArgs) {
        String callMethodName = "call";
        List methods = ExtractionUtils.collectMethods(procedure.getClass(), (String)callMethodName);
        List callMethods = methods.stream().filter(method -> ExtractionUtils.isInvokable((Executable)method, (Class[])inputClz) && method.getReturnType().isArray() && ExtractionUtils.isAssignable((Class)this.outputType.getConversionClass(), method.getReturnType().getComponentType(), (boolean)true)).collect(Collectors.toList());
        if (callMethods.isEmpty()) {
            throw new ValidationException(String.format("Could not find an implementation method '%s' in class '%s' for procedure '%s' that matches the following signature:\n%s", callMethodName, procedure.getClass().getName(), this.procedureIdentifier, ExtractionUtils.createMethodSignatureString((String)callMethodName, (Class[])inputClz, (Class)this.outputType.getConversionClass())));
        }
        if (callMethods.size() > 1) {
            LOGGER.warn("There are multiple methods matching the procedure calling: {}.  Only invoke the first method: {}.", (Object)methods, methods.get(0));
        }
        return this.invokeCallMethod(procedure, (Method)callMethods.get(0), inputArgs);
    }

    private Object invokeCallMethod(Procedure procedure, Method calMethod, Object[] inputArgs) {
        try {
            if (calMethod.isVarArgs()) {
                int paramCount = calMethod.getParameterCount();
                int varargsIndex = paramCount - 1;
                Object[] newInputArgs = new Object[paramCount];
                System.arraycopy(inputArgs, 0, newInputArgs, 0, varargsIndex);
                Class<?> varargsElementType = calMethod.getParameterTypes()[varargsIndex].getComponentType();
                int varargsLength = inputArgs.length - varargsIndex;
                Object varargs = Array.newInstance(varargsElementType, varargsLength);
                System.arraycopy(inputArgs, varargsIndex, varargs, 0, varargsLength);
                newInputArgs[varargsIndex] = varargs;
                inputArgs = newInputArgs;
            }
            LOGGER.info("Invoke method {} with arguments: {}.", (Object)calMethod, (Object)inputArgs);
            return calMethod.invoke((Object)procedure, inputArgs);
        }
        catch (IllegalAccessException e) {
            throw new TableException(String.format("Access to the method %s was denied: %s.", "call", e.getMessage()), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable exceptionInMethod = e.getTargetException();
            throw new TableException(String.format("The %s method caused an error: %s.", "call", exceptionInMethod.getMessage()), (Throwable)e);
        }
        catch (Throwable t) {
            throw new TableException(String.format("An error occurred while invoking the procedure's %s method: %s.", "call", t.getMessage()), t);
        }
    }

    private TableResultInternal procedureResultToTableResult(Object procedureResult, TableConfig tableConfig, ClassLoader userClassLoader) {
        ZoneId zoneId = tableConfig.getLocalTimeZone();
        DataType tableResultType = this.outputType;
        if (!LogicalTypeChecks.isCompositeType((LogicalType)this.outputType.getLogicalType())) {
            tableResultType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"result", (DataType)tableResultType)});
        }
        RowRowConverter rowConverter = null;
        if (this.outputType.getLogicalType().getTypeRoot() == LogicalTypeRoot.STRUCTURED_TYPE) {
            rowConverter = RowRowConverter.create((DataType)tableResultType);
            rowConverter.open(userClassLoader);
        }
        ResolvedSchema resultSchema = DataTypeUtils.expandCompositeTypeToSchema((DataType)tableResultType);
        RowDataToStringConverterImpl rowDataToStringConverter = new RowDataToStringConverterImpl(tableResultType, zoneId, userClassLoader, ((ExecutionConfigOptions.LegacyCastBehaviour)tableConfig.get(ExecutionConfigOptions.TABLE_EXEC_LEGACY_CAST_BEHAVIOUR)).isEnabled(), new CodeGeneratorContext((ReadableConfig)tableConfig, userClassLoader));
        DataStructureConverter converter = DataStructureConverters.getConverter((DataType)this.outputType);
        converter.open(userClassLoader);
        return TableResultImpl.builder().resultProvider((ResultProvider)new CallProcedureResultProvider((DataStructureConverter<Object, Object>)converter, rowDataToStringConverter, rowConverter, procedureResult)).schema(resultSchema).resultKind(ResultKind.SUCCESS_WITH_CONTENT).build();
    }

    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("procedureIdentifier", this.procedureIdentifier);
        params.put("inputTypes", this.inputTypes);
        params.put("outputTypes", this.outputType);
        params.put("arguments", this.internalInputArguments);
        return OperationUtils.formatWithChildren((String)"CALL PROCEDURE", params, Collections.emptyList(), Operation::asSummaryString);
    }

    static final class CallProcedureResultProvider
    implements ResultProvider {
        private final DataStructureConverter<Object, Object> converter;
        private final RowDataToStringConverter toStringConverter;
        @Nullable
        private final RowRowConverter rowConverter;
        private final Object[] result;

        public CallProcedureResultProvider(DataStructureConverter<Object, Object> converter, RowDataToStringConverter toStringConverter, @Nullable RowRowConverter rowConverter, Object result) {
            this.converter = converter;
            this.toStringConverter = toStringConverter;
            this.result = this.toResultArray(result);
            this.rowConverter = rowConverter;
        }

        public ResultProvider setJobClient(JobClient jobClient) {
            return this;
        }

        public CloseableIterator<RowData> toInternalIterator() {
            final Iterator objectIterator = Arrays.stream(this.result).iterator();
            return new CloseableIterator<RowData>(){

                public boolean hasNext() {
                    return objectIterator.hasNext();
                }

                public RowData next() {
                    return this.toRowData(objectIterator.next());
                }

                public void close() {
                }
            };
        }

        private RowData toRowData(Object externalValue) {
            Object element = this.converter.toInternalOrNull(externalValue);
            if (!(element instanceof RowData)) {
                return GenericRowData.of((Object[])new Object[]{element});
            }
            return (RowData)element;
        }

        public CloseableIterator<Row> toExternalIterator() {
            final Iterator objectIterator = Arrays.stream(this.result).iterator();
            return new CloseableIterator<Row>(){

                public boolean hasNext() {
                    return objectIterator.hasNext();
                }

                public Row next() {
                    Object element = objectIterator.next();
                    if (!(element instanceof Row)) {
                        if (rowConverter != null) {
                            return rowConverter.toExternal(this.toRowData(element));
                        }
                        return Row.of((Object[])new Object[]{element});
                    }
                    return (Row)element;
                }

                public void close() {
                }
            };
        }

        public RowDataToStringConverter getRowDataStringConverter() {
            return this.toStringConverter;
        }

        public boolean isFirstRowReady() {
            return true;
        }

        private Object[] toResultArray(Object result) {
            if (this.isPrimitiveArray(result)) {
                return this.toPrimitiveWrapperArray(result);
            }
            return (Object[])result;
        }

        private boolean isPrimitiveArray(Object result) {
            return result.getClass().isArray() && result.getClass().getComponentType().isPrimitive();
        }

        private Object[] toPrimitiveWrapperArray(Object primitiveArray) {
            int length = Array.getLength(primitiveArray);
            Object[] objArray = new Object[length];
            for (int i = 0; i < length; ++i) {
                objArray[i] = Array.get(primitiveArray, i);
            }
            return objArray;
        }
    }
}

