/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.materialize;

import java.util.Objects;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class LatticeTable {
    public final RelOptTable t;
    public final String alias;

    LatticeTable(RelOptTable table) {
        this.t = Objects.requireNonNull(table, "table");
        this.alias = Objects.requireNonNull(Util.last(table.getQualifiedName()));
    }

    public int hashCode() {
        return this.t.getQualifiedName().hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof LatticeTable && this.t.getQualifiedName().equals(((LatticeTable)obj).t.getQualifiedName());
    }

    public String toString() {
        return this.t.getQualifiedName().toString();
    }

    RelDataTypeField field(int i) {
        return this.t.getRowType().getFieldList().get(i);
    }
}

