/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.time.Duration;
import java.time.ZoneId;
import java.util.HashSet;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.api.internal.TableConfigValidation;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.calcite.CalciteConfig$;
import org.apache.flink.table.planner.plan.utils.OperatorType;
import org.apache.flink.table.planner.utils.AggregatePhaseStrategy;

public class TableConfigUtils {
    public static boolean isOperatorDisabled(TableConfig tableConfig, OperatorType operatorType) {
        String value = (String)tableConfig.get(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS);
        if (value == null) {
            return false;
        }
        String[] operators = value.split(",");
        HashSet<OperatorType> operatorSets = new HashSet<OperatorType>();
        for (String operator : operators) {
            if ((operator = operator.trim()).isEmpty()) continue;
            if (operator.equals("HashJoin")) {
                operatorSets.add(OperatorType.BroadcastHashJoin);
                operatorSets.add(OperatorType.ShuffleHashJoin);
                continue;
            }
            operatorSets.add(OperatorType.valueOf(operator));
        }
        return operatorSets.contains((Object)operatorType);
    }

    public static AggregatePhaseStrategy getAggPhaseStrategy(ReadableConfig tableConfig) {
        String aggPhaseConf = ((String)tableConfig.get(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY)).trim();
        if (aggPhaseConf.isEmpty()) {
            return AggregatePhaseStrategy.AUTO;
        }
        return AggregatePhaseStrategy.valueOf(aggPhaseConf);
    }

    public static CalciteConfig getCalciteConfig(TableConfig tableConfig) {
        return tableConfig.getPlannerConfig().unwrap(CalciteConfig.class).orElse(CalciteConfig$.MODULE$.DEFAULT());
    }

    public static ZoneId getLocalTimeZone(ReadableConfig tableConfig) {
        String zone = (String)tableConfig.get(TableConfigOptions.LOCAL_TIME_ZONE);
        if (((String)TableConfigOptions.LOCAL_TIME_ZONE.defaultValue()).equals(zone)) {
            return ZoneId.systemDefault();
        }
        TableConfigValidation.validateTimeZone((String)zone);
        return ZoneId.of(zone);
    }

    @Deprecated
    public static long getMaxIdleStateRetentionTime(ReadableConfig tableConfig) {
        return ((Duration)tableConfig.get(ExecutionConfigOptions.IDLE_STATE_RETENTION)).toMillis() * 3L / 2L;
    }

    private TableConfigUtils() {
    }
}

