/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.trait;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.planner.plan.trait.ModifyKind;
import org.apache.flink.types.RowKind;

public class ModifyKindSet {
    public static final ModifyKindSet INSERT_ONLY = ModifyKindSet.newBuilder().addContainedKind(ModifyKind.INSERT).build();
    public static final ModifyKindSet ALL_CHANGES = ModifyKindSet.newBuilder().addContainedKind(ModifyKind.INSERT).addContainedKind(ModifyKind.UPDATE).addContainedKind(ModifyKind.DELETE).build();
    private final Set<ModifyKind> kinds;

    private ModifyKindSet(Set<ModifyKind> kinds) {
        this.kinds = Collections.unmodifiableSet(kinds);
    }

    public Set<ModifyKind> getContainedKinds() {
        return this.kinds;
    }

    public boolean contains(ModifyKind kind) {
        return this.kinds.contains((Object)kind);
    }

    public boolean containsOnly(ModifyKind kind) {
        return this.kinds.size() == 1 && this.kinds.contains((Object)kind);
    }

    public boolean isInsertOnly() {
        return this.containsOnly(ModifyKind.INSERT);
    }

    public int size() {
        return this.kinds.size();
    }

    public boolean isEmpty() {
        return this.kinds.isEmpty();
    }

    public ModifyKindSet minus(ModifyKindSet other) {
        EnumSet<ModifyKind> result = EnumSet.noneOf(ModifyKind.class);
        result.addAll(this.kinds);
        result.removeAll(other.kinds);
        return new ModifyKindSet(result);
    }

    public ModifyKindSet intersect(ModifyKindSet other) {
        Builder builder = new Builder();
        for (ModifyKind kind : other.getContainedKinds()) {
            if (!this.contains(kind)) continue;
            builder.addContainedKind(kind);
        }
        return builder.build();
    }

    public ModifyKindSet union(ModifyKindSet other) {
        return ModifyKindSet.union(this, other);
    }

    public ChangelogMode toChangelogMode() {
        ChangelogMode.Builder builder = ChangelogMode.newBuilder();
        if (this.contains(ModifyKind.INSERT)) {
            builder.addContainedKind(RowKind.INSERT);
        }
        if (this.contains(ModifyKind.UPDATE)) {
            builder.addContainedKind(RowKind.UPDATE_BEFORE);
            builder.addContainedKind(RowKind.UPDATE_AFTER);
        }
        if (this.contains(ModifyKind.DELETE)) {
            builder.addContainedKind(RowKind.DELETE);
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifyKindSet that = (ModifyKindSet)o;
        return Objects.equals(this.kinds, that.kinds);
    }

    public int hashCode() {
        return Objects.hash(this.kinds);
    }

    public String toString() {
        if (this.kinds.isEmpty()) {
            return "NONE";
        }
        ArrayList<String> modifyKinds = new ArrayList<String>();
        if (this.contains(ModifyKind.INSERT)) {
            modifyKinds.add("I");
        }
        if (this.contains(ModifyKind.UPDATE)) {
            modifyKinds.add("U");
        }
        if (this.contains(ModifyKind.DELETE)) {
            modifyKinds.add("D");
        }
        return String.join((CharSequence)",", modifyKinds);
    }

    public static ModifyKindSet union(ModifyKindSet ... modifyKindSets) {
        Builder builder = ModifyKindSet.newBuilder();
        for (ModifyKindSet set : modifyKindSets) {
            for (ModifyKind kind : set.getContainedKinds()) {
                builder.addContainedKind(kind);
            }
        }
        return builder.build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<ModifyKind> kinds = EnumSet.noneOf(ModifyKind.class);

        private Builder() {
        }

        public Builder addContainedKind(ModifyKind kind) {
            this.kinds.add(kind);
            return this;
        }

        public ModifyKindSet build() {
            return new ModifyKindSet(this.kinds);
        }
    }
}

